/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util;

import br.com.bb.plugins.dbt.util.UtilMigracaoException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Pattern;

public class UtilValidaDadosMigracao {
    private static final String CONTE\u00daDO_IGUAL_A_ZERO = "Conte\u00fado igual a zero";
    private static final String CONTEUDO_AGENCIA_CONTA_INVALIDO = "Conte\u00fado inv\u00e1lido. V\u00e1lido: N\u00famero+X ou N\u00famero. Informado: ";
    private static final String CONTEUDO_ALFA_APENAS = "Conte\u00fado deve conter apenas caracteres alfanum\u00e9ricos. Informado: ";

    public static void validarCampoDeIndicadorNumerico(String valoresPossiveis, Integer dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dadoASerValidado == null) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        if (UtilValidaDadosMigracao.possuiIndicadorNumericoInvalido(valoresPossiveis, dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". O conte\u00fado do campo possui valor inv\u00e1lido para a nova base (deveria ser " + (valoresPossiveis != null ? valoresPossiveis.replaceAll("[^0-9]", " ou ") : "  ") + ").");
        }
    }

    public static void validarStringQueViraNumerico(int qtdCaracteres, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (UtilValidaDadosMigracao.isDadoNulo(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        if (UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, qtdCaracteres)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        if (!UtilValidaDadosMigracao.possuiApenasNumeros(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". Conte\u00fado com valor n\u00e3o num\u00e9rico. Informado: " + dadoASerValidado + ".");
        }
    }

    public static void validarStringQueViraNumericoPermiteNull(int qtdCaracteres, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dadoASerValidado != null && !dadoASerValidado.trim().equals("") && !dadoASerValidado.trim().equals("null")) {
            if (UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, qtdCaracteres)) {
                throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
            }
            if (!UtilValidaDadosMigracao.possuiApenasNumeros(dadoASerValidado)) {
                throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". Conte\u00fado com valor n\u00e3o num\u00e9rico. Informado: " + dadoASerValidado);
            }
        }
    }

    public static void validarStringSimples(int qtdCaracteres, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dadoASerValidado != null && !dadoASerValidado.trim().equals("") && !dadoASerValidado.equals("null") && UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, qtdCaracteres)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarStringCompleto(int qtdeCaracteres, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (UtilValidaDadosMigracao.isDadoNulo(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        if (UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, qtdeCaracteres)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarStringSimplesApenasAlfanumerico(int qtdCaracteres, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dadoASerValidado != null && !dadoASerValidado.trim().equals("") && !dadoASerValidado.equals("null")) {
            if (!UtilValidaDadosMigracao.isConteudoAlfanumerico(dadoASerValidado)) {
                throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". " + CONTEUDO_ALFA_APENAS + dadoASerValidado + ".");
            }
            if (UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, qtdCaracteres)) {
                throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
            }
        }
    }

    public static void validarNumeroNotNull(Integer numeroAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (numeroAserValidado == null || numeroAserValidado.equals(0)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarNumeroNotNullZeroValido(Integer numeroAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (numeroAserValidado == null) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarNumeroNotNull(Short numeroAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (numeroAserValidado == null || numeroAserValidado.equals(0)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarValorBigDecimalPodeSerNull(BigDecimal valorAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (valorAserValidado != null && !valorAserValidado.equals(new BigDecimal(0))) {
            UtilValidaDadosMigracao.validacaoDeTipoBigDecimal(valorAserValidado, motivo, nomeDoCampo);
        }
    }

    public static void validarValorBigDecimalNotNull(BigDecimal valorAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (valorAserValidado == null || valorAserValidado != null && valorAserValidado.equals(new BigDecimal(0))) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        UtilValidaDadosMigracao.validacaoDeTipoBigDecimal(valorAserValidado, motivo, nomeDoCampo);
    }

    private static void validacaoDeTipoBigDecimal(BigDecimal valorAserValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (valorAserValidado.precision() > 15) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        if (valorAserValidado.scale() > 2) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarAgenciaOuConta(int tamanhoDado, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (UtilValidaDadosMigracao.isDadoNulo(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
        UtilValidaDadosMigracao.validacaoDadosAgenciaOuConta(tamanhoDado, dadoASerValidado, motivo, nomeDoCampo);
    }

    public static void validarAgenciaOuContaPermiteNull(int tamanhoDado, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dadoASerValidado != null && !dadoASerValidado.trim().equals("") && !dadoASerValidado.trim().equals("null")) {
            UtilValidaDadosMigracao.validacaoDadosAgenciaOuConta(tamanhoDado, dadoASerValidado, motivo, nomeDoCampo);
        }
    }

    private static void validacaoDadosAgenciaOuConta(int tamanhoDado, String dadoASerValidado, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (UtilValidaDadosMigracao.isCampoZerado(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". " + CONTE\u00daDO_IGUAL_A_ZERO + ". Informado: " + dadoASerValidado + ".");
        }
        if (UtilValidaDadosMigracao.possuiValorInvalidoAgenciaConta(dadoASerValidado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ". " + CONTEUDO_AGENCIA_CONTA_INVALIDO + dadoASerValidado + ".");
        }
        if (UtilValidaDadosMigracao.isTamanhoCampoMaior(dadoASerValidado, tamanhoDado)) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    public static void validarDataNotNull(Date dataAserValidada, String motivo, String nomeDoCampo) throws UtilMigracaoException {
        if (dataAserValidada == null) {
            throw new UtilMigracaoException(nomeDoCampo, String.valueOf(motivo) + ".");
        }
    }

    private static boolean possuiIndicadorNumericoInvalido(String valoresPossiveis, Integer dadoASerValidado) {
        String[] valores;
        String[] stringArray = valores = valoresPossiveis.split(",");
        int n = valores.length;
        int n2 = 0;
        while (n2 < n) {
            String novoValor = stringArray[n2];
            if (dadoASerValidado.equals(Integer.parseInt(novoValor))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isDadoNulo(String dadoASerValidado) {
        if (dadoASerValidado == null) {
            return true;
        }
        if (dadoASerValidado.trim().equals("")) {
            return true;
        }
        return dadoASerValidado.trim().equalsIgnoreCase("null");
    }

    private static boolean isTamanhoCampoMaior(String dadoASerValidado, int qtdeCaracteres) {
        return dadoASerValidado.trim().length() > qtdeCaracteres;
    }

    private static boolean possuiApenasNumeros(String dadoASerValidado) {
        return dadoASerValidado.trim().matches("[0-9]{" + dadoASerValidado.trim().length() + "}");
    }

    private static boolean isCampoZerado(String dadoASerValidado) {
        return dadoASerValidado.trim().matches("[0]{" + dadoASerValidado.trim().length() + "}");
    }

    private static boolean possuiValorInvalidoAgenciaConta(String dadoASerValidado) {
        return !Pattern.matches("[0-9]+(x|X$)?", dadoASerValidado.trim());
    }

    private static boolean isConteudoAlfanumerico(String dadoASerValidado) {
        return dadoASerValidado.trim().matches("[a-zA-Z]{" + dadoASerValidado.trim().length() + "}");
    }
}

