/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.objecttablemodel;

import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IObjectRecebimentoRetorno
extends IObjectTableModel {
    private RecebimentoDebitoTO recebimento;
    private Map<Integer, String> mapaValores;
    private boolean itemTotal = false;

    public IObjectRecebimentoRetorno(BigDecimal total) {
        HashMap<Integer, String> mapa = new HashMap<Integer, String>();
        mapa.put(0, "TOTAL");
        mapa.put(1, "");
        mapa.put(2, "");
        mapa.put(3, "");
        mapa.put(4, "");
        mapa.put(5, "R$ " + UtilFormatadorDeReal.formatar((Number)total));
        mapa.put(6, "");
        this.setMapaValores(mapa);
        this.setItemTotal(true);
    }

    public IObjectRecebimentoRetorno() {
    }

    public IObjectRecebimentoRetorno(RecebimentoDebitoTO recebimento) {
        this.recebimento = recebimento;
    }

    public IObjectRecebimentoRetorno(String titulo, BigDecimal total) {
        HashMap<Integer, String> mapa = new HashMap<Integer, String>();
        mapa.put(0, titulo);
        mapa.put(1, "");
        mapa.put(2, "");
        mapa.put(3, "");
        mapa.put(4, "");
        mapa.put(5, "R$ " + UtilFormatadorDeReal.formatar((Number)total));
        mapa.put(6, "");
        this.setMapaValores(mapa);
        this.setItemTotal(true);
    }

    public String getColumn(int column) {
        return this.getMapaValores().get(column);
    }

    public Map<Integer, String> getMapaValores() {
        if (this.mapaValores == null) {
            this.mapaValores = new HashMap<Integer, String>();
            this.mapaValores.put(0, this.getDataDebito());
            this.mapaValores.put(1, this.getNumeroConvenio());
            this.mapaValores.put(2, this.getTextoNome());
            this.mapaValores.put(3, this.getAgencia());
            this.mapaValores.put(4, this.getConta());
            this.mapaValores.put(5, this.getValorDebito());
            this.mapaValores.put(6, this.getTextoSituacaoIdentificador());
        }
        return this.mapaValores;
    }

    public PluginTOAbstrato getTO() {
        return this.getRecebimento();
    }

    public RecebimentoDebitoTO getRecebimento() {
        return this.recebimento;
    }

    public void setRecebimento(RecebimentoDebitoTO recebimento) {
        this.recebimento = recebimento;
    }

    public String getConta() {
        return this.getRecebimento().getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + this.getRecebimento().getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente();
    }

    public String getAgencia() {
        Integer numeroAgencia = this.getRecebimento().getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia();
        Character digitoVerificador = this.getRecebimento().getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia();
        String retorno = String.valueOf(numeroAgencia);
        if (digitoVerificador != null && digitoVerificador.toString().trim().length() > 0) {
            retorno = String.valueOf(retorno) + "-" + digitoVerificador;
        }
        return retorno;
    }

    public String getDataDebito() {
        if (this.isItemTotal()) {
            return this.getMapaValores().get(0);
        }
        SimpleDateFormat dateFormat = DataFactory.getInstance().novoSimpleDateFormat("dd/MM/yyyy");
        if (this.getRecebimento().getDataRecebimento() == null) {
            return "";
        }
        return dateFormat.format(this.getRecebimento().getDataRecebimento());
    }

    public String getNumeroConvenio() {
        return UtilConversorDeInteger.converterParaString((Integer)this.getRecebimento().getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getId().getNumeroConvenio());
    }

    public String getTextoNome() {
        return this.getRecebimento().getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO().getTextoNome();
    }

    public String getTextoSituacaoIdentificador() {
        return this.getRecebimento().getSituacaoRecebimentoTO().getTextoDescricao();
    }

    public String getValorDebito() {
        if (this.isItemTotal()) {
            return this.getColumn(5);
        }
        return "R$ " + UtilFormatadorDeReal.formatar((Number)this.getRecebimento().getValorRecebimento(), (int)2);
    }

    public void setMapaValores(Map<Integer, String> mapaValores) {
        this.mapaValores = mapaValores;
    }

    public boolean isItemTotal() {
        return this.itemTotal;
    }

    public void setItemTotal(boolean itemTotal) {
        this.itemTotal = itemTotal;
    }
}

