/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.xml.kernel;

import br.com.politec.generico.colecao.IAlterador;
import br.com.politec.generico.colecao.IFiltro;
import br.com.politec.xml.kernel.FabricaKernel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.crimson.tree.TextNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomKernel
extends FabricaKernel {
    public void adicionarAtributoNoElemento(Element elemento, Attr atributo) {
        if (this.isReferencia(elemento, atributo)) {
            elemento.setAttributeNode(atributo);
        }
    }

    public void adicionarElementoNoDocumento(Document documento, Element elemento) {
        if (this.isReferencia(documento, elemento)) {
            documento.insertBefore(elemento, null);
        }
    }

    public void adicionarElementoNoElemento(Element origem, Element filho) {
        if (this.isReferencia(origem, filho)) {
            origem.insertBefore(filho, null);
        }
    }

    public Document getDocumento(InputStream xml) throws SAXException, IOException, ParserConfigurationException {
        Document resultado = null;
        if (this.isReferencia(xml)) {
            resultado = this.getDocumentBuilder(true).parse(xml);
        }
        return resultado;
    }

    public Document getDocumento(InputStream xml, boolean validar) throws SAXException, IOException, ParserConfigurationException {
        Document resultado = null;
        if (this.isReferencia(xml)) {
            resultado = this.getDocumentBuilder(validar).parse(xml);
        }
        return resultado;
    }

    public Collection getFilhos(Element elemento, IFiltro filtro, IAlterador alterador) {
        List resultado = this.getColecaoFactory().novoArrayList();
        if (this.isReferencia(elemento)) {
            NodeList nodes = elemento.getChildNodes();
            for (int indice = 0; indice < nodes.getLength(); ++indice) {
                Object node = nodes.item(indice);
                if (this.isReferencia(filtro) && !filtro.isFiltrado(node)) continue;
                if (this.isReferencia(alterador)) {
                    node = alterador.alterar(node);
                }
                resultado.add(node);
            }
        }
        return resultado;
    }

    public Element getRoot(Document documento) {
        Element resultado = null;
        if (this.isReferencia(documento)) {
            resultado = documento.getDocumentElement();
        }
        return resultado;
    }

    public Collection getElementos(Element elemento, IAlterador alterador) {
        IFiltro filtro = new IFiltro(){

            public boolean isFiltrado(Object objeto) {
                return objeto instanceof Element;
            }
        };
        return this.getFilhos(elemento, filtro, alterador);
    }

    public String getValorDoAtributo(Element elemento, String nome) {
        String resultado = null;
        if (this.isReferencia(elemento) && !this.isVazio(nome)) {
            resultado = elemento.getAttribute(nome);
        }
        return resultado;
    }

    public String getValorDoElemento(Element elemento) {
        StringBuffer resultado = new StringBuffer();
        if (this.isReferencia(elemento)) {
            IFiltro filtro = this.novoFiltroSomenteTexto();
            IAlterador alterador = this.novoAlteradorTextNodeParaString();
            Collection colecao = this.getFilhos(elemento, filtro, alterador);
            Iterator textos = colecao.iterator();
            while (textos.hasNext()) {
                resultado.append(textos.next());
            }
        }
        return resultado.toString();
    }

    private IAlterador novoAlteradorTextNodeParaString() {
        return new IAlterador(){

            public Object alterar(Object objeto) {
                String resultado = "";
                if (DomKernel.this.isReferencia(objeto) && this.isTextNode(objeto)) {
                    resultado = ((TextNode)objeto).getData();
                }
                return resultado;
            }

            private boolean isTextNode(Object objeto) {
                return objeto instanceof TextNode;
            }
        };
    }

    private IFiltro novoFiltroSomenteTexto() {
        return new IFiltro(){

            public boolean isFiltrado(Object objeto) {
                return objeto instanceof TextNode;
            }
        };
    }
}

