/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.xml.kernel;

import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.string.UtilString;
import br.com.politec.xml.constante.Constante;
import br.com.politec.xml.kernel.KernelAbstrato;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FabricaKernel
extends KernelAbstrato {
    public Attr novoAtributo(Document document, String nome) {
        Attr res = null;
        if (this.isReferencia(document) && !this.isVazio(nome)) {
            res = document.createAttribute(nome);
        }
        return res;
    }

    public Attr novoAtributo(Document document, String nome, String valor) {
        Attr res = null;
        if (this.isReferencia(document) && !this.isVazio(nome)) {
            res = this.novoAtributo(document, nome);
            res.setValue(valor);
        }
        return res;
    }

    public Document novoDocumento() throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory(false);
        return this.getDocumentBuilder(factory).newDocument();
    }

    public DOMSource novoDOMSource(Document documento) {
        DOMSource res = null;
        if (this.isReferencia(documento)) {
            res = new DOMSource(documento);
        }
        return res;
    }

    public Element novoElemento(Document document, String nome) {
        Element res = null;
        if (this.isReferencia(document) && !this.isVazio(nome)) {
            res = document.createElement(nome);
        }
        return res;
    }

    public EntityResolver novoEntityResolverVazio() {
        return new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(UtilString.getReader((String)""));
            }
        };
    }

    public StreamSource novoStreamSource(InputStream fonte) {
        StreamSource res = null;
        if (this.isReferencia(fonte)) {
            res = new StreamSource(fonte);
        }
        return res;
    }

    public Transformer novoTransformer() throws TransformerConfigurationException {
        String path = Constante.getPathArquivoTransformacaoProperties();
        Properties properties = UtilArquivo.getProperties((String)path);
        Transformer transformer = this.getTransformerFactory().newTransformer();
        transformer.setOutputProperties(properties);
        return transformer;
    }

    public Transformer novoTransformer(Source xslSource) throws TransformerConfigurationException {
        Transformer res = null;
        if (this.isReferencia(xslSource)) {
            res = this.getTransformerFactory().newTransformer(xslSource);
        }
        return res;
    }

    protected DocumentBuilder getDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (!factory.isValidating()) {
            builder.setEntityResolver(this.novoEntityResolverVazio());
        }
        return builder;
    }

    protected DocumentBuilder getDocumentBuilder(boolean validar) throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory(validar);
        return this.getDocumentBuilder(factory);
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory(boolean validar) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validar);
        return factory;
    }

    protected TransformerFactory getTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    public StreamResult novoStreamResult(OutputStream output) {
        return new StreamResult(output);
    }
}

