/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;

public class WaitableLong
extends SynchronizedLong {
    public WaitableLong(long initialValue) {
        super(initialValue);
    }

    public WaitableLong(long initialValue, Object lock) {
        super(initialValue, lock);
    }

    public long set(long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.set(newValue);
            return l;
        }
    }

    public boolean commit(long assumedValue, long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            boolean bl = success;
            return bl;
        }
    }

    public long increment() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.increment();
            return l;
        }
    }

    public long decrement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.decrement();
            return l;
        }
    }

    public long add(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.add(amount);
            return l;
        }
    }

    public long subtract(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.subtract(amount);
            return l;
        }
    }

    public long multiply(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.multiply(factor);
            return l;
        }
    }

    public long divide(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            long l = super.divide(factor);
            return l;
        }
    }

    public void whenEqual(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(long c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

