/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.firebirdsql.gds.impl.GDSServerVersionException;

public class GDSServerVersion
implements Serializable {
    public static final String TYPE_PRODUCTION = "V";
    public static final String TYPE_BETA = "T";
    public static final String TYPE_DEVELOPMENT = "X";
    private String rawStr;
    private String platform;
    private String type;
    private int majorVersion;
    private int minorVersion;
    private int variant;
    private int buildNumber;
    private String serverName;
    private String extendedServerName;

    public GDSServerVersion(String rawStr) throws GDSServerVersionException {
        this.rawStr = rawStr;
        this.parseRawStr(rawStr);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getType() {
        return this.type;
    }

    public int getVariant() {
        return this.variant;
    }

    public String getExtendedServerName() {
        return this.extendedServerName;
    }

    public int hashCode() {
        return this.rawStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GDSServerVersion)) {
            return false;
        }
        GDSServerVersion that = (GDSServerVersion)obj;
        return this.rawStr.equals(that.rawStr);
    }

    public String toString() {
        return this.rawStr;
    }

    private void parseRawStr(String str) throws GDSServerVersionException {
        String platformVersionStr;
        int dashPosition;
        int firstSpacePosition = str.indexOf(32);
        if (firstSpacePosition == -1) {
            throw new GDSServerVersionException("No server name is available.");
        }
        this.serverName = str.substring(firstSpacePosition + 1);
        int commaPosition = this.serverName.indexOf(44);
        if (commaPosition != -1) {
            this.extendedServerName = this.serverName.substring(commaPosition + 1);
            this.serverName = this.serverName.substring(0, commaPosition);
        }
        if ((dashPosition = (platformVersionStr = str.substring(0, firstSpacePosition)).indexOf(45)) == -1) {
            throw new GDSServerVersionException("No platform/version available.");
        }
        this.platform = platformVersionStr.substring(0, dashPosition);
        this.type = platformVersionStr.substring(dashPosition + 1, dashPosition + 2);
        String versionStr = platformVersionStr.substring(dashPosition + 2);
        try {
            StringTokenizer st = new StringTokenizer(versionStr, ".");
            String majorVersionStr = st.nextToken();
            String minorVersionStr = st.nextToken();
            String variantStr = st.nextToken();
            String buildNumStr = st.nextToken();
            this.majorVersion = Integer.parseInt(majorVersionStr);
            this.minorVersion = Integer.parseInt(minorVersionStr);
            this.variant = Integer.parseInt(variantStr);
            this.buildNumber = Integer.parseInt(buildNumStr);
        }
        catch (NoSuchElementException ex) {
            throw new GDSServerVersionException("One of the version components not available: " + str);
        }
        catch (NumberFormatException ex) {
            throw new GDSServerVersionException("One of the version components not a number : " + str);
        }
    }
}

