/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.AbstractIscDbHandle;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBManagedConnectionMetaData;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FatalGDSErrorHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBManagedConnection
implements ManagedConnection,
XAResource,
GDSHelper.GDSHelperErrorListener {
    private static final Logger log = LoggerFactory.getLogger(FBManagedConnection.class, false);
    private FBManagedConnectionFactory mcf;
    private ArrayList connectionEventListeners = new ArrayList();
    private ArrayList connectionHandles = new ArrayList();
    private int timeout = 0;
    private Map xidMap = new HashMap();
    private GDS gds;
    private IscDbHandle dbHandle;
    private GDSHelper gdsHelper;
    private FBConnectionRequestInfo cri;
    private FBTpb tpb;
    private int transactionIsolation;
    private boolean managedEnvironment = true;
    private boolean connectionSharing = true;
    static final CELNotifier connectionClosedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionClosed(ce);
        }
    };
    static final CELNotifier connectionErrorOccurredNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionErrorOccurred(ce);
        }
    };
    static final CELNotifier localTransactionStartedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionStarted(ce);
        }
    };
    static final CELNotifier localTransactionCommittedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionCommitted(ce);
        }
    };
    static final CELNotifier localTransactionRolledbackNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionRolledback(ce);
        }
    };

    FBManagedConnection(Subject subject, ConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws ResourceException {
        this.mcf = mcf;
        this.gds = mcf.getGDS();
        this.cri = this.getCombinedConnectionRequestInfo(subject, cri);
        this.tpb = mcf.getDefaultTpb();
        this.transactionIsolation = mcf.getDefaultTransactionIsolation();
        try {
            this.dbHandle = this.gds.createIscDbHandle();
            DatabaseParameterBuffer dpb = this.cri.getDpb();
            this.gds.iscAttachDatabase(mcf.getDatabase(), this.dbHandle, dpb);
            this.gdsHelper = new GDSHelper(this.gds, dpb, (AbstractIscDbHandle)this.dbHandle, this);
        }
        catch (GDSException ex) {
            throw new FBResourceException(ex);
        }
    }

    public void errorOccured(GDSException ex) {
        if (log != null) {
            log.trace(ex.getMessage());
        }
        if (!FatalGDSErrorHelper.isFatal(ex)) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(this, 5, ex);
        this.notify(connectionErrorOccurredNotifier, event);
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            cri = this.mcf.getDefaultConnectionRequestInfo();
        }
        try {
            FBConnectionRequestInfo fbcri = (FBConnectionRequestInfo)cri;
            if (subject != null) {
                for (Object cred : subject.getPrivateCredentials()) {
                    if (!(cred instanceof PasswordCredential) || !this.equals(((PasswordCredential)cred).getManagedConnectionFactory())) continue;
                    PasswordCredential pcred = (PasswordCredential)cred;
                    String user = pcred.getUserName();
                    String password = new String(pcred.getPassword());
                    fbcri.setPassword(password);
                    fbcri.setUserName(user);
                    break;
                }
            }
            return fbcri;
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("Incorrect ConnectionRequestInfo class supplied");
        }
    }

    public GDSHelper getGDSHelper() throws GDSException {
        if (this.gdsHelper == null) {
            throw new GDSException(1, 335544363);
        }
        return this.gdsHelper;
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnvironment;
    }

    public boolean inTransaction() {
        return this.gdsHelper.inTransaction();
    }

    public void setManagedEnvironment(boolean managedEnvironment) throws ResourceException {
        this.managedEnvironment = managedEnvironment;
        if (!this.connectionSharing) {
            if (this.connectionHandles.size() > 1) {
                throw new IllegalStateException("Multiple connections associated with this managed connection in non-sharing mode.");
            }
            for (AbstractConnection connection : this.connectionHandles) {
                try {
                    connection.setManagedEnvironment(managedEnvironment);
                }
                catch (SQLException ex) {
                    throw new FBResourceException(ex);
                }
            }
        }
    }

    public boolean isConnectionSharing() {
        return this.connectionSharing;
    }

    public void setConnectionSharing(boolean connectionSharing) {
        if (!this.connectionHandles.isEmpty()) {
            throw new IllegalStateException("Cannot change connection sharing with active connection handles.");
        }
        this.connectionSharing = connectionSharing;
    }

    public LocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this, null);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new FBManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        try {
            ((AbstractConnection)connection).setManagedConnection(this);
            this.connectionHandles.add(connection);
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("invalid connection supplied to associateConnection.", cce);
        }
    }

    public void cleanup() throws ResourceException {
        this.disassociateConnections();
        this.gdsHelper.setCurrentTrHandle(null);
        this.tpb = this.mcf.getDefaultTpb();
        this.transactionIsolation = this.mcf.getDefaultTransactionIsolation();
    }

    private void disassociateConnections() throws ResourceException {
        ResourceException ex = null;
        for (AbstractConnection connection : this.connectionHandles) {
            try {
                connection.close();
            }
            catch (SQLException sqlex) {
                if (ex == null) {
                    ex = new FBResourceException(sqlex);
                    continue;
                }
                ((SQLException)ex.getLinkedException()).setNextException(sqlex);
            }
        }
        this.connectionHandles.clear();
        if (ex != null) {
            throw ex;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.matches(subject, cri)) {
            throw new FBResourceException("Incompatible subject or ConnectionRequestInfo in getConnection!");
        }
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        AbstractConnection c = this.mcf.newConnection(this);
        try {
            c.setManagedEnvironment(this.isManagedEnvironment());
            this.connectionHandles.add(c);
            return c;
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public void destroy() throws ResourceException {
        if (this.gdsHelper == null) {
            return;
        }
        if (this.gdsHelper.inTransaction()) {
            throw new IllegalStateException("Can't destroy managed connection  with active transaction");
        }
        try {
            this.gdsHelper.detachDatabase();
        }
        catch (GDSException ge) {
            throw new FBResourceException("Can't detach from db.", ge);
        }
        finally {
            this.gdsHelper = null;
        }
    }

    public XAResource getXAResource() {
        if (log != null) {
            log.debug("XAResource requested from FBManagedConnection");
        }
        return this;
    }

    boolean isXidActive(Xid xid) {
        IscTrHandle trHandle = (IscTrHandle)this.xidMap.get(xid);
        if (trHandle == null) {
            return false;
        }
        AbstractIscDbHandle dbHandle = (AbstractIscDbHandle)trHandle.getDbHandle();
        if (dbHandle == null) {
            return false;
        }
        return dbHandle.isValid();
    }

    public void commit(Xid id, boolean onePhase) throws XAException {
        try {
            this.mcf.notifyCommit(this, id, onePhase);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    void internalCommit(Xid xid, boolean onePhase) throws XAException, GDSException {
        AbstractIscTrHandle committingTr;
        if (log != null) {
            log.trace("Commit called: " + xid);
        }
        if ((committingTr = (AbstractIscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Commit called with current xid", -6);
        }
        try {
            committingTr.forgetResultSets();
            try {
                this.gdsHelper.commitTransaction(committingTr);
            }
            catch (GDSException ge) {
                block13: {
                    try {
                        this.gdsHelper.rollbackTransaction(committingTr);
                    }
                    catch (GDSException ge2) {
                        if (log == null) break block13;
                        log.debug("Exception rolling back failed tx: ", ge2);
                    }
                }
                throw ge;
            }
            finally {
                this.xidMap.remove(xid);
            }
        }
        catch (GDSException ge) {
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    public void end(Xid id, int flags) throws XAException {
        if (flags != 0x2000000 && flags != 0x4000000 && flags != 0x20000000) {
            throw new FBXAException("Invalid flag in end: must be TMSUSPEND, TMSUCCESS, or TMFAIL", -5);
        }
        this.internalEnd(id, flags);
        this.mcf.notifyEnd(this, id);
    }

    void internalEnd(Xid xid, int flags) throws XAException {
        IscTrHandle endingTr;
        if (log != null) {
            log.debug("End called: " + xid);
        }
        if ((endingTr = (IscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        if (endingTr == this.gdsHelper.getCurrentTrHandle()) {
            this.gdsHelper.setCurrentTrHandle(null);
        } else if (flags == 0x2000000) {
            throw new FBXAException("You are trying to suspend a transaction that is not the current transaction", -5);
        }
    }

    public void forget(Xid id) throws XAException {
        throw new FBXAException("Not yet implemented");
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res instanceof FBManagedConnection && this.dbHandle.equals(((FBManagedConnection)res).dbHandle);
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.mcf.notifyPrepare(this, xid);
        }
        catch (GDSException ge) {
            throw new FBXAException(-3, ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalPrepare(Xid xid) throws FBXAException, GDSException {
        AbstractIscTrHandle committingTr;
        if (log != null) {
            log.trace("prepare called: " + xid);
        }
        if ((committingTr = (AbstractIscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Prepare called with unknown transaction", -5);
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Prepare called with current xid", -6);
        }
        try {
            FBXid fbxid = xid instanceof FBXid ? (FBXid)xid : new FBXid(xid);
            byte[] message = fbxid.toBytes();
            this.gdsHelper.prepareTransaction(committingTr, message);
        }
        catch (GDSException ge) {
            try {
                this.gdsHelper.rollbackTransaction(committingTr);
            }
            catch (GDSException ge2) {
                if (log != null) {
                    log.debug("Exception rolling back failed tx: ", ge2);
                }
            }
            finally {
                this.xidMap.remove(xid);
            }
            if (log != null) {
                log.warn("error in prepare", ge);
            }
            throw ge;
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            AbstractIscTrHandle trHandle2 = (AbstractIscTrHandle)this.gds.createIscTrHandle();
            this.gds.iscStartTransaction(trHandle2, this.gdsHelper.getCurrentDbHandle(), this.tpb.getTransactionParameterBuffer());
            GDSHelper gdsHelper2 = new GDSHelper(this.gds, this.gdsHelper.getDatabaseParameterBuffer(), (AbstractIscDbHandle)this.gdsHelper.getCurrentDbHandle(), null);
            gdsHelper2.setCurrentTrHandle(trHandle2);
            ArrayList xids = FBManagedConnectionFactory.fetchInLimboXids(this.gds, gdsHelper2);
            this.gds.iscCommitTransaction(trHandle2);
            return xids.toArray(new FBXid[xids.size()]);
        }
        catch (GDSException ex) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", ex);
            }
            throw new FBXAException(-7, ex);
        }
        catch (SQLException sqle) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", sqle);
            }
            throw new FBXAException(-7, sqle);
        }
        catch (ResourceException re) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", re);
            }
            throw new FBXAException(-7, re);
        }
    }

    public void rollback(Xid id) throws XAException {
        try {
            this.mcf.notifyRollback(this, id);
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode(), ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRollback(Xid xid) throws XAException, GDSException {
        AbstractIscTrHandle committingTr;
        if (log != null) {
            log.trace("rollback called: " + xid);
        }
        if ((committingTr = (AbstractIscTrHandle)this.xidMap.get(xid)) == null) {
            if (log != null) {
                log.warn("rollback called with unknown transaction: " + xid);
            }
            return;
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Rollback called with current xid", -6);
        }
        try {
            committingTr.forgetResultSets();
            try {
                this.gdsHelper.rollbackTransaction(committingTr);
            }
            finally {
                this.xidMap.remove(xid);
            }
        }
        catch (GDSException ge) {
            if (log != null) {
                log.debug("Exception in rollback", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public void start(Xid id, int flags) throws XAException {
        try {
            this.setTransactionIsolation(this.mcf.getDefaultTransactionIsolation());
            this.internalStart(id, flags);
            this.mcf.notifyStart(this, id);
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode());
        }
        catch (ResourceException ex) {
            throw new FBXAException(-3, ex);
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, GDSException {
        if (log != null) {
            log.trace("start called: " + id);
        }
        if (this.gdsHelper.getCurrentTrHandle() != null) {
            throw new XAException(-6);
        }
        this.findIscTrHandle(id, flags);
    }

    public void close(AbstractConnection c) {
        c.setManagedConnection(null);
        this.connectionHandles.remove(c);
        ConnectionEvent ce = new ConnectionEvent(this, 1, null);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public TransactionParameterBuffer getTransactionParameters() {
        return this.tpb.getTransactionParameterBuffer();
    }

    public void setTransactionParameters(TransactionParameterBuffer transactionParameters) {
        this.tpb.setTransactionParameterBuffer(transactionParameters);
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.mcf.getTransactionParameters(isolation);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer transactionParams) {
        this.mcf.setTransactionParameters(isolation, transactionParams);
    }

    private void findIscTrHandle(Xid xid, int flags) throws GDSException, XAException {
        this.gdsHelper.setCurrentTrHandle(null);
        AbstractIscTrHandle trHandle = (AbstractIscTrHandle)this.xidMap.get(xid);
        if (trHandle != null) {
            if (flags != 0x200000 && flags != 0x8000000) {
                throw new FBXAException("You are trying to start a transaction as new that is already known to this XAResource", -5);
            }
            this.gdsHelper.setCurrentTrHandle(trHandle);
            return;
        }
        if (flags != 0) {
            throw new FBXAException("You are trying to resume a transaction that has is new", -5);
        }
        trHandle = this.gdsHelper.startTransaction(this.tpb.getTransactionParameterBuffer());
        this.xidMap.put(xid, trHandle);
    }

    void notify(CELNotifier notifier, ConnectionEvent ce) {
        if (this.connectionEventListeners.size() == 0) {
            return;
        }
        if (this.connectionEventListeners.size() == 1) {
            ConnectionEventListener cel = (ConnectionEventListener)this.connectionEventListeners.get(0);
            notifier.notify(cel, ce);
            return;
        }
        ArrayList cels = (ArrayList)this.connectionEventListeners.clone();
        Iterator i = cels.iterator();
        while (i.hasNext()) {
            notifier.notify((ConnectionEventListener)i.next(), ce);
        }
    }

    boolean matches(Subject subj, ConnectionRequestInfo cri) {
        if (cri == null) {
            return true;
        }
        if (!(cri instanceof FBConnectionRequestInfo)) {
            return false;
        }
        try {
            return this.cri.equals(this.getCombinedConnectionRequestInfo(subj, (FBConnectionRequestInfo)cri));
        }
        catch (ResourceException re) {
            return false;
        }
    }

    public int getTransactionIsolation() throws ResourceException {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int isolation) throws ResourceException {
        this.transactionIsolation = isolation;
        this.tpb = this.mcf.getTpb(isolation);
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    static interface CELNotifier {
        public void notify(ConnectionEventListener var1, ConnectionEvent var2);
    }
}

