/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.toplink.ServerSessionFactory;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SingleSessionFactory;
import org.springframework.util.ReflectionUtils;

public class LocalSessionFactory {
    public static final String DEFAULT_SESSIONS_XML = "sessions.xml";
    public static final String DEFAULT_SESSION_NAME = "Session";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String configLocation = "sessions.xml";
    private String sessionName = "Session";
    private ClassLoader sessionClassLoader;
    private DatabaseLogin databaseLogin;
    private DataSource dataSource;
    private DatabasePlatform databasePlatform;
    private SessionLog sessionLog;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$oracle$toplink$tools$sessionmanagement$SessionManager;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionClassLoader(ClassLoader sessionClassLoader) {
        this.sessionClassLoader = sessionClassLoader;
    }

    public void setDatabaseLogin(DatabaseLogin databaseLogin) {
        this.databaseLogin = databaseLogin;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = sessionLog;
    }

    public SessionFactory createSessionFactory() throws TopLinkException {
        DatabaseSession session;
        ClassLoader classLoader;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing TopLink SessionFactory from [" + this.configLocation + "]"));
        }
        if ((classLoader = this.sessionClassLoader) == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((session = this.loadDatabaseSession(this.configLocation, this.sessionName, classLoader)) == null) {
            this.logger.info((Object)("A session named " + this.sessionName + " could not be loaded from resource " + this.configLocation + " using ClassLoader " + classLoader));
            this.logger.info((Object)("This is most likely a deployment issue.  Can the sessionClassLoader load the " + this.configLocation + " with a getResourceAsStream call?"));
            throw new RuntimeException("A session named " + this.sessionName + " could not be loaded from resource " + this.configLocation + " using ClassLoader " + classLoader);
        }
        if (this.databaseLogin != null) {
            session.setLogin(this.databaseLogin);
        }
        if (this.dataSource != null) {
            session.getLogin().setConnector((Connector)new JNDIConnector(this.dataSource));
            session.getLogin().setUsesExternalConnectionPooling(true);
        }
        if (this.databasePlatform != null) {
            session.getLogin().usePlatform(this.databasePlatform);
        }
        if (this.sessionLog != null) {
            session.setSessionLog(this.sessionLog);
            session.logMessages();
        }
        session.login();
        return this.newSessionFactory(session);
    }

    protected DatabaseSession loadDatabaseSession(String configLocation, String sessionName, ClassLoader sessionClassLoader) throws TopLinkException {
        SessionManager manager = SessionManager.getManager();
        Class<?> loaderClass = null;
        Method getSessionMethod = null;
        try {
            loaderClass = Class.forName("oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader");
            getSessionMethod = (class$oracle$toplink$tools$sessionmanagement$SessionManager == null ? (class$oracle$toplink$tools$sessionmanagement$SessionManager = LocalSessionFactory.class$("oracle.toplink.tools.sessionmanagement.SessionManager")) : class$oracle$toplink$tools$sessionmanagement$SessionManager).getMethod("getSession", loaderClass, class$java$lang$String == null ? (class$java$lang$String = LocalSessionFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = LocalSessionFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, Boolean.TYPE, Boolean.TYPE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 10.1.3 XMLSessionConfigLoader");
            }
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 9.0.4 XMLLoader");
            }
            XMLLoader loader = new XMLLoader(configLocation);
            return (DatabaseSession)manager.getSession(loader, sessionName, sessionClassLoader, false, false);
        }
        try {
            Constructor<?> ctor = loaderClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = LocalSessionFactory.class$("java.lang.String")) : class$java$lang$String);
            Object loader = ctor.newInstance(configLocation);
            return (DatabaseSession)getSessionMethod.invoke((Object)manager, loader, sessionName, sessionClassLoader, Boolean.FALSE, Boolean.FALSE);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    protected SessionFactory newSessionFactory(DatabaseSession session) {
        if (session instanceof ServerSession) {
            return new ServerSessionFactory((ServerSession)session);
        }
        return new SingleSessionFactory((Session)session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

