/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.generico.string.UtilString;
import br.com.politec.reflexao.UtilReflexaoFabrica;
import br.com.politec.reflexao.UtilReflexaoInvocarMetodo;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.UtilReflexaoSet;
import br.com.politec.reflexao.constante.Dominio;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.kernel.KernelAbstrato;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConversorKernel
extends KernelAbstrato {
    public Map beanParaMapa(Object objeto) throws ReflexaoException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.isReferencia(objeto)) {
            Method metodo = null;
            String atributo = null;
            Object valor = null;
            Class<?> classe = objeto.getClass();
            Iterator metodos = UtilReflexaoMetodo.getMetodosGet(classe).iterator();
            while (metodos.hasNext()) {
                metodo = (Method)metodos.next();
                atributo = this.converteNomeDeMetodoEmNomeDeAtributo(metodo.getName());
                valor = UtilReflexaoInvocarMetodo.invocar(objeto, metodo);
                res.put(atributo, valor);
            }
        }
        return res;
    }

    public Object mapaParaBean(Class classe, Map mapa) throws ReflexaoException {
        Object res = null;
        if (this.isReferencia(classe, mapa)) {
            res = UtilReflexaoFabrica.novoObjeto(classe);
            String atributo = null;
            Object valor = null;
            Iterator atributos = mapa.keySet().iterator();
            while (atributos.hasNext()) {
                atributo = (String)atributos.next();
                valor = mapa.get(atributo);
                UtilReflexaoSet.set(res, atributo, valor);
            }
        }
        return res;
    }

    public String converteNomeDeMetodoEmNomeDeAtributo(String nomeDoMetodo) {
        StringBuffer nome = new StringBuffer();
        if (!this.isVazio(nomeDoMetodo)) {
            nomeDoMetodo = this.removePrefixo(nomeDoMetodo, this.getPrefixoMetodoGet());
            nomeDoMetodo = this.removePrefixo(nomeDoMetodo, this.getPrefixoMetodoIs());
            nome.append(UtilString.minuscula((char)nomeDoMetodo.charAt(0)));
            if (nomeDoMetodo.length() > 1) {
                nome.append(nomeDoMetodo.substring(1));
            }
        }
        return nome.toString();
    }

    private String removePrefixo(String nomeDoMetodo, String prefixo) {
        if (!this.isVazio(nomeDoMetodo) && nomeDoMetodo.startsWith(prefixo)) {
            nomeDoMetodo = nomeDoMetodo.substring(prefixo.length());
        }
        return nomeDoMetodo;
    }

    private String getPrefixoMetodoGet() {
        return Dominio.getPrefixoMetodoGet();
    }

    private String getPrefixoMetodoIs() {
        return Dominio.getPrefixoMetodoIs();
    }
}

