/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.estrategiajdbc.EstrategiaJDBC;
import br.com.politec.estrategiajdbc.EstrategiaJDBCFactory;
import br.com.politec.estrategiajdbc.EstrategiaJDBCFactoryPadrao;
import br.com.politec.estrategiajdbc.excecao.EstrategiaJDBCException;
import br.com.politec.generico.conversor.instancia.IConversor;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.jdbc.UtilJdbc;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.reflexao.UtilReflexaoFabrica;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.UtilReflexaoSet;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.kernel.KernelAbstrato;
import br.com.politec.reflexao.util.UtilReflexaoException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JDBCKernel
extends KernelAbstrato {
    public Object montarObjeto(ResultSet rs, Class classe, Map conversores, boolean proximoRegistro) throws ReflexaoException {
        Object resultado = null;
        boolean bl = proximoRegistro = proximoRegistro ? this.isProximoRegistro(rs) : true;
        if (this.isReferencia(rs, classe) && proximoRegistro) {
            resultado = UtilReflexaoFabrica.novoObjeto(classe);
            Object valor = null;
            ResultSetMetaData mData = UtilJdbc.getMetaData((ResultSet)rs);
            int quantidade = UtilJdbc.getColunas((ResultSetMetaData)mData);
            for (int indice = 1; indice <= quantidade; ++indice) {
                String coluna = UtilJdbc.getNomeDaColuna((ResultSetMetaData)mData, (int)indice);
                if (this.isExisteConversorParaColuna(conversores, coluna)) {
                    valor = this.getObjetoComConversor(rs, coluna, indice, conversores);
                } else {
                    int tipo = UtilJdbc.getCodigoDoTipoDaColuna((ResultSetMetaData)mData, (int)indice);
                    valor = this.getObjeto(rs, tipo, indice);
                }
                this.atribuirValorNoObjeto(resultado, coluna, valor);
            }
        }
        return resultado;
    }

    public Collection montarColecao(ResultSet rs, Class classe, Map conversores) throws ReflexaoException {
        List resultado = this.getColecaoFactory().novoArrayList();
        if (this.isReferencia(rs, classe)) {
            while (this.isProximoRegistro(rs)) {
                resultado.add(this.montarObjeto(rs, classe, conversores, false));
            }
        }
        return resultado;
    }

    protected Object getObjetoComConversor(ResultSet rs, String coluna, int indice, Map conversores) throws ReflexaoException {
        Object resultado = null;
        try {
            IConversor conversor = (IConversor)conversores.get(coluna);
            Class tipo = conversor.getTipoDeOrigem();
            resultado = this.getObjeto(rs, tipo, indice);
            resultado = conversor.converter(resultado);
        }
        catch (ConversorException e) {
            throw UtilReflexaoException.erro(e);
        }
        return resultado;
    }

    protected Object getObjeto(ResultSet resultSet, int tipo, int indice) throws ReflexaoException {
        EstrategiaJDBC estrategia = this.getEstrategiaJDBC(tipo);
        try {
            return estrategia.getObjeto(resultSet, indice);
        }
        catch (EstrategiaJDBCException e) {
            throw UtilReflexaoException.erro(e);
        }
    }

    protected Object getObjeto(ResultSet resultSet, Class tipo, int indice) throws ReflexaoException {
        EstrategiaJDBC estrategia = this.getEstrategiaJDBC(tipo);
        try {
            return estrategia.getObjeto(resultSet, indice);
        }
        catch (EstrategiaJDBCException e) {
            throw UtilReflexaoException.erro(e);
        }
    }

    protected void atribuirValorNoObjeto(Object objeto, String coluna, Object valor) throws ReflexaoException {
        Class classe = UtilObjeto.getClasse((Object)objeto);
        if (UtilReflexaoMetodo.isExisteMetodoSet(classe, coluna)) {
            UtilReflexaoSet.set(objeto, coluna, valor);
        }
    }

    protected boolean isExisteConversorParaColuna(Map conversores, String coluna) {
        return this.isReferencia(conversores) && conversores.containsKey(coluna);
    }

    protected boolean isProximoRegistro(ResultSet resultSet) {
        return UtilJdbc.isProximoRegistro((ResultSet)resultSet);
    }

    protected EstrategiaJDBC getEstrategiaJDBC(int tipo) {
        return this.getEstrategiaJDBCFactory().getEstrategia(tipo);
    }

    protected EstrategiaJDBC getEstrategiaJDBC(Class tipo) {
        return this.getEstrategiaJDBCFactory().getEstrategia(tipo);
    }

    protected EstrategiaJDBCFactory getEstrategiaJDBCFactory() {
        return EstrategiaJDBCFactoryPadrao.getInstancia();
    }
}

