/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.reflexao.UtilReflexaoFabrica;
import br.com.politec.reflexao.UtilReflexaoGet;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.UtilReflexaoSet;
import br.com.politec.reflexao.constante.Dominio;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.util.IExecutor;
import br.com.politec.reflexao.util.UtilAtributo;
import br.com.politec.reflexao.util.UtilReflexaoException;
import java.lang.reflect.Method;

public abstract class KernelAbstrato {
    protected boolean isVazio(String string) {
        return UtilString.isVazio((String)string);
    }

    protected boolean isVazio(String string1, String string2) {
        return UtilString.isVazio((String)string1, (String)string2);
    }

    protected boolean isVazio(String string1, String string2, String string3) {
        return UtilString.isVazio((String)string1, (String)string2, (String)string3);
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia((Object)objeto);
    }

    protected boolean isReferencia(Object objeto, Object objeto2) {
        return UtilObjeto.isReferencia((Object)objeto, (Object)objeto2);
    }

    protected boolean isReferencia(Object objeto, Object objeto2, Object objeto3) {
        return UtilObjeto.isReferencia((Object)objeto, (Object)objeto2, (Object)objeto3);
    }

    protected Object loopPath(Object objeto, String path, Object valor, IExecutor executor) throws Exception {
        Object resposta = null;
        if (this.isReferencia(objeto, executor)) {
            if (this.isCaminho(path)) {
                String atributo = UtilAtributo.getPrimeiroAtributo(path);
                String atributos = UtilAtributo.getUltimosAtributos(path);
                resposta = UtilReflexaoGet.get(objeto, atributo);
                resposta = this.criarEAtribuirObjetoNulo(resposta, objeto, atributo);
                resposta = this.loopPath(resposta, atributos, valor, executor);
            } else {
                resposta = executor.getObjeto(objeto, path, valor);
            }
        }
        return resposta;
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected Object loopPath(Class classe, String path, Object valor, IExecutor executor) throws Exception {
        Object resposta = null;
        if (this.isReferencia(classe, executor)) {
            Object objeto = classe;
            if (this.isCaminho(path)) {
                objeto = UtilReflexaoFabrica.novoObjeto(classe);
            }
            return this.loopPath(objeto, path, valor, executor);
        }
        return resposta;
    }

    protected String getNomeDoMetodo(String atributo, String prefixo) {
        String nomeDoMetodo = null;
        if (!this.isVazio(atributo) && !atributo.startsWith(prefixo)) {
            nomeDoMetodo = UtilString.getNomeMetodo((String)prefixo, (String)atributo);
        }
        return nomeDoMetodo;
    }

    protected boolean isCaminho(String path) throws ReflexaoException {
        boolean resposta = false;
        if (this.isVazio(path)) {
            throw UtilReflexaoException.pathDoAtributoVazio();
        }
        resposta = UtilString.isTemString((String)path, (String)".");
        return resposta;
    }

    protected String adicionarPrefixo(String atributo, String prefixo) {
        return UtilAtributo.adicionarPrefixo(atributo, prefixo);
    }

    private Object criarEAtribuirObjetoNulo(Object res, Object objeto, String nomeDoAtributo) throws ReflexaoException {
        if (!this.isReferencia(res) && this.isReferencia(objeto) && !this.isVazio(nomeDoAtributo)) {
            String nome = UtilString.getNomeMetodo((String)Dominio.getPrefixoMetodoGet(), (String)nomeDoAtributo);
            Method metodo = UtilReflexaoMetodo.getMetodo(objeto.getClass(), nome);
            res = UtilReflexaoFabrica.novoObjeto(metodo.getReturnType());
            UtilReflexaoSet.set(objeto, nomeDoAtributo, res);
        }
        return res;
    }
}

