/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.kernel;

import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.generico.validador.UtilValidadorDeStringsIguais;
import br.com.politec.reflexao.constante.Dominio;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.kernel.KernelAbstrato;
import br.com.politec.reflexao.util.IExecutor;
import br.com.politec.reflexao.util.UtilReflexaoException;
import br.com.politec.reflexao.util.to.MetodoTO;
import br.com.politec.reflexao.util.to.MetodoTOFactory;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MetodoKernel
extends KernelAbstrato {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public Collection getMetodos(Class classe) {
        List colecao = this.getColecaoFactory().novoArrayList();
        if (this.isReferencia(classe)) {
            Method[] metodos = classe.getMethods();
            for (int indice = 0; indice < metodos.length; ++indice) {
                if (metodos[indice].getDeclaringClass() == (class$java$lang$Object == null ? MetodoKernel.class$("java.lang.Object") : class$java$lang$Object)) continue;
                colecao.add(metodos[indice]);
            }
        }
        return colecao;
    }

    public Collection getMetodosGet(Class classe) {
        List res = this.getColecaoFactory().novoArrayList();
        Method metodo = null;
        Iterator metodos = this.getColecaoFactory().novoIterator(this.getMetodos(classe));
        while (metodos.hasNext()) {
            metodo = (Method)metodos.next();
            if (!this.isMetodoGet(metodo)) continue;
            res.add(metodo);
        }
        return res;
    }

    public Collection getMetodosSet(Class classe) {
        List res = this.getColecaoFactory().novoArrayList();
        Method metodo = null;
        Iterator metodos = this.getColecaoFactory().novoIterator(this.getMetodos(classe));
        while (metodos.hasNext()) {
            metodo = (Method)metodos.next();
            if (!this.isMetodoSet(metodo)) continue;
            res.add(metodo);
        }
        return res;
    }

    public boolean isMetodoGet(Method metodo) {
        boolean resultado = false;
        if (this.isReferencia(metodo)) {
            String nome = metodo.getName();
            String get = Dominio.getPrefixoMetodoGet();
            String is = Dominio.getPrefixoMetodoIs();
            resultado = nome.startsWith(get) || nome.startsWith(is);
        }
        return resultado;
    }

    public boolean isMetodoSet(Method metodo) {
        boolean resultado = false;
        if (this.isReferencia(metodo)) {
            String nome = metodo.getName();
            String set = Dominio.getPrefixoMetodoSet();
            Class<?>[] parametros = metodo.getParameterTypes();
            resultado = nome.startsWith(set) && parametros.length == 1;
        }
        return resultado;
    }

    public MetodoTO getMetodoDoPath(Object objeto, String metodo, Class tipoDoParametro) throws Exception {
        MetodoTO to = null;
        IExecutor executor = this.novoExecutorDeRetornoDeMetodo();
        to = (MetodoTO)this.loopPath(objeto, metodo, (Object)tipoDoParametro, executor);
        if (!this.isReferencia(to)) {
            throw this.metodoNaoEncontrado(objeto, metodo, tipoDoParametro);
        }
        return to;
    }

    public MetodoTO getMetodoDoPath(Class classe, String metodo, Class tipoDoParametro) throws Exception {
        MetodoTO to = null;
        IExecutor executor = this.novoExecutorDeRetornoDeMetodo();
        to = (MetodoTO)this.loopPath(classe, metodo, (Object)tipoDoParametro, executor);
        if (!this.isReferencia(to)) {
            throw this.metodoNaoEncontrado(classe, metodo, tipoDoParametro);
        }
        return to;
    }

    public Method getMetodo(Class classe, String nomeDoMetodo, Class tipoDoParametro) throws Exception {
        MetodoTO to = this.getMetodoDoPath(classe, nomeDoMetodo, tipoDoParametro);
        Method res = to.getMetodo();
        return res;
    }

    public Method getMetodo(Object objeto, String nomeDoMetodo, Class tipoDoParametro) throws Exception {
        Class tipo = this.getTipoDoObjeto(objeto);
        return this.getMetodo(tipo, nomeDoMetodo, tipoDoParametro);
    }

    public Method getMetodoGet(Class classe, String atributo) throws Exception {
        Method res = null;
        String prefixo = this.getPrefixoDoMetodoGet(classe, atributo);
        atributo = this.adicionarPrefixo(atributo, prefixo);
        MetodoTO to = this.getMetodoDoPath(classe, atributo, null);
        res = to.getMetodo();
        return res;
    }

    public Method getMetodoSet(Class classe, String atributo) throws Exception {
        Method res = null;
        atributo = this.adicionarPrefixo(atributo, Dominio.getPrefixoMetodoSet());
        MetodoTO to = this.getMetodoDoPath(classe, atributo, null);
        res = to.getMetodo();
        return res;
    }

    public Class getTipoResultadoMetodoGet(Class classe, String atributo) throws Exception {
        Method metodo = this.getMetodoGet(classe, atributo);
        return metodo.getReturnType();
    }

    public Class getTipoParametroMetodoSet(Class classe, String atributo) throws Exception {
        Class<?> resultado = null;
        Method metodo = this.getMetodoSet(classe, atributo);
        if (this.isMetodoSet(metodo)) {
            resultado = metodo.getParameterTypes()[0];
        }
        return resultado;
    }

    public boolean isExisteMetodo(Class classe, String atributo) throws Exception {
        MetodoTO to = null;
        if (this.isReferencia(classe) && !this.isVazio(atributo)) {
            IExecutor executor = this.novoExecutorDeRetornoDeMetodo();
            to = (MetodoTO)this.loopPath(classe, atributo, null, executor);
        }
        return this.isReferencia(to);
    }

    public boolean isExisteMetodoGet(Class classe, String atributo) throws Exception {
        boolean resultado = false;
        if (this.isReferencia(classe) && !this.isVazio(atributo) && this.isExisteMetodoSet(classe, atributo)) {
            String prefixo = this.getPrefixoDoMetodoGet(classe, atributo);
            atributo = this.adicionarPrefixo(atributo, prefixo);
            resultado = this.isExisteMetodo(classe, atributo);
        }
        return resultado;
    }

    public boolean isExisteMetodoSet(Class classe, String atributo) throws Exception {
        boolean resultado = false;
        if (this.isReferencia(classe) && !this.isVazio(atributo)) {
            String prefixo = Dominio.getPrefixoMetodoSet();
            atributo = this.adicionarPrefixo(atributo, prefixo);
            resultado = this.isExisteMetodo(classe, atributo);
        }
        return resultado;
    }

    private boolean isMetodoIgual(Method metodo, String nomeDoMetodo, Class tipoDoParametro) {
        boolean resultado = false;
        if (this.isReferencia(metodo) && !this.isVazio(nomeDoMetodo)) {
            resultado = this.isNomeDoMetodoIgual(metodo, nomeDoMetodo) && this.isParametroDoMetodoIgual(metodo, tipoDoParametro);
        }
        return resultado;
    }

    private boolean isParametroDoMetodoIgual(Method metodo, Class parametro) {
        boolean resposta = false;
        Class<?>[] parametros = metodo.getParameterTypes();
        if (parametros.length > 0) {
            Class param = parametros[0];
            boolean bl = resposta = !this.isReferencia(parametro) || param == parametro;
            if (!resposta && UtilPrimitivo.isPrimitivo(param)) {
                resposta = (param = UtilPrimitivo.getClasseWrapperDoPrimitivo(param)) == parametro;
            }
        } else {
            resposta = parametros.length == 0 && !this.isReferencia(parametro);
        }
        return resposta;
    }

    private boolean isNomeDoMetodoIgual(Method metodo, String nome) {
        return UtilValidadorDeStringsIguais.validar((String)metodo.getName(), (String)nome);
    }

    private Class getTipoDoObjeto(Object objeto) {
        Class<?> tipo = null;
        tipo = this.isReferencia(objeto) && !(objeto instanceof Class) ? objeto.getClass() : (Class<?>)objeto;
        return tipo;
    }

    private ReflexaoException metodoNaoEncontrado(Object objeto, String nome, Class tipo) {
        ReflexaoException e = null;
        e = this.isReferencia(tipo) ? UtilReflexaoException.metodoNaoEncontrado(objeto, nome, tipo) : UtilReflexaoException.metodoNaoEncontrado(objeto, nome);
        return e;
    }

    private String getPrefixoDoMetodoGet(Class classe, String atributo) throws Exception {
        String prefixo = null;
        if (this.isReferencia(classe) && !this.isVazio(atributo)) {
            Class tipo = this.getTipoParametroMetodoSet(classe, atributo);
            prefixo = this.isReferencia(tipo) && (tipo == Boolean.TYPE || tipo == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MetodoKernel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) ? Dominio.getPrefixoMetodoIs() : Dominio.getPrefixoMetodoGet();
        }
        return prefixo;
    }

    private IExecutor novoExecutorDeRetornoDeMetodo() {
        return new IExecutor(){

            public Object getObjeto(Object objeto, String atributo, Object valor) throws Exception {
                MetodoTO res = null;
                if (MetodoKernel.this.isReferencia(objeto) && !MetodoKernel.this.isVazio(atributo)) {
                    Method metodo = null;
                    Class classe = MetodoKernel.this.getTipoDoObjeto(objeto);
                    Class parametro = (Class)valor;
                    Iterator metodos = MetodoKernel.this.novoIterator(MetodoKernel.this.getMetodos(classe));
                    while (metodos.hasNext() && !MetodoKernel.this.isReferencia(res)) {
                        metodo = (Method)metodos.next();
                        if (!MetodoKernel.this.isMetodoIgual(metodo, atributo, parametro)) continue;
                        res = MetodoKernel.this.novoMetodoTO(objeto, metodo);
                    }
                }
                return res;
            }
        };
    }

    private MetodoTO novoMetodoTO(Object objeto, Method metodo) {
        return this.getMetodoTOFactory().novoMetodoTO(objeto, metodo);
    }

    private MetodoTOFactory getMetodoTOFactory() {
        return MetodoTOFactory.getInstancia();
    }

    private Iterator novoIterator(Collection colecao) {
        return this.getColecaoFactory().novoIterator(colecao);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

