/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.reflexao.util;

import br.com.politec.generico.excecao.ExceptionAbstrato;
import br.com.politec.generico.excecao.UtilExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.reflexao.constante.Mensagem;
import br.com.politec.reflexao.exception.ReflexaoException;
import br.com.politec.reflexao.util.UtilLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class UtilReflexaoException
extends UtilExcecaoAbstrato {
    private UtilReflexaoException() {
    }

    public static ReflexaoException classeNaoEncontrada(String classe) {
        String chave = Mensagem.getClasseNaoEncontrada();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((String)chave, (String)classe));
    }

    public static ReflexaoException classeNaoInstanciada(String classe, Exception e) {
        String chave = Mensagem.getClasseNaoInstanciada();
        String msg = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)classe, (String)msg));
    }

    public static ReflexaoException classeNaoInstanciada(Class classe, Exception e) {
        String chave = Mensagem.getClasseNaoInstanciada();
        String msg = UtilReflexaoException.getMensagem((Throwable)e);
        String nome = classe.getName();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)nome, (String)msg));
    }

    public static ReflexaoException metodoNaoEncontrado(Object objeto, String nomeDoMetodo) {
        String chave = Mensagem.getMetodoNaoEncontrado();
        String nome = null;
        nome = objeto instanceof Class ? ((Class)objeto).getName() : objeto.getClass().getName();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((String)chave, (String)nome, (String)nomeDoMetodo));
    }

    public static ReflexaoException securityExceptionNoMetodo(Object objeto, String nomeDoMetodo, Class tipoDoParametro) {
        String chave = Mensagem.getSecurityExceptionNoMetodoComParametro();
        String nome = objeto.getClass().getName();
        String nomeParam = tipoDoParametro.getName();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((String)chave, (String)nome, (String)nomeDoMetodo, (String)nomeParam));
    }

    public static ReflexaoException metodoNaoEncontrado(Object objeto, String nomeDoMetodo, Class tipoDoParametro) {
        String chave = Mensagem.getMetodoNaoEncontradoComParametro();
        String nome = null;
        nome = objeto instanceof Class ? ((Class)objeto).getName() : objeto.getClass().getName();
        String nomeParam = tipoDoParametro.getName();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((String)chave, (String)nome, (String)nomeDoMetodo, (String)nomeParam));
    }

    public static ReflexaoException argumentoInvalidoNoMetodo(Method metodo, IllegalArgumentException e) {
        String chave = Mensagem.getArgumentoInvalidoNoMetodo();
        String nomeDoMetodo = metodo.getName();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)nomeDoMetodo, (String)erro));
    }

    public static ReflexaoException argumentoInvalidoNoMetodo(String metodo, IllegalArgumentException e) {
        String chave = Mensagem.getArgumentoInvalidoNoMetodo();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)metodo, (String)erro));
    }

    public static ReflexaoException acessoNegadoAoMetodo(Method metodo, IllegalAccessException e) {
        String chave = Mensagem.getAcessoNegadoAoMetodo();
        String nomeDoMetodo = metodo.getName();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)nomeDoMetodo, (String)erro));
    }

    public static ReflexaoException acessoNegadoAoMetodo(String metodo, IllegalAccessException e) {
        String chave = Mensagem.getAcessoNegadoAoMetodo();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)metodo, (String)erro));
    }

    public static ReflexaoException erroAoInvocarMetodo(Method metodo, InvocationTargetException e) {
        String chave = Mensagem.getErroAoInvocarMetodo();
        String nomeDoMetodo = metodo.getName();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)nomeDoMetodo, (String)erro));
    }

    public static ReflexaoException erroAoInvocarMetodo(String metodo, InvocationTargetException e) {
        String chave = Mensagem.getErroAoInvocarMetodo();
        String erro = UtilReflexaoException.getMensagem((Throwable)e);
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)metodo, (String)erro));
    }

    public static ReflexaoException pathDoAtributoVazio() {
        String chave = Mensagem.getPathDoAtributoVazio();
        return UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((String)chave));
    }

    public static ReflexaoException erro(Throwable e) {
        ReflexaoException excecao = null;
        if (e instanceof ReflexaoException) {
            excecao = (ReflexaoException)((Object)e);
        } else {
            String chave = Mensagem.getErro();
            String erro = UtilReflexaoException.getMensagem((Throwable)e);
            excecao = UtilReflexaoException.converter(UtilReflexaoException.novaExcecao((Throwable)e, (String)chave, (String)erro));
        }
        return excecao;
    }

    private static ReflexaoException converter(ExceptionAbstrato e) {
        ReflexaoException excecao = new ReflexaoException(e);
        UtilReflexaoException.getLog().error((Object)"Ocorreu um erro.", (Throwable)((Object)excecao));
        return excecao;
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

