/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.qjml.PropertyAccessible;

public class ArchiveTypeInfo
implements PropertyAccessible {
    public static final long SIZE_NOT_APPLICABLE = -1L;
    public static final int ZIP_ARCHIVE = 1;
    public static final long ZIP_MEDIA_SIZE = -1L;
    public static final long ZIP_BLOCK_SIZE = -1L;
    public static final int DIR_ARCHIVE = 2;
    public static final long DIR_MEDIA_SIZE = -1L;
    public static final long DIR_BLOCK_SIZE = -1L;
    public static final int CDROM_ARCHIVE = 4;
    public static final long CDROM_MEDIA_SIZE = 681984000L;
    public static final long CDROM_BLOCK_SIZE = 2048L;
    public static final int CUSTOM_ARCHIVE = 3;
    public static final long CUSTOM_DEFAULT_MEDIA_SIZE = 681984000L;
    public static final long CUSTOM_DEFAULT_BLOCK_SIZE = 2048L;
    private int archiveType;
    private long mediaSize;
    private long blockSize;

    public ArchiveTypeInfo() {
        this(1, -1L, -1L);
    }

    public ArchiveTypeInfo(int n) {
        switch (n) {
            case 1: {
                this.archiveType = 1;
                this.mediaSize = -1L;
                this.blockSize = -1L;
                break;
            }
            case 2: {
                this.archiveType = 2;
                this.mediaSize = -1L;
                this.blockSize = -1L;
                break;
            }
            case 3: {
                this.archiveType = 3;
                this.mediaSize = 681984000L;
                this.blockSize = 2048L;
                break;
            }
            case 4: {
                this.archiveType = 4;
                this.mediaSize = 681984000L;
                this.blockSize = 2048L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown archive type: " + n);
            }
        }
    }

    public ArchiveTypeInfo(int n, long l, long l2) {
        this.archiveType = n;
        this.mediaSize = l;
        this.blockSize = l2;
    }

    public int getArchiveType() {
        return this.archiveType;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public long getMediaSize() {
        return this.mediaSize;
    }

    public void setArchiveType(int n) {
        this.archiveType = n;
    }

    public void setBlockSize(long l) {
        this.blockSize = l;
    }

    public void setMediaSize(long l) {
        this.mediaSize = l;
    }
}

