/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

import com.installshield.archive.index.ArchiveIndexAccessor;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.archive.index.ArchiveIndexEntryReader;
import com.installshield.util.FileAttributes;
import com.installshield.util.MD5;
import java.io.IOException;
import java.io.InputStream;

public class ArchiveIndexReader
implements ArchiveIndexAccessor {
    ArchiveIndexEntryReader index;
    ArchiveIndexEntry entry = null;
    int curEntry = -1;

    public ArchiveIndexReader(InputStream inputStream) throws IOException {
        this.index = new ArchiveIndexEntryReader(inputStream);
    }

    public FileAttributes getAttributes(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.attributes;
    }

    public byte[] getDigest(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.digest;
    }

    public int getEndMediaNumber(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.endMediaNumber;
    }

    public byte[] getExtra(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.extra;
    }

    public String getFileName(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.fileName;
    }

    public long getLastModified(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.lastModified;
    }

    public String getMD5Name(int n) throws IOException {
        return MD5.toHex(this.getDigest(n));
    }

    public int getResourceType(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.resourceType;
    }

    public long getSize(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.size;
    }

    public String getSource(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.source;
    }

    public int getStartMediaNumber(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.startMediaNumber;
    }

    public int getType(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.type;
    }

    public boolean isDuplicateResource(int n) throws IOException {
        if (n != this.curEntry) {
            this.entry = this.index.getEntry(n);
            this.curEntry = n;
        }
        return this.entry.duplicateResource;
    }
}

