/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class CreateDirectory
extends ProductAction {
    private String directory = "";
    private boolean removeOnUninstall = true;
    private String createdDirectory = "";

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.directory.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Directory property must be specified");
        }
        productBuilderSupport.putRequiredService("fileService");
    }

    public String getCreatedDirectory() {
        return this.createdDirectory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean getRemoveOnUninstall() {
        return this.removeOnUninstall;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        try {
            FileService fileService = (FileService)this.getService("fileService");
            String string = this.getParentComponent().getAbsoluteInstallLocation();
            String string2 = fileService.createFileName(string, this.resolveString(this.directory));
            if (fileService.fileExists(string2)) {
                this.createdDirectory = "";
                return;
            }
            String[] stringArray = fileService.createDirectoryReturnNew(string2);
            this.createdDirectory = stringArray[0];
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, "err", serviceException);
        }
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        this.install(productActionSupport);
    }

    public void setCreatedDirectory(String string) {
        this.createdDirectory = string;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public void setRemoveOnUninstall(boolean bl) {
        this.removeOnUninstall = bl;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.removeOnUninstall) {
            return;
        }
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService.fileExists(this.createdDirectory)) {
                fileService.deleteDirectory(this.createdDirectory, false, true);
            }
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, "err", "Can not delete : " + this.createdDirectory + " : " + serviceException);
        }
    }
}

