/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.conditions;

import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.util.Platform;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.Properties;

public class PlatformProductBeanCondition
extends ProductBeanCondition {
    private Platform platform = new Platform();

    public PlatformProductBeanCondition() {
        this.setImmutable(true);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        super.build(productBuilderSupport);
        productBuilderSupport.putRequiredService("systemUtilService");
    }

    public String defaultName() {
        return "platform";
    }

    public String describe() {
        if (this.getEvaluate() == 1) {
            return "target platform must be " + this.platform.getDisplayName();
        }
        return "target platform must not be " + this.platform.getDisplayName();
    }

    protected boolean evaluateTrueCondition() {
        try {
            WizardServices wizardServices = this.getProductBean().getServices();
            SystemUtilService systemUtilService = (SystemUtilService)wizardServices.getService("systemUtilService");
            Properties properties = systemUtilService.getOSProperties();
            Platform platform = new Platform(properties.getProperty("os.name"), properties.getProperty("os.version"), properties.getProperty("os.arch"), "");
            this.logEvent(this, WizardLog.subclassEvent("dbg", "platform"), "target platform: " + platform.toString());
            this.logEvent(this, WizardLog.subclassEvent("dbg", "platform"), "condition platform: " + this.platform.toString());
            try {
                return Rex.matches(platform.getName(), this.platform.getName()) && Rex.matches(platform.getVersion(), this.platform.getVersion()) && Rex.matches(platform.getArch(), this.platform.getArch());
            }
            catch (RegExprSyntaxException regExprSyntaxException) {
                this.logEvent(this, "err", "cannot evaluate platform condition: " + regExprSyntaxException.getMessage());
                return false;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }
}

