/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.StaticSuite;
import com.installshield.product.UninstallProductAction;
import com.installshield.product.iterators.ActiveProductTreeIterator;
import com.installshield.product.iterators.ProductActionTreeIterator;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.Log;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.service.ServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class InstallableObjectVisitor {
    private Vector visitedKeys = new Vector();
    private Hashtable installableComponents = new Hashtable();

    boolean actionsFailed(Object object) {
        return false;
    }

    boolean actionsReplaceFailed(Object object) {
        return false;
    }

    private static void addToVirtualStates(ProductBean productBean, ProductTreeSource productTreeSource, RegistryService registryService, Log log, Hashtable hashtable, boolean bl) {
        if (productBean != null && !hashtable.containsKey(productBean.getBeanId())) {
            hashtable.put(productBean.getBeanId(), new String());
            ProductBean productBean2 = InstallableObjectVisitor.resolveProductBean(productBean);
            if (productBean2 != productBean) {
                hashtable.put(productBean2.getBeanId(), new String());
            }
            if (productBean2 != null) {
                ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createInstallableComponentIterator(productBean2, registryService, productTreeSource, log, bl, false);
                ProductBean productBean3 = productTreeIterator.getNext(productTreeIterator.begin());
                while (productBean3 != null && productBean3 != productTreeIterator.end()) {
                    if (productBean3 != productBean2) {
                        InstallableObjectVisitor.addToVirtualStates(productBean3, productTreeSource, registryService, log, hashtable, bl);
                    }
                    productBean3 = productTreeIterator.getNext(productBean3);
                }
                if (productBean2 instanceof GenericSoftwareObject) {
                    ProductTreeIterator productTreeIterator2 = ProductTreeIteratorFactory.createProductBeansRequiredBySoftwareObjectIterator((GenericSoftwareObject)productBean2, false);
                    ProductBean productBean4 = productTreeIterator2.getNext(productTreeIterator2.begin());
                    while (productBean4 != productTreeIterator2.end()) {
                        GenericSoftwareObject genericSoftwareObject = null;
                        if (productBean4 instanceof SoftwareObjectReference) {
                            SoftwareObject softwareObject = productBean2.getProductTree().resolveKey(((SoftwareObjectReference)productBean4).getKey());
                            if (softwareObject instanceof GenericSoftwareObject) {
                                genericSoftwareObject = (GenericSoftwareObject)softwareObject;
                            }
                        } else if (productBean4 instanceof GenericSoftwareObject) {
                            genericSoftwareObject = (GenericSoftwareObject)productBean4;
                        }
                        if (genericSoftwareObject != null) {
                            InstallableObjectVisitor.addToVirtualStates(productBean4, productTreeSource, registryService, log, hashtable, bl);
                        }
                        productBean4 = productTreeIterator2.getNext(productBean4);
                    }
                }
            }
        }
    }

    boolean checkInstalledVersion(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductActionSupport productActionSupport, Log log) throws ServiceException {
        boolean bl = false;
        if (softwareObject != null && !this.reVisit(softwareObject, softwareObject2, productActionSupport, log)) {
            bl = true;
        } else {
            this.visitedKeys.addElement(softwareObject2.getKey());
        }
        return bl;
    }

    private int compareKeyVersions(SoftwareObject softwareObject, SoftwareObject softwareObject2) throws OperationRejectedException {
        return softwareObject.getKey().getVersion().compareTo(softwareObject2.getKey().getVersion());
    }

    public static Hashtable createVirtualActiveStates(ProductBean productBean, ProductTreeSource productTreeSource, RegistryService registryService, Log log, boolean bl) {
        Hashtable hashtable = new Hashtable();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createInstallableComponentIterator(productBean, registryService, productTreeSource, log, bl, false);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != null && productBean2 != productTreeIterator.end()) {
            InstallableObjectVisitor.addToVirtualStates(productBean2, productTreeSource, registryService, log, hashtable, bl);
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        return hashtable;
    }

    Enumeration enumerateActiveActions(ProductBean productBean) {
        Vector<ProductAction> vector = new Vector<ProductAction>();
        int n = 0;
        while (n < productBean.getProductTree().getChildCount(productBean)) {
            ProductBean productBean2 = productBean.getProductTree().getChild(productBean, n);
            if (productBean2 instanceof ProductAction && ((ProductAction)productBean2).isActive()) {
                vector.addElement((ProductAction)productBean2);
            }
            ++n;
        }
        return vector.elements();
    }

    ProductAction findAction(ProductComponent productComponent, String string) {
        ProductAction productAction = null;
        int n = 0;
        while (productAction == null && n < productComponent.getProductTree().getChildCount(productComponent)) {
            ProductAction productAction2 = (ProductAction)productComponent.getProductTree().getChild(productComponent, n);
            if (productAction2.getBeanId().equals(string)) {
                productAction = productAction2;
            }
            ++n;
        }
        return productAction;
    }

    abstract Object getDefaultResult();

    abstract boolean getResolveProductReferences();

    abstract Object getResultForAppendProductAction(ProductAction var1, SoftwareObject var2, ProductTree var3, ProductActionSupport var4) throws ServiceException;

    abstract Object getResultForProductAction(ProductAction var1, ProductActionSupport var2) throws ServiceException;

    abstract Object getResultForRemoveProductAction(SoftwareObject var1, UninstallProductAction var2, ProductTree var3, ProductActionSupport var4) throws ServiceException;

    abstract Object getResultForReplaceProductAction(ProductAction var1, ProductAction var2, SoftwareObject var3, ProductTree var4, ProductActionSupport var5) throws ServiceException;

    boolean isObjectInstalled(SoftwareObject softwareObject) {
        boolean bl = true;
        if (softwareObject != null && softwareObject.getInstallStatus() != 3) {
            bl = false;
        }
        return bl;
    }

    boolean isObjectInstalling(SoftwareObject softwareObject) {
        boolean bl = true;
        if (softwareObject != null && softwareObject.getInstallStatus() != 2) {
            if (softwareObject instanceof ProductComponent) {
                ProductComponent productComponent = (ProductComponent)softwareObject;
                if (!this.installableComponents.containsKey(productComponent.getBeanId()) || ProductTree.isReplaceInstall(productComponent)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    boolean isObjectReplacing(SoftwareObject softwareObject) {
        boolean bl = true;
        if (softwareObject != null && softwareObject.getInstallStatus() != 6) {
            if (softwareObject instanceof ProductComponent) {
                ProductComponent productComponent = (ProductComponent)softwareObject;
                if (!this.installableComponents.containsKey(productComponent.getBeanId()) || !ProductTree.isReplaceInstall(productComponent)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    void logCantReplace(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductActionSupport productActionSupport, Log log) {
    }

    void postVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
    }

    boolean preVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        return true;
    }

    void processActionsFailed(ProductBean productBean, ProductActionSupport productActionSupport, ProductTreeIterator productTreeIterator) throws ServiceException {
    }

    void processActionsReplaceFailed(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
    }

    abstract Object processNewResult(Object var1, Object var2);

    boolean promptToReplace(SoftwareObject softwareObject, SoftwareObject softwareObject2, int n, ProductActionSupport productActionSupport) {
        return true;
    }

    boolean reVisit(SoftwareObject softwareObject, SoftwareObject softwareObject2, ProductActionSupport productActionSupport, Log log) throws ServiceException {
        int n;
        if (softwareObject2 instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject2;
            n = genericSoftwareObject.getProductTree().getReplaceOption(genericSoftwareObject);
        } else {
            int n2 = softwareObject2.getReplaceOption();
            n = n2 == 0 ? 4 : n2;
        }
        boolean bl = true;
        if (softwareObject != null) {
            switch (n) {
                case 2: {
                    bl = false;
                    this.logCantReplace(softwareObject, softwareObject2, productActionSupport, log);
                    break;
                }
                case 3: {
                    try {
                        if (this.compareKeyVersions(softwareObject2, softwareObject) > 0) break;
                        bl = false;
                        this.logCantReplace(softwareObject, softwareObject2, productActionSupport, log);
                        break;
                    }
                    catch (OperationRejectedException operationRejectedException) {
                        throw new Error(operationRejectedException.getMessage());
                    }
                }
                case 4: {
                    try {
                        if (this.compareKeyVersions(softwareObject2, softwareObject) >= 0 || this.promptToReplace(softwareObject, softwareObject2, 4, productActionSupport)) break;
                        bl = false;
                        this.logCantReplace(softwareObject, softwareObject2, productActionSupport, log);
                        break;
                    }
                    catch (OperationRejectedException operationRejectedException) {
                        throw new Error(operationRejectedException.getMessage());
                    }
                }
                case 5: {
                    if (this.promptToReplace(softwareObject, softwareObject2, 5, productActionSupport)) break;
                    bl = false;
                    this.logCantReplace(softwareObject, softwareObject2, productActionSupport, log);
                    break;
                }
                default: {
                    bl = false;
                    String string = "illegal replace option: option = " + softwareObject2.getReplaceOption();
                    productActionSupport.logEvent(this, "err", string);
                    log.logEvent(this, "err", string);
                }
                case 1: 
            }
        }
        return bl;
    }

    Object replaceComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        if (System.getProperty("is.debug.order") != null && productActionSupport != null) {
            productActionSupport.logEvent(this, "wrn", "Replace:  id = " + productBean.getBeanId() + " ; " + "name = " + productBean.getDisplayName());
        }
        Object object = this.getDefaultResult();
        if (this.preVisitComponent(productBean, productActionSupport)) {
            Object object2 = this.getDefaultResult();
            ProductTree productTree = productBean.getProductTree().getUninstallTree();
            String string = productBean.getProductTree().getInstallLocation(productBean);
            SoftwareObject softwareObject = productTree.findSoftwareObject(((SoftwareObject)((Object)productBean)).getKey().getUID(), string);
            Enumeration enumeration = this.enumerateActiveActions(productBean);
            while (!this.actionsReplaceFailed(object) && enumeration.hasMoreElements()) {
                ProductAction productAction = (ProductAction)enumeration.nextElement();
                if (softwareObject != null) {
                    ProductAction productAction2;
                    if (productAction instanceof UninstallProductAction) {
                        String string2;
                        UninstallProductAction uninstallProductAction = (UninstallProductAction)productAction;
                        String string3 = uninstallProductAction.getTargetBeanId();
                        if (productTree.getRoot() instanceof StaticSuite && (string2 = StaticSuite.getSubProductReferenceId(productBean)) != null) {
                            string3 = StaticSuite.resolveReferencedBeanId(string2, string3);
                        }
                        if ((productAction2 = this.findAction((ProductComponent)softwareObject, string3)) != null && softwareObject.getInstallStatus() == 3) {
                            object2 = this.getResultForRemoveProductAction(softwareObject, uninstallProductAction, productTree, productActionSupport);
                        }
                    } else {
                        productAction2 = this.findAction((ProductComponent)softwareObject, productAction.getBeanId());
                        object2 = productAction2 != null ? this.getResultForReplaceProductAction(productAction2, productAction, softwareObject, productTree, productActionSupport) : this.getResultForAppendProductAction(productAction, softwareObject, productTree, productActionSupport);
                    }
                } else {
                    object2 = this.getResultForProductAction(productAction, productActionSupport);
                }
                object = this.processNewResult(object, object2);
            }
            if (this.actionsReplaceFailed(object)) {
                this.processActionsReplaceFailed(productBean, productActionSupport);
            }
            this.postVisitComponent(productBean, productActionSupport);
        }
        return object;
    }

    private static ProductBean resolveProductBean(ProductBean productBean) {
        ProductBean productBean2 = null;
        if (productBean instanceof SoftwareObjectReference) {
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(((SoftwareObjectReference)productBean).getKey());
            if (softwareObject != null && softwareObject instanceof ProductBean) {
                productBean2 = (ProductBean)((Object)softwareObject);
            }
        } else {
            productBean2 = productBean;
        }
        return productBean2;
    }

    boolean shouldContinue(Object object) {
        return true;
    }

    void updateSoftwareObject(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
    }

    Object visitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        if (System.getProperty("is.debug.order") != null && productActionSupport != null) {
            productActionSupport.logEvent(this, "wrn", "Install:  id = " + productBean.getBeanId() + " ; " + "name = " + productBean.getDisplayName());
        }
        Object object = this.getDefaultResult();
        if (this.preVisitComponent(productBean, productActionSupport)) {
            StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
            ActiveProductTreeIterator activeProductTreeIterator = new ActiveProductTreeIterator(standardProductTreeIterator);
            ProductActionTreeIterator productActionTreeIterator = new ProductActionTreeIterator(activeProductTreeIterator);
            ProductBean productBean2 = productActionTreeIterator.getNext(productActionTreeIterator.begin());
            while (!this.actionsFailed(object) && productBean2 != productActionTreeIterator.end()) {
                Object object2 = this.getResultForProductAction((ProductAction)productBean2, productActionSupport);
                object = this.processNewResult(object, object2);
                productBean2 = productActionTreeIterator.getNext(productBean2);
            }
            if (this.actionsFailed(object)) {
                this.processActionsFailed(productBean, productActionSupport, productActionTreeIterator);
            }
            this.postVisitComponent(productBean, productActionSupport);
        }
        return object;
    }

    Object visitInstallableComponents(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createOrderedComponentIterator(productBean, productTreeSource, log, this.getResolveProductReferences());
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (this.shouldContinue(object) && productBean2 != productTreeIterator.end()) {
            Object object2 = this.getDefaultResult();
            if (productBean2 instanceof ProductComponent && this.installableComponents.containsKey(productBean2.getBeanId())) {
                SoftwareObject softwareObject = null;
                GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productBean2;
                String string = productBean2.getProductTree().getInstallLocation(genericSoftwareObject);
                softwareObject = registryService.getSoftwareObject(genericSoftwareObject.getKey().getUID(), string);
                boolean bl = this.checkInstalledVersion(softwareObject, genericSoftwareObject, productActionSupport, log);
                Vector vector = (Vector)this.installableComponents.get(productBean2.getBeanId());
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.updateSoftwareObject((ProductBean)enumeration.nextElement(), genericSoftwareObject.getKey());
                }
                if (!bl) {
                    object2 = !ProductTree.isReplaceInstall(productBean) ? this.visitComponent(productBean2, productActionSupport) : this.replaceComponent(productBean2, productActionSupport);
                }
                object = this.processNewResult(object, object2);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        return object;
    }

    Object visitProductBean(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        Hashtable hashtable = InstallableObjectVisitor.createVirtualActiveStates(productBean, productTreeSource, registryService, log, this.getResolveProductReferences());
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createVirtualInstallableComponentIterator(productBean.getProductTree().getRoot(), productTreeSource, log, this.getResolveProductReferences(), true, hashtable);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (this.shouldContinue(object) && productBean2 != productTreeIterator.end()) {
            Object object2 = this.visitSoftwareObject(productBean2, productTreeSource, productActionSupport, registryService, log);
            object = this.processNewResult(object, object2);
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        return object;
    }

    Object visitProductBeans(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        Object object2 = this.visitProductBean(productBean, productTreeSource, productActionSupport, registryService, log);
        if (this.shouldContinue(object = this.processNewResult(object, object2))) {
            object2 = this.visitInstallableComponents(productBean, productTreeSource, productActionSupport, registryService, log);
            object = this.processNewResult(object, object2);
        }
        return object;
    }

    Object visitSoftwareObject(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            softwareObjectKey = softwareObject.getKey();
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObjectKey = softwareObjectReference.getKey();
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectKey);
            if (softwareObject != null && !this.wasVisited(softwareObjectKey = softwareObject.getKey())) {
                Object object2 = this.visitProductBean((ProductBean)((Object)softwareObject), productTreeSource, productActionSupport, registryService, log);
                object = this.processNewResult(object, object2);
                softwareObjectKey = softwareObject.getKey();
            }
        }
        if (this.shouldContinue(object) && softwareObjectKey != null) {
            Object object3;
            SoftwareObject softwareObject2;
            boolean bl = this.wasVisited(softwareObjectKey);
            if (!bl && softwareObject != null) {
                if (softwareObject instanceof ProductComponent) {
                    softwareObject2 = (ProductComponent)softwareObject;
                    if (!this.installableComponents.containsKey(softwareObject2.getBeanId())) {
                        this.installableComponents.put(softwareObject2.getBeanId(), new Vector());
                    }
                } else {
                    softwareObject2 = null;
                    if (softwareObject instanceof GenericSoftwareObject) {
                        object3 = (GenericSoftwareObject)softwareObject;
                        String string = productBean.getProductTree().getInstallLocation((ProductBean)object3);
                        softwareObject2 = registryService.getSoftwareObject(softwareObjectKey.getUID(), string);
                    }
                    bl = this.checkInstalledVersion(softwareObject2, softwareObject, productActionSupport, log);
                }
            }
            if (softwareObject instanceof ProductComponent) {
                softwareObject2 = (ProductComponent)softwareObject;
                if (this.installableComponents.containsKey(softwareObject2.getBeanId()) && !((Vector)(object3 = (Vector)this.installableComponents.get(softwareObject2.getBeanId()))).contains(productBean)) {
                    ((Vector)object3).addElement(productBean);
                }
            } else {
                if (System.getProperty("is.debug.order") != null && productActionSupport != null) {
                    productActionSupport.logEvent(this, "wrn", "Install:  id = " + productBean.getBeanId() + " ; " + "name = " + productBean.getDisplayName());
                }
                this.updateSoftwareObject(productBean, softwareObjectKey);
            }
        }
        return object;
    }

    boolean wasVisited(SoftwareObjectKey softwareObjectKey) {
        return this.visitedKeys.contains(softwareObjectKey);
    }
}

