/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.SoftwareObject;
import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class FeaturePanel
extends WizardPanel {
    private String rootDisplayName = "";
    private String consoleSelectDifferentItem = "";
    private String busyMessage = "";
    private ProductTree cachedProductTree = null;
    private SoftwareObject[] cachedInstallSequence = null;
    private Hashtable cachedInstalled = new Hashtable();

    public FeaturePanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, FeaturePanel.description, $P(displayName))");
        this.setRootDisplayName("$L(com.installshield.product.i18n.ProductResources, FeaturePanel.rootNodeName)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("productService");
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.product.i18n.ProductResources");
            wizardBuilderSupport.putClass("com.installshield.product.wizardbeans.FeaturePanelSwingImpl$CustomTreeIncrementAction");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public String getBusyMessage() {
        return this.busyMessage;
    }

    SoftwareObject[] getInstallSequence() throws ServiceException {
        if (this.cachedInstallSequence == null) {
            ProductService productService = (ProductService)this.getService("productService");
            this.cachedInstallSequence = productService.getCurrentSoftwareObjectInstallSequence("/product.xml");
        }
        return this.cachedInstallSequence;
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        Object[] objectArray;
        ProductTree productTree;
        Object object;
        try {
            object = (ProductService)this.getService("productService");
            productTree = object.getSoftwareObjectTree("/product.xml", new String[]{"active", "displayName", "visible"});
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return new OptionsTemplateEntry[0];
        }
        object = new Vector();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFeatureIterator(productTree.getRoot());
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean != productTreeIterator.end()) {
            objectArray = (Object[])productBean;
            String string = this.resolveString("$P(" + objectArray.getBeanId() + ".displayName)");
            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.oteTitle", new String[]{string});
            String string3 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.oteDoc", new String[]{string, objectArray.getBeanId()});
            String string4 = "-P " + objectArray.getBeanId() + ".active=";
            string4 = n == 1 ? String.valueOf(string4) + this.getOptionsFileTemplateValueStr() : String.valueOf(string4) + objectArray.isActive();
            ((Vector)object).addElement(new OptionsTemplateEntry(string2, string3, string4));
            productBean = productTreeIterator.getNext(productBean);
        }
        objectArray = new OptionsTemplateEntry[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    protected ProductTree getProductTree() throws ServiceException {
        if (this.cachedProductTree == null) {
            ProductService productService = (ProductService)this.getService("productService");
            this.cachedProductTree = productService.getSoftwareObjectTree("/product.xml", this.getRequiredFeatureProperties());
        }
        return this.cachedProductTree;
    }

    protected String[] getRequiredFeatureProperties() {
        return new String[]{"active", "displayName", "visible"};
    }

    public String getRootDisplayName() {
        return this.rootDisplayName;
    }

    protected boolean isBeanActive(String string) {
        try {
            ProductBean productBean = this.getProductTree().getBean(string);
            return productBean != null ? productBean.isActive() : false;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    protected boolean isBeanInstalled(String string) {
        Boolean bl = (Boolean)this.cachedInstalled.get(string);
        if (bl == null) {
            try {
                ProductService productService = (ProductService)this.getService("productService");
                bl = (Boolean)productService.getProductBeanProperty("/product.xml", string, "installed");
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
                this.logEvent(this, "wrn", "could not determine installed state for bean " + string + " - assuming not installed");
                bl = Boolean.FALSE;
            }
            this.cachedInstalled.put(string, bl);
        }
        return bl;
    }

    boolean isBeanRequired(String string) {
        try {
            ProductBean productBean = this.getProductTree().getBean(string);
            if (productBean != null && !productBean.isActive()) {
                SoftwareObject[] softwareObjectArray = this.getInstallSequence();
                int n = 0;
                while (n < softwareObjectArray.length) {
                    if (((ProductBean)((Object)softwareObjectArray[n])).getBeanId().equals(string)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return false;
    }

    protected boolean isBeanVisible(String string) {
        try {
            ProductBean productBean = this.getProductTree().getBean(string);
            if (productBean instanceof Product) {
                return productBean != this.getProductTree().getRoot() && ((Product)productBean).isVisible();
            }
            if (productBean instanceof ProductFeature) {
                return ((ProductFeature)productBean).isVisible();
            }
            return false;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        String string = this.resolveString(this.busyMessage);
        if (string != null && string.length() > 0) {
            wizardBeanEvent.getUserInterface().setBusy(this.resolveString(string));
        }
        this.resetCachedValues();
        return super.queryEnter(wizardBeanEvent);
    }

    protected void resetCachedValues() {
        this.cachedProductTree = null;
        this.cachedInstallSequence = null;
        this.cachedInstalled.clear();
    }

    protected void setBeanActive(String string, boolean bl) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty("/product.xml", string, "active", new Boolean(bl));
            this.resetCachedValues();
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public void setBusyMessage(String string) {
        this.busyMessage = string;
    }

    public void setRootDisplayName(String string) {
        this.rootDisplayName = string;
    }
}

