/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.wizardbeans.FeaturePanel;
import com.installshield.product.wizardbeans.FeaturePanelSwingImpl;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FeaturePanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements TreeModel,
TreeCellRenderer,
MouseListener,
KeyListener {
    private JTree tree = null;
    private ProductTree productTree = this.createEmptyTree();
    private Vector treeListeners = new Vector();
    private JCheckBox lastCheckBox = null;
    private boolean clickStart = false;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$ProductBeanNode;
    static /* synthetic */ Class class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$AccessibleCheckBoxPanel;

    static /* synthetic */ JCheckBox access$2(FeaturePanelSwingImpl featurePanelSwingImpl) {
        return featurePanelSwingImpl.lastCheckBox;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.addElement(treeModelListener);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$ProductBeanNode != null ? class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$ProductBeanNode : (class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$ProductBeanNode = FeaturePanelSwingImpl.class$("com.installshield.product.wizardbeans.FeaturePanelSwingImpl$ProductBeanNode"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$AccessibleCheckBoxPanel != null ? class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$AccessibleCheckBoxPanel : (class$com$installshield$product$wizardbeans$FeaturePanelSwingImpl$AccessibleCheckBoxPanel = FeaturePanelSwingImpl.class$("com.installshield.product.wizardbeans.FeaturePanelSwingImpl$AccessibleCheckBoxPanel"))).getName());
        }
        catch (Exception exception) {
            wizardBuilderSupport.logEvent(this, "err", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private GridBagConstraints constrain(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        return gridBagConstraints;
    }

    private ProductTree createEmptyTree() {
        try {
            return new ProductTree(new Product());
        }
        catch (OperationRejectedException operationRejectedException) {
            throw new Error();
        }
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        try {
            this.productTree = this.getFP().getProductTree();
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            this.productTree = this.createEmptyTree();
        }
        this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        this.expand(this.productTree.getRoot());
        this.tree.setSelectionRow(0);
    }

    private void expand(ProductBean productBean) {
        Stack<ProductBean> stack = new Stack<ProductBean>();
        ProductBean productBean2 = productBean;
        while (productBean2 != null) {
            stack.push(productBean2);
            productBean2 = this.productTree.getParent(productBean2);
        }
        Object[] objectArray = new Object[stack.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new ProductBeanNode(null, (ProductBean)stack.pop());
            ++n;
        }
        this.tree.expandPath(new TreePath(objectArray));
        int n2 = 0;
        while (n2 < this.productTree.getChildCount(productBean)) {
            this.expand(this.productTree.getChild(productBean, n2));
            ++n2;
        }
    }

    private void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < this.treeListeners.size()) {
            ((TreeModelListener)this.treeListeners.elementAt(n)).treeNodesChanged(treeModelEvent);
            ++n;
        }
    }

    private void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        int n = 0;
        while (n < this.treeListeners.size()) {
            ((TreeModelListener)this.treeListeners.elementAt(n)).treeStructureChanged(treeModelEvent);
            ++n;
        }
    }

    public Object getChild(Object object, int n) {
        return new ProductBeanNode(null, (ProductBean)this.getVisibleChildren(((ProductBeanNode)object).bean)[n]);
    }

    public int getChildCount(Object object) {
        return this.getVisibleChildren(((ProductBeanNode)object).bean).length;
    }

    private FeaturePanel getFP() {
        return (FeaturePanel)this.getPanel();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return this.productTree.getChildIndex(((ProductBeanNode)object2).bean);
    }

    protected String getNodeCaption(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredLabel"));
        }
        if (bl2) {
            stringBuffer.append(" ");
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.installedLabel"));
        }
        return stringBuffer.toString();
    }

    public Object getRoot() {
        return new ProductBeanNode(null, this.productTree.getRoot(), this.getFP().getRootDisplayName());
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        bl4 = false;
        ProductBeanNode productBeanNode = (ProductBeanNode)object;
        boolean bl5 = this.getFP().isBeanRequired(productBeanNode.bean.getBeanId());
        return new AccessibleCheckBoxPanel(productBeanNode, object.toString(), bl5, bl);
    }

    private Object[] getVisibleChildren(ProductBean productBean) {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < this.productTree.getChildCount(productBean)) {
            object = this.productTree.getChild(productBean, n);
            if (object instanceof ProductFeature && this.getFP().isBeanVisible(object.getBeanId()) || object instanceof Product && object != this.productTree.getRoot() && this.getFP().isBeanVisible(object.getBeanId())) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new Object[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.tree = new JTree(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(this);
        this.tree.addMouseListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addKeyListener(this);
        this.tree.setBackground(new JPanel().getBackground());
        this.tree.setRowHeight(new JCheckBox().getPreferredSize().height);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tree.getAccessibleContext().setAccessibleName(this.resolveString(this.getFP().getDescription()));
        try {
            this.tree.registerKeyboardAction(new CustomTreeIncrementAction(null, -1, "UP", false, true), "Add Item", KeyStroke.getKeyStroke(38, 0), 0);
            this.tree.registerKeyboardAction(new CustomTreeIncrementAction(null, 1, "DOWN", false, true), "Add2 Item", KeyStroke.getKeyStroke(40, 0), 0);
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public boolean isLeaf(Object object) {
        return this.getVisibleChildren(((ProductBeanNode)object).bean).length == 0;
    }

    protected boolean isRootSelectable() {
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '\n') {
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath != null && (!((ProductBeanNode)treePath.getLastPathComponent()).root || this.isRootSelectable())) {
                this.toggleBeanActiveState(((ProductBeanNode)treePath.getLastPathComponent()).bean);
            }
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (!((ProductBeanNode)treePath.getLastPathComponent()).root || this.isRootSelectable())) {
            Rectangle rectangle = this.tree.getPathBounds(treePath);
            Insets insets = this.lastCheckBox.getInsets();
            Dimension dimension = this.lastCheckBox.getPreferredSize();
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top + (rectangle.height - dimension.height) / 2, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            this.clickStart = rectangle2.contains(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        } else {
            this.clickStart = false;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle;
        TreePath treePath;
        if (this.clickStart && (treePath = this.tree.getSelectionPath()) != null && (rectangle = this.tree.getPathBounds(treePath)).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.toggleBeanActiveState(((ProductBeanNode)treePath.getLastPathComponent()).bean);
        }
        this.clickStart = false;
    }

    private void refreshNodes(TreePath treePath) {
        this.fireTreeNodesChanged(this, treePath.getPath(), new int[0], new Object[0]);
        int n = this.getChildCount(treePath.getLastPathComponent());
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = treePath.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this.getChild(treePath.getLastPathComponent(), n2);
            this.refreshNodes(new TreePath(objectArray2));
            ++n2;
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeListeners.removeElement(treeModelListener);
    }

    protected String resolveString(String string) {
        return super.resolveString(string);
    }

    private void toggleBeanActiveState(ProductBean productBean) {
        if (!this.getFP().isBeanRequired(productBean.getBeanId())) {
            this.getFP().setBeanActive(productBean.getBeanId(), this.getFP().isBeanActive(productBean.getBeanId()) ^ true);
            this.refreshNodes(new TreePath(new Object[]{this.getRoot()}));
            TreePath treePath = this.tree.getSelectionPath();
            this.tree.removeSelectionPath(treePath);
            this.tree.setSelectionPath(treePath);
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    private class AccessibleCheckBoxPanel
    extends JPanel {
        JCheckBox cb;
        JLabel l;

        public AccessibleCheckBoxPanel(ProductBeanNode productBeanNode, String string, boolean bl, boolean bl2) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.getAccessibleContext().setAccessibleName(string);
            if (!productBeanNode.root || FeaturePanelSwingImpl.this.isRootSelectable()) {
                this.cb = new JCheckBox();
                this.add((Component)this.cb, FeaturePanelSwingImpl.this.constrain(0));
                this.cb.setOpaque(false);
                this.cb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                this.cb.setSelected(bl || FeaturePanelSwingImpl.this.getFP().isBeanActive(productBeanNode.bean.getBeanId()));
                this.cb.setEnabled(bl ^ true);
                FeaturePanelSwingImpl.this.lastCheckBox = this.cb;
                this.cb.getAccessibleContext().setAccessibleName(string);
            }
            this.l = new JLabel(string.toString());
            this.add((Component)this.l, FeaturePanelSwingImpl.this.constrain(1));
            this.l.setIcon(null);
            this.l.setEnabled(bl ^ true);
            if (bl2) {
                Color color;
                Color color2 = (Color)UIManager.getDefaults().get("Tree.selectionBackground");
                if (color2 != null) {
                    this.l.setBackground(color2);
                }
                if ((color = (Color)UIManager.getDefaults().get("Tree.selectionForeground")) != null) {
                    this.l.setForeground(color);
                }
                this.l.setOpaque(true);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.cb != null) {
                return this.cb.getAccessibleContext();
            }
            return super.getAccessibleContext();
        }
    }

    private class ProductBeanNode {
        private ProductBean bean;
        private boolean root;
        private String rootDisplayName;

        private ProductBeanNode(ProductBean productBean) {
            if (productBean == null) {
                throw new NullPointerException();
            }
            this.bean = productBean;
            this.rootDisplayName = null;
            this.root = false;
        }

        private ProductBeanNode(ProductBean productBean, String string) {
            if (productBean == null) {
                throw new NullPointerException();
            }
            this.bean = productBean;
            this.rootDisplayName = FeaturePanelSwingImpl.this.resolveString(string);
            this.root = true;
        }

        /* synthetic */ ProductBeanNode(1 var2_2, ProductBean productBean) {
            this(productBean);
        }

        /* synthetic */ ProductBeanNode(1 var2_2, ProductBean productBean, String string) {
            this(productBean, string);
        }

        public boolean equals(Object object) {
            return object instanceof ProductBeanNode ? ((ProductBeanNode)object).bean.getBeanId().equals(this.bean.getBeanId()) : false;
        }

        public int hashCode() {
            return this.bean.getBeanId().hashCode();
        }

        public String toString() {
            if (this.root) {
                return this.rootDisplayName;
            }
            return FeaturePanelSwingImpl.this.getNodeCaption(FeaturePanelSwingImpl.this.resolveString(this.bean.getDisplayName()), FeaturePanelSwingImpl.this.getFP().isBeanRequired(this.bean.getBeanId()), FeaturePanelSwingImpl.this.getFP().isBeanInstalled(this.bean.getBeanId()));
        }
    }

    private class CustomTreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;
        private TreePath leadPath;
        int leadRow;

        private CustomTreeIncrementAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        /* synthetic */ CustomTreeIncrementAction(1 var2_2, int n, String string, boolean bl, boolean bl2) {
            this(n, string, bl, bl2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (FeaturePanelSwingImpl.this.tree != null && FeaturePanelSwingImpl.this.tree.getSelectionModel() != null && (n = FeaturePanelSwingImpl.this.tree.getRowCount()) > 0) {
                int n2 = FeaturePanelSwingImpl.this.tree.getLeadSelectionRow();
                int n3 = n2 == -1 ? (this.direction == 1 ? 0 : n - 1) : Math.min(n - 1, Math.max(0, n2 + this.direction));
                if (this.addToSelection) {
                    this.extendSelection(FeaturePanelSwingImpl.this.tree.getPathForRow(n3));
                } else if (this.changeSelection) {
                    FeaturePanelSwingImpl.this.tree.setSelectionInterval(n3, n3);
                } else {
                    this.setLeadPath(FeaturePanelSwingImpl.this.tree.getPathForRow(n3), true);
                }
                this.ensureRowsAreVisible(n3, n3);
            }
        }

        private void ensureRowsAreVisible(int n, int n2) {
            if (FeaturePanelSwingImpl.this.tree != null && n >= 0 && n2 < FeaturePanelSwingImpl.this.tree.getRowCount()) {
                if (n == n2) {
                    Rectangle rectangle = FeaturePanelSwingImpl.this.tree.getPathBounds(FeaturePanelSwingImpl.this.tree.getPathForRow(n));
                    if (rectangle != null) {
                        rectangle.width += rectangle.x;
                        rectangle.x = 0;
                        FeaturePanelSwingImpl.this.tree.scrollRectToVisible(rectangle);
                    }
                } else {
                    Rectangle rectangle = FeaturePanelSwingImpl.this.tree.getPathBounds(FeaturePanelSwingImpl.this.tree.getPathForRow(n));
                    Rectangle rectangle2 = FeaturePanelSwingImpl.this.tree.getVisibleRect();
                    Rectangle rectangle3 = rectangle;
                    int n3 = rectangle.y;
                    int n4 = n3 + rectangle2.height;
                    int n5 = n + 1;
                    while (n5 <= n2) {
                        rectangle3 = FeaturePanelSwingImpl.this.tree.getPathBounds(FeaturePanelSwingImpl.this.tree.getPathForRow(n5));
                        if (rectangle3.y + rectangle3.height > n4) {
                            n5 = n2;
                        }
                        ++n5;
                    }
                    FeaturePanelSwingImpl.this.tree.scrollRectToVisible(new Rectangle(rectangle2.x, n3, 1, rectangle3.y + rectangle3.height - n3));
                }
            }
        }

        private void extendSelection(TreePath treePath) {
            TreePath treePath2 = FeaturePanelSwingImpl.this.tree.getSelectionPath();
            int n = treePath2 == null ? -1 : FeaturePanelSwingImpl.this.tree.getRowForPath(treePath2);
            int n2 = FeaturePanelSwingImpl.this.tree.getRowForPath(treePath);
            if (n == -1) {
                FeaturePanelSwingImpl.this.tree.setSelectionRow(n2);
            } else {
                if (n < n2) {
                    FeaturePanelSwingImpl.this.tree.setSelectionInterval(n, n2);
                } else {
                    FeaturePanelSwingImpl.this.tree.setSelectionInterval(n2, n);
                }
                FeaturePanelSwingImpl.this.tree.setSelectionPath(treePath2);
                this.setLeadPath(treePath);
            }
        }

        private void setLeadPath(TreePath treePath) {
            this.setLeadPath(treePath, false);
        }

        private void setLeadPath(TreePath treePath, boolean bl) {
            Rectangle rectangle = bl ? FeaturePanelSwingImpl.this.tree.getPathBounds(this.leadPath) : null;
            this.leadPath = treePath;
            this.leadRow = FeaturePanelSwingImpl.this.tree.getRowForPath(this.leadPath);
            if (bl) {
                if (rectangle != null) {
                    FeaturePanelSwingImpl.this.tree.repaint(rectangle);
                }
                if ((rectangle = FeaturePanelSwingImpl.this.tree.getPathBounds(this.leadPath)) != null) {
                    FeaturePanelSwingImpl.this.tree.repaint(rectangle);
                }
            }
        }
    }
}

