/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.util.MD5;
import com.installshield.wizard.awt.FlowLabel;
import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class AWTText
extends Panel
implements KeyListener {
    public static final int HTML = 1;
    public static final int PLAIN_TEXT = 2;
    private String text;
    private boolean showBorder;
    private int contentType;
    private Component ui;
    private String browserHtml = "";

    public AWTText() {
        this("", 2, false);
    }

    public AWTText(String string) {
        this(string, 2, false);
    }

    public AWTText(String string, int n, boolean bl) {
        this.text = string;
        this.verifyContentType(n);
        this.contentType = n;
        this.showBorder = bl;
        this.setLayout(new BorderLayout());
        this.ui = null;
    }

    public void addNotify() {
        super.addNotify();
        this.ui = this.createUI();
        this.add(this.ui, "Center");
        this.setTextImpl(this.text);
    }

    private Component createUI() {
        if (this.contentType == 1) {
            Browser browser = new Browser();
            Font font = this.findFont();
            if (font != null) {
                browser.setProportionalFont(font);
            }
            return browser;
        }
        if (this.showBorder) {
            TextArea textArea = new TextArea("", 0, 0, 1);
            textArea.setEditable(false);
            textArea.addKeyListener(this);
            textArea.setFont(this.findFont());
            textArea.setForeground(this.findForeground());
            ((Component)textArea).setBackground(this.findBackground());
            return textArea;
        }
        return new FlowLabel();
    }

    public void doLayout() {
        super.doLayout();
        if (this.ui != null && this.contentType == 1 && this.showBorder) {
            Rectangle rectangle = this.ui.getBounds();
            this.ui.setBounds(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        }
    }

    private Color findBackground() {
        Color color = this.getBackground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getBackground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.white;
    }

    private Font findFont() {
        Font font = this.getFont();
        Container container = this.getParent();
        while (font == null && container != null) {
            font = container.getFont();
            container = container.getParent();
        }
        return font;
    }

    private Color findForeground() {
        Color color = this.getForeground();
        Container container = this.getParent();
        while (color == null && container != null) {
            color = container.getForeground();
            container = container.getParent();
        }
        if (color != null) {
            return color;
        }
        return Color.black;
    }

    private String formatColor(Color color) {
        return "#" + MD5.toHex(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public String getText() {
        return this.text;
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t' && (keyEvent.getModifiers() & 1) == 0) {
            keyEvent.getComponent().transferFocus();
        }
    }

    public void paint(Graphics graphics) {
        if (this.ui != null && this.contentType == 1 && this.showBorder) {
            Rectangle rectangle = this.ui.getBounds();
            int n = rectangle.y - 2;
            int n2 = rectangle.x - 2;
            int n3 = rectangle.y + rectangle.height + 2;
            int n4 = rectangle.x + rectangle.width + 2;
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n, n4 - 1, n);
            graphics.drawLine(n2, n, n2, n3 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + 1, n + 1, n4 - 2, n + 1);
            graphics.drawLine(n2 + 1, n + 1, n2 + 1, n3 - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n2 + 1, n3 - 2, n4 - 2, n3 - 2);
            graphics.drawLine(n4 - 2, n + 1, n4 - 2, n3 - 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n3 - 1, n4, n3 - 1);
            graphics.drawLine(n4 - 1, n, n4 - 1, n3 - 1);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.ui != null) {
            this.remove(this.ui);
            this.ui = null;
        }
    }

    private void reset() {
        if (this.ui != null) {
            this.remove(this.ui);
            this.ui = this.createUI();
            this.add(this.ui, "Center");
            this.validate();
            this.repaint();
        }
    }

    public void setContentType(int n) {
        this.verifyContentType(n);
        this.contentType = n;
        this.reset();
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.reset();
    }

    public void setText(String string) {
        this.text = string;
        this.setTextImpl(string);
    }

    private void setTextImpl(String string) {
        if (this.ui instanceof Browser) {
            Browser browser = (Browser)this.ui;
            if (this.browserHtml.length() > 0) {
                browser.htmlClear();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body bgcolor=\"");
            stringBuffer.append(this.formatColor(this.findBackground()));
            stringBuffer.append("\"><font color=\"");
            stringBuffer.append(this.formatColor(this.findForeground()));
            stringBuffer.append("\">");
            if (this.findFont().isBold()) {
                stringBuffer.append("<B>");
            }
            if (this.findFont().isItalic()) {
                stringBuffer.append("<I>");
            }
            stringBuffer.append(string);
            if (this.findFont().isItalic()) {
                stringBuffer.append("</I>");
            }
            if (this.findFont().isBold()) {
                stringBuffer.append("</B>");
            }
            stringBuffer.append("</font></body></html>");
            this.browserHtml = stringBuffer.toString();
            browser.htmlAppend(this.browserHtml);
        } else if (this.ui instanceof FlowLabel) {
            ((FlowLabel)this.ui).setText(string);
        } else if (this.ui instanceof TextArea) {
            ((TextArea)this.ui).setText(string);
        }
    }

    private void verifyContentType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal content type: " + n);
        }
    }
}

