/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.util.GregorianCalendar;

public class Win32FileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    public static final String PLATFORM_ID = "win32ppk";
    public static final String OS_MAIN_DIR = "os_main";
    public static final String COMMON_DIR = "common";

    public boolean canRead(String string) {
        boolean bl = this.win32EnableAbort(false);
        boolean bl2 = super.canRead(string);
        this.win32EnableAbort(bl);
        return bl2;
    }

    public int copyFile(String string, String string2, boolean bl) throws ServiceException {
        SystemUtilService systemUtilService;
        int n = this.win32CopyFile(string, string2, bl);
        if (n == 1 && (systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemUtilService.setRebootRequired(true);
        }
        return n;
    }

    public int deleteDirectory(String string) throws ServiceException {
        return this.deleteDirectory(string, true, false);
    }

    public int deleteDirectory(String string, boolean bl, boolean bl2) throws ServiceException {
        SystemUtilService systemUtilService;
        String string2 = this.createFileName(this.getCurrentDirectory(), string);
        if (this.fileExists(string2) && this.isDirectory(string2) && this.getParent(string2) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        int n = this.win32DeleteDirectory(string, bl, bl2);
        if (n == 1 && (systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemUtilService.setRebootRequired(true);
        }
        return n;
    }

    public int deleteFile(String string) throws ServiceException {
        SystemUtilService systemUtilService;
        int n = this.win32DeleteFile(string);
        if (n == 1 && (systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemUtilService.setRebootRequired(true);
        }
        return n;
    }

    public native FileAttributes getFileAttributes(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected native String getLibraryDirectory() throws ServiceException;

    public String getNamedDirectory(String string) throws ServiceException {
        boolean bl = true;
        String string2 = "";
        if (string.equals(OS_MAIN_DIR)) {
            string2 = this.win32GetWindowsDirectory();
        } else if (string.equals(COMMON_DIR)) {
            string2 = this.win32GetCommonDirectory();
        } else {
            string2 = super.getNamedDirectory(string);
            bl = false;
        }
        if (bl && FileUtils.getParent(string2) != null && (string2.endsWith("/") || string2.endsWith("\\") || string2.endsWith(File.separator))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public native String getPartitionFormat(String var1) throws ServiceException;

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public native String[] getPartitionNames() throws ServiceException;

    public native int getPartitionType(String var1) throws ServiceException;

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    protected native String getStandardInstallDirectory() throws ServiceException;

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected native String getTempDirectory() throws ServiceException;

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"fileService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public native boolean isDirectoryWritable(String var1);

    public int moveFile(String string, String string2, boolean bl) throws ServiceException {
        SystemUtilService systemUtilService;
        int n = this.win32MoveFile(string, string2, bl);
        if (n == 1 && (systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemUtilService.setRebootRequired(true);
        }
        return n;
    }

    private long normalizeDate(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1601, 0, 1);
        long l2 = gregorianCalendar.getTime().getTime();
        gregorianCalendar.set(1970, 0, 1);
        long l3 = gregorianCalendar.getTime().getTime();
        return (l + l3 - l2) * 10000L;
    }

    public native void setFileAttributes(String var1, FileAttributes var2) throws ServiceException;

    public void setFileCreated(String string, long l) throws ServiceException {
        l = this.normalizeDate(l);
        this.win32SetFileCreated(string, l);
    }

    public void setFileExecutable(String string) throws ServiceException {
        File file = new File(string);
        if (!file.isFile()) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32FileServiceImpl.fileDoesNotExist", new String[]{string.toString()}));
        }
    }

    public void setFileModified(String string, long l) throws ServiceException {
        l = this.normalizeDate(l);
        this.win32SetFileModified(string, l);
    }

    public native void setFileOwner(String var1, String var2) throws ServiceException;

    public native void setFileOwnerGroup(String var1, String var2) throws ServiceException;

    public void setFileTimes(String string, long l, long l2, long l3) throws ServiceException {
        l = this.normalizeDate(l);
        l2 = this.normalizeDate(l2);
        l3 = this.normalizeDate(l3);
        this.win32SetFileTimes(string, l, l2, l3);
    }

    public native boolean supportsLongFileNames(String var1);

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1 && (string.charAt(n) != ':' || n != 1)) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }

    private native int win32CopyFile(String var1, String var2, boolean var3) throws ServiceException;

    private native int win32DeleteDirectory(String var1, boolean var2, boolean var3) throws ServiceException;

    public native int win32DeleteFile(String var1) throws ServiceException;

    public native boolean win32EnableAbort(boolean var1);

    protected native String win32GetCommonDirectory();

    protected native String win32GetWindowsDirectory();

    private native int win32MoveFile(String var1, String var2, boolean var3) throws ServiceException;

    private native void win32SetFileCreated(String var1, long var2) throws ServiceException;

    private native void win32SetFileModified(String var1, long var2) throws ServiceException;

    private native void win32SetFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;
}

