/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.file;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServicesDependentStringResolverMethod;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;

public class PathMethod
extends ServicesDependentStringResolverMethod {
    private WizardServices services = null;

    public String getName() {
        return new String("PATH");
    }

    public void initialize(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public String invoke(String[] stringArray) {
        try {
            return this.invokeWithValidation(stringArray);
        }
        catch (StringResolverException stringResolverException) {
            return stringResolverException.getMessage();
        }
    }

    public String invokeWithValidation(String[] stringArray) throws StringResolverException {
        if (this.services == null) {
            throw new StringResolverException("ERROR: services not set");
        }
        if (stringArray.length != 2 && stringArray.length != 1) {
            throw new StringResolverException(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "PathMethod.oneOrTwoArgError"));
        }
        try {
            FileService fileService = (FileService)this.services.getService("fileService");
            String string = stringArray.length == 2 ? fileService.createFileName(stringArray[0], stringArray[1]) : fileService.createFileName(stringArray[0], null);
            if (string.endsWith(fileService.getSeparator()) && fileService.getParent(string) != null) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (ServiceException serviceException) {
            throw new StringResolverException("ERROR: " + serviceException.getMessage());
        }
    }
}

