/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.conditions;

import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputPanel;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UserInputPanelCondition
extends WizardBeanCondition {
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_FILE = 3;
    public static final int TYPE_DIRECTORY = 4;
    public static final int TYPE_CHOICE = 5;
    public static final int TEXT_OP_CASE = 100;
    public static final int TEXT_OP_NO_CASE = 101;
    public static final int TEXT_OP_REGEX = 102;
    public static final int NUMERIC_OP_EQ = 200;
    public static final int NUMERIC_OP_LT = 201;
    public static final int NUMERIC_OP_LTEQ = 202;
    public static final int NUMERIC_OP_GT = 203;
    public static final int NUMERIC_OP_GTEQ = 204;
    public static final int NUMERIC_OP_NEQ = 205;
    public static final int FILE_OP_EXISTS = 300;
    public static final int FILE_OP_NOT_EXISTS = 301;
    public static final int CHOICE_OP_ONE = 400;
    public static final int CHOICE_OP_ALL = 401;
    private String panelRef = "";
    private String fieldName = "";
    private int comparisonType = 1;
    private String value = "";
    private int operation = 100;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        if (this.findTarget() == null) {
            wizardBuilderSupport.logEvent(this, "wrn", "Link to user input panel field is broken - condition will always be false");
        }
    }

    private boolean compareChoices(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashtable.put(stringTokenizer.nextToken().trim(), "");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        boolean bl2 = false;
        while (stringTokenizer2.hasMoreTokens()) {
            bl2 = true;
            if (hashtable.containsKey(stringTokenizer2.nextToken().trim())) {
                if (bl) continue;
                return true;
            }
            if (!bl) continue;
            return false;
        }
        return bl && bl2;
    }

    private boolean compareNumbers(String string, String string2, int n) {
        try {
            float f = Float.valueOf(string).floatValue();
            float f2 = Float.valueOf(string2).floatValue();
            if (n == 200) {
                return f == f2;
            }
            if (n == 201) {
                return f < f2;
            }
            if (n == 202) {
                return f <= f2;
            }
            if (n == 203) {
                return f > f2;
            }
            if (n == 204) {
                return f >= f2;
            }
            if (n == 205) {
                return f != f2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    private boolean compareText(String string, String string2, boolean bl) {
        if (bl) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public String defaultName() {
        return "User Input Panel Condition";
    }

    public String describe() {
        return "User input condition";
    }

    private boolean dirExists(String string) {
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    private boolean evalRegex(String string, String string2) {
        try {
            return Rex.matches(string, string2);
        }
        catch (RegExprSyntaxException regExprSyntaxException) {
            if (((Hashtable)System.getProperties()).get("is.debug") != null) {
                regExprSyntaxException.printStackTrace();
            }
            return false;
        }
    }

    public boolean evaluateTrueCondition() {
        UserInputField userInputField = this.findTarget();
        if (userInputField != null) {
            switch (this.comparisonType) {
                case 1: {
                    if (this.operation == 102) {
                        return this.evalRegex(userInputField.getValue(), this.value);
                    }
                    return this.compareText(userInputField.getValue(), this.value, this.operation == 100);
                }
                case 2: {
                    return this.compareNumbers(userInputField.getValue(), this.value, this.operation);
                }
                case 3: {
                    if (this.operation == 300) {
                        return this.fileExists(userInputField.getValue());
                    }
                    return this.fileExists(userInputField.getValue()) ^ true;
                }
                case 4: {
                    if (this.operation == 300) {
                        return this.dirExists(userInputField.getValue());
                    }
                    return this.dirExists(userInputField.getValue()) ^ true;
                }
                case 5: {
                    return this.compareChoices(userInputField.getValue(), this.value, this.operation == 401);
                }
            }
        }
        return false;
    }

    private boolean fileExists(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    private UserInputField findTarget() {
        WizardBean wizardBean = this.getWizardBean().getWizardTree().getBean(this.panelRef);
        if (wizardBean instanceof UserInputPanel) {
            UserInputField[] userInputFieldArray = ((UserInputPanel)wizardBean).getFields();
            int n = 0;
            while (n < userInputFieldArray.length) {
                if (userInputFieldArray[n].getName().equals(this.fieldName)) {
                    return userInputFieldArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public int getComparisonType() {
        return this.comparisonType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getPanelRef() {
        return this.panelRef;
    }

    public String getValue() {
        return this.value;
    }

    public void setComparisonType(int n) {
        this.comparisonType = n;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setPanelRef(String string) {
        this.panelRef = string;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

