/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import com.installshield.wizard.swing.SwingText;
import com.installshield.wizard.swing.SwingWizardUI;
import com.installshield.wizardx.panels.UserInputField;
import com.installshield.wizardx.panels.UserInputFieldChoice;
import com.installshield.wizardx.panels.UserInputPanel;
import com.installshield.wizardx.panels.UserInputPanelConstraints;
import com.installshield.wizardx.panels.UserInputPanelLayout;
import com.installshield.wizardx.ui.DirectoryBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class UserInputPanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements ActionListener,
ItemListener,
ListSelectionListener,
DocumentListener {
    public static final int DEFAULT_CAPTION_SPACING = 0;
    public static final int DEFAULT_BROWSE_BUTTON_SPACING = 6;
    public static final int DEFAULT_LIST_ITEM_SPACING = 0;
    private JScrollPane scroll = null;
    private JPanel view = null;
    private Hashtable fieldsPerComponent = new Hashtable();
    private Hashtable componentsPerField = new Hashtable();
    private boolean isRemote = false;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$UserInputPanelLayout;
    static /* synthetic */ Class class$com$installshield$wizardx$panels$UserInputPanelConstraints;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure;
    static /* synthetic */ Class class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator;

    public void actionPerformed(ActionEvent actionEvent) {
        UserInputField userInputField = this.getFieldForComponent((JComponent)actionEvent.getSource());
        if (userInputField != null) {
            SwingWizardUI swingWizardUI;
            block11: {
                swingWizardUI = (SwingWizardUI)this.getPanel().getWizard().getUI();
                if (swingWizardUI != null) {
                    swingWizardUI.restoreDefaultColors();
                }
                String string = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryInputComponent.selectDirectory");
                if (this.isRemote) {
                    Container container = this.getParent();
                    while (container != null && !(container instanceof Frame)) {
                        container = container.getParent();
                    }
                    try {
                        DirectoryBrowser directoryBrowser = new DirectoryBrowser((Frame)container, string, null, (FileService)this.getPanel().getServices().getService("fileService"), LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "DirectoryBrowser.Folder"));
                        directoryBrowser.setSelectionType(actionEvent.getActionCommand().equals("file") ? 2 : 1);
                        directoryBrowser.setInitialDirectory(userInputField.getValue());
                        directoryBrowser.run();
                        if (directoryBrowser.dirName() == null) break block11;
                        userInputField.setValue(directoryBrowser.dirName());
                        if (this.getComponentForField(userInputField) instanceof JTextComponent) {
                            JTextComponent jTextComponent = (JTextComponent)this.getComponentForField(userInputField);
                            jTextComponent.setText(userInputField.getValue());
                            jTextComponent.selectAll();
                            jTextComponent.requestFocus();
                        }
                    }
                    catch (Exception exception) {
                        this.getPanel().logEvent(this, "err", exception);
                    }
                } else {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(string);
                    jFileChooser.setFileSelectionMode(actionEvent.getActionCommand().equals("file") ? 2 : 1);
                    Dimension dimension = jFileChooser.getPreferredSize();
                    jFileChooser.setSelectedFile(new File(this.resolveString(userInputField.getValue())));
                    jFileChooser.setPreferredSize(dimension);
                    if (jFileChooser.showOpenDialog(this) == 0) {
                        userInputField.setValue(jFileChooser.getSelectedFile().getPath());
                        if (this.getComponentForField(userInputField) instanceof JTextComponent) {
                            JTextComponent jTextComponent = (JTextComponent)this.getComponentForField(userInputField);
                            jTextComponent.setText(userInputField.getValue());
                            jTextComponent.selectAll();
                            jTextComponent.requestFocus();
                        }
                    }
                }
            }
            if (swingWizardUI != null) {
                swingWizardUI.setWizardColors();
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$UserInputPanelLayout != null ? class$com$installshield$wizardx$panels$UserInputPanelLayout : (class$com$installshield$wizardx$panels$UserInputPanelLayout = UserInputPanelSwingImpl.class$("com.installshield.wizardx.panels.UserInputPanelLayout"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$UserInputPanelConstraints != null ? class$com$installshield$wizardx$panels$UserInputPanelConstraints : (class$com$installshield$wizardx$panels$UserInputPanelConstraints = UserInputPanelSwingImpl.class$("com.installshield.wizardx.panels.UserInputPanelConstraints"))).getName());
            wizardBuilderSupport.putRequiredService("fileService");
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser != null ? class$com$installshield$wizardx$ui$DirectoryBrowser : (class$com$installshield$wizardx$ui$DirectoryBrowser = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser"))).getName());
            wizardBuilderSupport.putClass("com.installshield.wizardx.ui.DirectoryBrowser$1");
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconBase11 = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconBase11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 : (class$com$installshield$wizardx$ui$DirectoryBrowser$IconListBox11 = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$IconListBox11"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay : (class$com$installshield$wizardx$ui$DirectoryBrowser$DirTextDisplay = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$DirTextDisplay"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure : (class$com$installshield$wizardx$ui$DirectoryBrowser$FileStructure = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$FileStructure"))).getName());
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator != null ? class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator : (class$com$installshield$wizardx$ui$DirectoryBrowser$Comparator = UserInputPanelSwingImpl.class$("com.installshield.wizardx.ui.DirectoryBrowser$Comparator"))).getName());
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        UserInputField userInputField = (UserInputField)document.getProperty("field");
        try {
            userInputField.setValue(document.getText(0, document.getLength()));
        }
        catch (BadLocationException badLocationException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected JLabel createCaption(String string, JComponent jComponent) {
        MnemonicString mnemonicString = new MnemonicString(string);
        JLabel jLabel = new JLabel(mnemonicString.toString());
        if (mnemonicString.isMnemonicSpecified()) {
            JComponent jComponent2 = null;
            if (jComponent instanceof JTextComponent || jComponent instanceof JList || jComponent instanceof JComboBox || jComponent instanceof JCheckBox || jComponent instanceof JRadioButton) {
                jComponent2 = jComponent;
            } else {
                if (jComponent instanceof JScrollPane) {
                    return this.createCaption(string, (JComponent)((JScrollPane)jComponent).getViewport().getView());
                }
                if (jComponent instanceof JPanel && jComponent.getComponentCount() > 0) {
                    return this.createCaption(string, (JComponent)jComponent.getComponent(0));
                }
            }
            if (jComponent2 != null) {
                jLabel.setDisplayedMnemonic(mnemonicString.getMnemonicChar());
                jLabel.setLabelFor(jComponent2);
            }
        }
        return jLabel;
    }

    protected JComponent createCheckList(UserInputField userInputField) {
        return this.createCheckList(userInputField, null);
    }

    private JComponent createCheckList(UserInputField userInputField, Color color) {
        JPanel jPanel = new JPanel(new ColumnLayout(this.getListItemSpacing()));
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            MnemonicString mnemonicString = new MnemonicString(this.resolveString(userInputFieldChoiceArray[n].getDisplayName()));
            JCheckBox jCheckBox = new JCheckBox(mnemonicString.toString());
            jPanel.add((Component)jCheckBox, ColumnConstraints.createLeftAlign());
            if (mnemonicString.isMnemonicSpecified()) {
                jCheckBox.setMnemonic(mnemonicString.getMnemonicChar());
            }
            jCheckBox.setSelected(userInputField.isChoiceSelected(n));
            jCheckBox.addItemListener(this);
            jCheckBox.addFocusListener(this);
            if (color != null) {
                jCheckBox.setBackground(color);
            }
            jCheckBox.getAccessibleContext().setAccessibleName(String.valueOf(userInputField.getCaption()) + ". " + this.resolveString(userInputFieldChoiceArray[n].getDisplayName()));
            ++n;
        }
        this.setFieldPerComponent(userInputField, jPanel);
        this.setComponentPerField(jPanel, userInputField);
        return jPanel;
    }

    protected JComponent createDirectory(UserInputField userInputField) {
        JPanel jPanel = new JPanel(new ColumnLayout(this.getBrowseButtonSpacing()));
        JTextField jTextField = new JTextField(this.resolveString(userInputField.getValue()));
        jPanel.add((Component)jTextField, ColumnConstraints.createHorizontalFill());
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        jTextField.getDocument().putProperty("field", userInputField);
        JButton jButton = new JButton("  " + LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browse") + "  ");
        jPanel.add((Component)jButton, ColumnConstraints.createRightAlign());
        jButton.addActionListener(this);
        jButton.getAccessibleContext().setAccessibleName(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanelSwingImpl.directoryBrowseName"));
        jButton.setActionCommand("directory");
        this.setFieldPerComponent(userInputField, jButton);
        this.setFieldPerComponent(userInputField, jTextField);
        this.setComponentPerField(jTextField, userInputField);
        return jPanel;
    }

    protected JComponent createDropDown(UserInputField userInputField) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItemListener(this);
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            jComboBox.addItem(new MnemonicString(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())).toString());
            if (userInputField.isChoiceSelected(n)) {
                jComboBox.setSelectedIndex(n);
            }
            ++n;
        }
        jComboBox.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        this.setFieldPerComponent(userInputField, jComboBox);
        this.setComponentPerField(jComboBox, userInputField);
        return jComboBox;
    }

    protected JComponent createFieldUI(UserInputField userInputField) {
        switch (userInputField.getType()) {
            case 1: {
                return this.createLabel(userInputField);
            }
            case 2: {
                return this.createText(userInputField);
            }
            case 3: {
                return this.createPassword(userInputField);
            }
            case 4: {
                return this.createFile(userInputField);
            }
            case 5: {
                return this.createDirectory(userInputField);
            }
            case 6: {
                return this.createRadioList(userInputField);
            }
            case 7: {
                return this.createCheckList(userInputField);
            }
            case 8: {
                return this.createScrollableCheckList(userInputField);
            }
            case 9: {
                return this.createList(userInputField);
            }
            case 10: {
                return this.createDropDown(userInputField);
            }
        }
        return null;
    }

    protected JComponent createFile(UserInputField userInputField) {
        JPanel jPanel = new JPanel(new ColumnLayout(this.getBrowseButtonSpacing()));
        JTextField jTextField = new JTextField(this.resolveString(userInputField.getValue()));
        jPanel.add((Component)jTextField, ColumnConstraints.createHorizontalFill());
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        jTextField.getDocument().putProperty("field", userInputField);
        JButton jButton = new JButton("  " + LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "browse") + "  ");
        jPanel.add((Component)jButton, ColumnConstraints.createRightAlign());
        jButton.addActionListener(this);
        jButton.getAccessibleContext().setAccessibleName(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "UserInputPanelSwingImpl.fileBrowseName"));
        jButton.setActionCommand("file");
        this.setFieldPerComponent(userInputField, jButton);
        this.setFieldPerComponent(userInputField, jTextField);
        this.setComponentPerField(jTextField, userInputField);
        return jPanel;
    }

    protected JComponent createLabel(UserInputField userInputField) {
        return new SwingText(this.resolveString(userInputField.getValue()));
    }

    protected JComponent createList(UserInputField userInputField) {
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        String[] stringArray = new String[userInputFieldChoiceArray.length];
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            stringArray[n] = new MnemonicString(this.resolveString(userInputFieldChoiceArray[n].getDisplayName())).toString();
            ++n;
        }
        JList<String> jList = new JList<String>(stringArray);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(4);
        jList.addListSelectionListener(this);
        int n2 = 0;
        while (n2 < userInputFieldChoiceArray.length) {
            if (userInputField.isChoiceSelected(n2)) {
                jList.setSelectedIndex(n2);
            }
            ++n2;
        }
        jList.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        this.setFieldPerComponent(userInputField, jList);
        this.setComponentPerField(jList, userInputField);
        return new JScrollPane(jList);
    }

    protected JComponent createPassword(UserInputField userInputField) {
        JPasswordField jPasswordField = new JPasswordField(this.resolveString(userInputField.getValue()));
        jPasswordField.getDocument().addDocumentListener(this);
        jPasswordField.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        jPasswordField.getDocument().putProperty("field", userInputField);
        this.setFieldPerComponent(userInputField, jPasswordField);
        this.setComponentPerField(jPasswordField, userInputField);
        return jPasswordField;
    }

    protected JComponent createRadioList(UserInputField userInputField) {
        JPanel jPanel = new JPanel(new ColumnLayout(this.getListItemSpacing()));
        UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < userInputFieldChoiceArray.length) {
            MnemonicString mnemonicString = new MnemonicString(this.resolveString(userInputFieldChoiceArray[n].getDisplayName()));
            JRadioButton jRadioButton = new JRadioButton(mnemonicString.toString());
            jPanel.add((Component)jRadioButton, ColumnConstraints.createLeftAlign());
            buttonGroup.add(jRadioButton);
            if (mnemonicString.isMnemonicSpecified()) {
                jRadioButton.setMnemonic(mnemonicString.getMnemonicChar());
            }
            jRadioButton.setSelected(userInputField.isChoiceSelected(n));
            jRadioButton.addItemListener(this);
            jRadioButton.getAccessibleContext().setAccessibleParent(jPanel);
            jRadioButton.getAccessibleContext().setAccessibleName(String.valueOf(userInputField.getCaption()) + ". " + jRadioButton.getAccessibleContext().getAccessibleName());
            ++n;
        }
        this.setFieldPerComponent(userInputField, jPanel);
        this.setComponentPerField(jPanel, userInputField);
        return jPanel;
    }

    protected JComponent createScrollableCheckList(UserInputField userInputField) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(0, 110));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        jScrollPane.add(jPanel);
        jScrollPane.setViewportView(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(new JList().getBackground());
        JComponent jComponent = this.createCheckList(userInputField, jPanel.getBackground());
        jPanel.add((Component)jComponent, "Center");
        jComponent.setBackground(jPanel.getBackground());
        this.setFieldPerComponent(userInputField, jComponent);
        this.setComponentPerField(jComponent, userInputField);
        return jScrollPane;
    }

    protected JComponent createText(UserInputField userInputField) {
        JTextField jTextField = new JTextField(this.resolveString(userInputField.getValue()));
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getAccessibleContext().setAccessibleName(this.resolveString(userInputField.getCaption()));
        jTextField.getDocument().putProperty("field", userInputField);
        this.setFieldPerComponent(userInputField, jTextField);
        this.setComponentPerField(jTextField, userInputField);
        return jTextField;
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        super.entering(wizardBeanEvent);
        this.view.removeAll();
        this.unregisterFocusListener(this, this.view);
        this.view.setLayout(new UserInputPanelLayout());
        this.fieldsPerComponent.clear();
        this.componentsPerField.clear();
        this.scroll.getVerticalScrollBar().setValue(0);
        this.scroll.getHorizontalScrollBar().setValue(0);
        UserInputField[] userInputFieldArray = this.getUIP().getFields();
        int n = 0;
        int n2 = 0;
        while (n2 < userInputFieldArray.length) {
            JComponent jComponent = this.createFieldUI(userInputFieldArray[n2]);
            if (jComponent != null) {
                Insets insets = this.parseInsets(userInputFieldArray[n2].getInsets());
                String string = this.resolveString(userInputFieldArray[n2].getCaption());
                if (string.length() > 0) {
                    JLabel jLabel = this.createCaption(string, jComponent);
                    if (userInputFieldArray[n2].getCaptionLocation() == 1) {
                        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                        this.view.add((Component)jLabel, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, 0, insets.right), 1));
                        this.view.add((Component)jComponent, new UserInputPanelConstraints(new Insets(this.getCaptionSpacing(), insets.left, insets.bottom, insets.right), 2));
                    } else {
                        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 10));
                        this.view.add((Component)jLabel, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, 0, this.getCaptionSpacing()), 4));
                        this.view.add((Component)jComponent, new UserInputPanelConstraints(new Insets(insets.top + n, 0, insets.bottom, insets.right), 3));
                    }
                } else {
                    this.view.add((Component)jComponent, new UserInputPanelConstraints(new Insets(insets.top + n, insets.left, insets.bottom, insets.right), 2));
                }
                n = this.getUIP().getFieldSpacing();
            }
            ++n2;
        }
        this.registerFocusListener(this, this.view);
        this.validate();
    }

    protected int getBrowseButtonSpacing() {
        return 6;
    }

    protected int getCaptionSpacing() {
        return 0;
    }

    protected JComponent getComponentForField(UserInputField userInputField) {
        return (JComponent)this.componentsPerField.get(userInputField);
    }

    protected UserInputField getFieldForComponent(JComponent jComponent) {
        return (UserInputField)this.fieldsPerComponent.get(jComponent);
    }

    protected int getListItemSpacing() {
        return 0;
    }

    protected JFrame getParentFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    private UserInputPanel getUIP() {
        return (UserInputPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        Serializable serializable;
        super.initialize(wizardBeanEvent);
        try {
            serializable = Class.forName("com.ibm.wizard.platform.as400.IBMAS400PpkUtils");
            Method method = ((Class)serializable).getMethod("getSystemCompatibility", new Class[0]);
            int n = ((Class)serializable).getDeclaredField("REMOTEINSTALL").getInt(serializable);
            boolean bl = (Integer)method.invoke(null, new Object[0]) == n;
            FileService fileService = (FileService)this.getPanel().getServices().getService("fileService");
            boolean bl2 = ServiceFactory.getCurrentImplementorType(fileService).endsWith("IBMAS400FileServiceImpl");
            this.isRemote = bl && bl2;
        }
        catch (Exception exception) {
            this.isRemote = false;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.getContentPane().add((Component)this.scroll, "Center");
        serializable = new JPanel(new BorderLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.scroll.add((Component)serializable);
        this.scroll.setViewportView((Component)serializable);
        this.scroll.getVerticalScrollBar().setUnitIncrement(15);
        this.view = new JPanel();
        ((Container)serializable).add(this.view, "North");
        this.enableEvents(4L);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        UserInputField userInputField = (UserInputField)document.getProperty("field");
        try {
            userInputField.setValue(document.getText(0, document.getLength()));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block8: {
            Container container;
            UserInputField userInputField;
            block7: {
                if (!(itemEvent.getSource() instanceof JComboBox)) break block7;
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                UserInputField userInputField2 = this.getFieldForComponent(jComboBox);
                if (userInputField2 == null) break block8;
                UserInputFieldChoice[] userInputFieldChoiceArray = userInputField2.getChoices();
                int n = 0;
                while (n < jComboBox.getItemCount()) {
                    if (n < userInputFieldChoiceArray.length) {
                        userInputField2.setChoiceSelected(n, jComboBox.getSelectedIndex() == n);
                    }
                    ++n;
                }
                break block8;
            }
            if (itemEvent.getSource() instanceof JComponent && (userInputField = this.getFieldForComponent((JComponent)(container = ((JComponent)itemEvent.getSource()).getParent()))) != null) {
                UserInputFieldChoice[] userInputFieldChoiceArray = userInputField.getChoices();
                int n = 0;
                while (n < container.getComponentCount()) {
                    if (container.getComponent(n) instanceof JCheckBox && n < userInputFieldChoiceArray.length) {
                        userInputField.setChoiceSelected(n, ((JCheckBox)container.getComponent(n)).isSelected());
                    } else if (container.getComponent(n) instanceof JRadioButton && n < userInputFieldChoiceArray.length) {
                        userInputField.setChoiceSelected(n, ((JRadioButton)container.getComponent(n)).isSelected());
                    }
                    ++n;
                }
            }
        }
    }

    private Insets parseInsets(String string) {
        Insets insets;
        block11: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            insets = new Insets(0, 0, 0, 0);
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.top = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.left = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    insets.bottom = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!stringTokenizer.hasMoreTokens()) break block11;
            try {
                insets.right = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return insets;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        UserInputField userInputField = (UserInputField)document.getProperty("field");
        try {
            userInputField.setValue(document.getText(0, document.getLength()));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void selectField(UserInputField userInputField) {
        Container container = this.getComponentForField(userInputField);
        ((Component)container).requestFocus();
        if (container instanceof JTextField) {
            ((JTextField)container).selectAll();
        }
        while (container != null && container.getParent() != this.view) {
            container = container.getParent();
        }
        if (container != null) {
            float f = (float)container.getLocation().y / (float)this.view.getSize().height;
            JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum() + (int)(f * (float)(jScrollBar.getMaximum() - jScrollBar.getMinimum())));
        }
    }

    protected void setComponentPerField(JComponent jComponent, UserInputField userInputField) {
        this.componentsPerField.put(userInputField, jComponent);
    }

    protected void setFieldPerComponent(UserInputField userInputField, JComponent jComponent) {
        this.fieldsPerComponent.put(jComponent, userInputField);
    }

    protected void setMnemonicForButton(JButton jButton) {
        String string = jButton.getText().trim();
        if (string.length() > 0) {
            jButton.setMnemonic(string.charAt(0));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        UserInputField userInputField = this.getFieldForComponent(jList);
        if (userInputField != null) {
            int n = 0;
            while (n < jList.getModel().getSize()) {
                userInputField.setChoiceSelected(n, jList.isSelectedIndex(n));
                ++n;
            }
        }
    }
}

