/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

class BoxHorRule
extends Box {
    private boolean flagNoShade;
    private int rule_width;
    private int rule_thick;
    private int font_idx;

    BoxHorRule(DocContainer docContainer, int n, int n2, boolean bl, int n3) {
        super(docContainer);
        this.font_idx = n3;
        this.flagNoShade = bl;
        this.rule_width = n;
        this.rule_thick = n2;
        this.height = -1;
    }

    void setColor(Color color) {
        if (color.equals(Color.white)) {
            color = color.darker().darker();
        }
        if (color.equals(Color.black)) {
            color = Color.white;
        }
        super.setColor(color);
    }

    void paint(Graphics graphics) {
        graphics.setColor(this.color);
        int n = (this.height - this.rule_thick) / 2;
        if (this.flagNoShade) {
            graphics.fillRect(0, n, this.width - 1, this.rule_thick - 1);
            return;
        }
        graphics.draw3DRect(0, n, this.width - 1, this.rule_thick - 1, false);
    }

    void layout(int n, boolean bl) {
        int n2 = n;
        if (this.rule_width < 0) {
            n2 = -n2 * this.rule_width / 100;
        } else if (this.rule_width > 0) {
            n2 = this.rule_width;
        }
        if (this.height < 0) {
            this.doc.getFont(this.font_idx);
            FontMetrics fontMetrics = this.doc.getFontMetrics(this.font_idx);
            int n3 = fontMetrics.getHeight() + 2;
            if (this.rule_thick > n3 - 4) {
                n3 = this.rule_thick + 4;
            }
            this.height = n3;
        }
        this.resize(n2, this.height);
    }
}

