/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.arquivo;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class UtilArquivo {
    static /* synthetic */ Class class$br$com$politec$generico$arquivo$UtilArquivo;

    private UtilArquivo() {
    }

    public static InputStream getInputStream(String path) {
        InputStream is = null;
        if (!UtilArquivo.isVazio(path)) {
            is = UtilArquivo.getFileInputStream(path);
            is = UtilArquivo.getResourceAsStreamDoClassLoader(is, path);
            is = UtilArquivo.getResourceAsStream(is, path);
        }
        return is;
    }

    public static Properties getProperties(String path) {
        Properties properties = null;
        if (!UtilArquivo.isVazio(path)) {
            try {
                properties = new Properties();
                properties.load(UtilArquivo.getInputStream(path));
            }
            catch (IOException e) {
                UtilArquivo.getLog().warn("Erro ao recuperar carregar o arquivo " + path, e);
            }
        }
        return properties;
    }

    public static FileInputStream getFileInputStream(String path) {
        FileInputStream fis = null;
        if (!UtilArquivo.isVazio(path)) {
            try {
                fis = new FileInputStream(path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fis;
    }

    public static FileInputStream getFileInputStream(File arquivo) {
        FileInputStream fis = null;
        if (UtilArquivo.isReferencia(arquivo)) {
            try {
                fis = new FileInputStream(arquivo);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fis;
    }

    public static BufferedReader getBufferedReader(String path) {
        InputStream is;
        BufferedReader reader = null;
        if (!UtilArquivo.isVazio(path) && UtilArquivo.isReferencia(is = UtilArquivo.getInputStream(path))) {
            InputStreamReader isReader = new InputStreamReader(is);
            reader = new BufferedReader(isReader);
        }
        return reader;
    }

    public static BufferedReader getBufferedReader(Reader reader) {
        BufferedReader resultado = null;
        if (UtilArquivo.isReferencia(reader)) {
            resultado = new BufferedReader(reader);
        }
        return resultado;
    }

    public static BufferedReader getBufferedReader(File arquivo) {
        BufferedReader reader = null;
        if (UtilArquivo.isReferencia(arquivo) && arquivo.exists()) {
            try {
                FileReader fReader = new FileReader(arquivo);
                if (UtilArquivo.isReferencia(fReader)) {
                    reader = new BufferedReader(fReader);
                }
            }
            catch (FileNotFoundException e) {
                String path = arquivo.getAbsolutePath();
                UtilArquivo.getLog().warn("Erro ao recuperar carregar o arquivo " + path, e);
            }
        }
        return reader;
    }

    public static String getTextoDoArquivo(String path) {
        String texto = "";
        if (!UtilArquivo.isVazio(path)) {
            BufferedReader br = UtilArquivo.getBufferedReader(path);
            texto = UtilArquivo.getTextoDoArquivo(br);
        }
        return texto;
    }

    public static String getTextoDoArquivo(File arquivo) {
        String texto = "";
        if (UtilArquivo.isReferencia(arquivo)) {
            BufferedReader br = UtilArquivo.getBufferedReader(arquivo);
            texto = UtilArquivo.getTextoDoArquivo(br);
        }
        return texto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTextoDoArquivo(BufferedReader reader) {
        StringBuffer buffer = new StringBuffer();
        if (!UtilArquivo.isReferencia(reader)) return buffer.toString();
        String linha = null;
        try {
            try {
                while (UtilArquivo.isReferencia(linha = reader.readLine())) {
                    buffer.append(linha).append("\r\n");
                }
                Object var5_3 = null;
            }
            catch (IOException e) {
                UtilArquivo.getLog().warn("Erro ao ler o texto do reader.");
                Object var5_4 = null;
                if (!UtilArquivo.isReferencia(reader)) return buffer.toString();
                try {
                    try {
                        reader.close();
                        reader = null;
                        return buffer.toString();
                    }
                    catch (IOException e2) {
                        UtilArquivo.getLog().warn("Erro ao fechar o reader.", e2);
                        reader = null;
                        return buffer.toString();
                    }
                }
                catch (Throwable throwable) {
                    reader = null;
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!UtilArquivo.isReferencia(reader)) throw throwable;
            try {}
            catch (Throwable throwable2) {
                reader = null;
                throw throwable2;
            }
            try {}
            catch (IOException e2) {
                UtilArquivo.getLog().warn("Erro ao fechar o reader.", e2);
                reader = null;
                throw throwable;
            }
            reader.close();
            reader = null;
            throw throwable;
        }
        if (!UtilArquivo.isReferencia(reader)) return buffer.toString();
        try {}
        catch (Throwable throwable) {
            reader = null;
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            UtilArquivo.getLog().warn("Erro ao fechar o reader.", e2);
            reader = null;
            return buffer.toString();
        }
        reader.close();
        reader = null;
        return buffer.toString();
    }

    public static Collection getColecaoDeFile(String pathDaPasta) {
        File pasta;
        List res = UtilArquivo.getColecaoFactory().novoArrayList();
        if (!UtilArquivo.isVazio(pathDaPasta) && (pasta = new File(pathDaPasta)).isDirectory()) {
            File[] arquivos = pasta.listFiles();
            res.addAll(Arrays.asList(arquivos));
        }
        return res;
    }

    public static Collection getColecaoDeInputStream(String pathDaPasta) {
        List res = UtilArquivo.getColecaoFactory().novoArrayList();
        Iterator arquivos = UtilArquivo.getColecaoDeFile(pathDaPasta).iterator();
        while (arquivos.hasNext()) {
            File arquivo = (File)arquivos.next();
            res.add(UtilArquivo.getFileInputStream(arquivo));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream fechar(OutputStream stream) {
        if (UtilObjeto.isReferencia(stream)) {
            try {
                stream.close();
            }
            catch (IOException e) {
                UtilArquivo.getLog().warn("N\u00e3o foi poss\u00edvel fechar o stream", e);
            }
            finally {
                stream = null;
            }
        }
        return stream;
    }

    private static InputStream getResourceAsStream(InputStream inputStream, String path) {
        if (!UtilArquivo.isReferencia(inputStream)) {
            inputStream = (class$br$com$politec$generico$arquivo$UtilArquivo == null ? (class$br$com$politec$generico$arquivo$UtilArquivo = UtilArquivo.class$("br.com.politec.generico.arquivo.UtilArquivo")) : class$br$com$politec$generico$arquivo$UtilArquivo).getResourceAsStream(path);
        }
        return inputStream;
    }

    private static InputStream getResourceAsStreamDoClassLoader(InputStream inputStream, String path) {
        if (!UtilArquivo.isReferencia(inputStream)) {
            inputStream = UtilArquivo.getClassLoader().getResourceAsStream(path);
        }
        return inputStream;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$br$com$politec$generico$arquivo$UtilArquivo == null ? (class$br$com$politec$generico$arquivo$UtilArquivo = UtilArquivo.class$("br.com.politec.generico.arquivo.UtilArquivo")) : class$br$com$politec$generico$arquivo$UtilArquivo).getClassLoader();
        }
        return cl;
    }

    private static boolean isReferencia(Object obj) {
        return UtilObjeto.isReferencia(obj);
    }

    private static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

