/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.calculadores;

import br.com.politec.generico.calculadores.UtilCalculadoresAbstrato;
import br.com.politec.generico.calculadores.UtilSomadoresDeData;
import java.util.Calendar;
import java.util.Date;

public final class UtilSubtratoresDeData
extends UtilCalculadoresAbstrato {
    private UtilSubtratoresDeData() {
    }

    public static long getMinutosEntreDatas(Date dataInicial, Date dataFinal) {
        long res = 0L;
        if (UtilSubtratoresDeData.isReferencia(dataInicial, dataFinal)) {
            long milisInicial = dataInicial.getTime();
            long milisFinal = dataFinal.getTime();
            if (milisFinal > milisInicial) {
                res = (milisFinal - milisInicial) / 1000L / 60L;
            }
        }
        return res;
    }

    public static long getDiasEntreDatas(Date dataInicial, Date dataFinal) {
        long minutos;
        long result = 0L;
        if (UtilSubtratoresDeData.isReferencia(dataInicial, dataFinal) && (minutos = UtilSubtratoresDeData.getMinutosEntreDatas(dataInicial, dataFinal)) != 0L) {
            result = minutos / 1440L;
        }
        return result;
    }

    public static long getMesesEntreDatas(Date dataInicial, Date dataFinal) {
        long res = 0L;
        if (UtilSubtratoresDeData.isReferencia(dataInicial, dataFinal)) {
            Calendar calendarInicial = UtilSubtratoresDeData.novoCalendar(dataInicial);
            Calendar calendarFinal = UtilSubtratoresDeData.novoCalendar(dataFinal);
            if (UtilSubtratoresDeData.isDataFinalMaiorQueDataInicial(dataInicial, dataFinal)) {
                int anoInicial = calendarInicial.get(1);
                int anoFinal = calendarFinal.get(1);
                int mesInicial = calendarInicial.get(2);
                int mesFinal = calendarFinal.get(2);
                int diferencaDeAnos = anoFinal - anoInicial;
                int diferencaDeMeses = mesFinal - mesInicial;
                res = diferencaDeAnos * 12 + diferencaDeMeses;
            }
        }
        return res;
    }

    public static long getAnosEntreDatas(Date dateStart, Date dateEnd) {
        long result = 0L;
        if (UtilSubtratoresDeData.isReferencia(dateStart, dateEnd)) {
            Calendar calendarInicial = UtilSubtratoresDeData.novoCalendar(dateStart);
            Calendar calendarFinal = UtilSubtratoresDeData.novoCalendar(dateEnd);
            int anoInicial = calendarInicial.get(1);
            int anoFinal = calendarFinal.get(1);
            if (anoFinal > anoInicial) {
                result = anoFinal - anoInicial;
            }
        }
        return result;
    }

    public static Date getDataEntreDatas(Date dataInicial, Date dataFinal) {
        int dias = (int)UtilSubtratoresDeData.getDiasEntreDatas(dataInicial, dataFinal);
        return UtilSomadoresDeData.adicionarDias(dataFinal, dias * -1);
    }

    public static boolean isDataFinalMaiorQueDataInicial(Date dataInicial, Date dataFinal) {
        boolean result = false;
        if (UtilSubtratoresDeData.isReferencia(dataInicial, dataFinal)) {
            result = dataFinal.getTime() > dataInicial.getTime();
        }
        return result;
    }
}

