/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.conversor;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.conversor.UtilConversorAbstrato;
import br.com.politec.generico.conversor.UtilConversorDeBoolean;
import br.com.politec.generico.conversor.UtilConversorDeByte;
import br.com.politec.generico.conversor.UtilConversorDeCharacter;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import br.com.politec.generico.conversor.UtilConversorDeFloat;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeLong;
import br.com.politec.generico.conversor.UtilConversorDeShort;
import br.com.politec.generico.numerico.UtilNumero;
import br.com.politec.generico.string.UtilString;
import java.io.Reader;
import java.math.BigDecimal;

public final class UtilConversorDeString
extends UtilConversorAbstrato {
    private UtilConversorDeString() {
    }

    public static boolean converterSimNaoParaBooleano(String string) {
        boolean res = false;
        if (!UtilConversorDeString.isVazio(string) && UtilString.isTemString(string, Constante.getSim())) {
            res = true;
        }
        return res;
    }

    public static BigDecimal converterParaBigDecimal(String valor, int precisao) {
        BigDecimal bigDecimal = null;
        String valorSemMascara = UtilString.remover(valor, "[.,]");
        if (UtilNumero.isInteiro(valorSemMascara)) {
            bigDecimal = UtilConversorDeString.getNumeroFactory().novoBigDecimal(valorSemMascara, precisao);
        }
        return bigDecimal;
    }

    public static Integer converterParaInteger(String string) {
        return UtilConversorDeInteger.converterParaInteger(string);
    }

    public static int converterParaInt(String string) {
        return UtilConversorDeInteger.converterParaPrimitivo(string);
    }

    public static Long converterParaLong(String string) {
        return UtilConversorDeLong.converterParaLongWrapper(string);
    }

    public static Boolean converterParaBoolean(String string) {
        return UtilConversorDeBoolean.converterParaBooleanWrapper(string);
    }

    public static Byte converterParaByte(String string) {
        return UtilConversorDeByte.converterParaByteWrapper(string);
    }

    public static byte[] converterParaByteArray(String string) {
        return UtilString.getBytes(string);
    }

    public static Short converterParaShort(String string) {
        return UtilConversorDeShort.converterParaShortWrapper(string);
    }

    public static Character converterParaCharacter(String string) {
        return UtilConversorDeCharacter.converterParaCharacter(string);
    }

    public static Float converterParaFloat(String string) {
        return UtilConversorDeFloat.converterParaFloatWrapper(string);
    }

    public static Double converterParaDouble(String string) {
        return UtilConversorDeDouble.converterParaDoubleWrapper(string);
    }

    public static Reader converterParaReader(String string) {
        return UtilString.getReader(string);
    }
}

