/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.conversor;

import br.com.politec.generico.conversor.UtilConversorAbstrato;
import br.com.politec.generico.data.UtilData;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.pattern.UtilPatternsDeData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public final class UtilConversorDeTimestamp
extends UtilConversorAbstrato {
    private UtilConversorDeTimestamp() {
    }

    public static Timestamp converter(Date data) {
        Timestamp res = null;
        if (UtilConversorDeTimestamp.isReferencia(data)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoTimestamp(data.getTime());
        }
        return res;
    }

    public static Timestamp converter(String string, String pattern) {
        Timestamp res = null;
        Date data = UtilConversorDeTimestamp.parse(string, pattern);
        if (UtilConversorDeTimestamp.isReferencia(data)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoTimestamp(data.getTime());
        }
        return res;
    }

    public static Timestamp converter_ddMMyyyyEspacohhmmss(String string) {
        Timestamp res = null;
        String pattern = UtilPatternsDeData.getddMMyyyyEspacoHHmmss();
        Date date = UtilConversorDeTimestamp.parse(string, pattern);
        if (UtilConversorDeTimestamp.isReferencia(string)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoTimestamp(date.getTime());
        }
        return res;
    }

    public static Timestamp converter_ddMMyyyyEspacohhmm(String string) {
        Timestamp res = null;
        String pattern = UtilPatternsDeData.getddMMyyyyEspacoHHmm();
        Date date = UtilConversorDeTimestamp.parse(string, pattern);
        if (UtilConversorDeTimestamp.isReferencia(string)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoTimestamp(date.getTime());
        }
        return res;
    }

    public static Time converterParaTime(Timestamp timestamp) {
        Time res = null;
        if (UtilConversorDeTimestamp.isReferencia(timestamp)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoTime(timestamp.getTime());
        }
        return res;
    }

    public static Date converterParaDate(Timestamp timestamp) {
        Date res = null;
        if (UtilConversorDeTimestamp.isReferencia(timestamp)) {
            res = UtilConversorDeTimestamp.getDataFactory().novoDate(timestamp.getTime());
        }
        return res;
    }

    private static DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }

    private static Date parse(String stringData, String pattern) {
        return UtilData.parse(stringData, pattern);
    }
}

