/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.data;

import br.com.politec.generico.calculadores.UtilSubtratoresDeNumero;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumeroNoPeriodo;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class UtilData {
    private UtilData() {
    }

    public static int getDiasDoAno(Date data) {
        int res = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            res = calendar.getActualMaximum(6);
        }
        return res;
    }

    public static int getDiasDoAno(int ano) {
        int dias = 0;
        if (UtilData.getPrimeiroAnoDefault() <= ano) {
            Date data = null;
            int mes = UtilData.getPrimeiroMesDefault();
            int dia = UtilData.getPrimeiroDiaDoMesDefault();
            data = UtilData.getDataFactory().novoDate(dia, mes, ano);
            dias = UtilData.getDiasDoAno(data);
        }
        return dias;
    }

    public static int getDiasDoMes(Date data) {
        int res = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            res = calendar.getActualMaximum(5);
        }
        return res;
    }

    public static int getDiasDoMes(int month) {
        int res = 0;
        if (month > UtilData.getPrimeiroMesDefault()) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar();
            Date data = UtilData.getDataFactory().novoDate(UtilData.getPrimeiroDiaDoMesDefault(), month, calendar.get(1));
            res = UtilData.getDiasDoMes(data);
        }
        return res;
    }

    public static int getDiaDaSemana(Date data) {
        int res = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            res = calendar.get(7);
        }
        return res;
    }

    public static int getHoraNoFormatoDe12(Date data) {
        int res = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            res = calendar.get(10);
        }
        return res;
    }

    public static int getHoraNoFormatoDe24(Date data) {
        int res = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            res = calendar.get(11);
        }
        return res;
    }

    public static Date parse(String string, String pattern) {
        Date res = null;
        if (!UtilString.isVazio(string, pattern)) {
            SimpleDateFormat sdf = null;
            try {
                sdf = UtilData.getDataFactory().novoSimpleDateFormat(pattern);
                sdf.setLenient(false);
                res = sdf.parse(string);
            }
            catch (IllegalArgumentException e) {
                UtilData.getLog().warn("Pattern inv\u00e1lido", e);
            }
            catch (ParseException e) {
                UtilData.getLog().warn("Parser n\u00e3o efetuado", e);
            }
        }
        return res;
    }

    public static Date parse(String string, String pattern, boolean lenient) {
        Date res = null;
        if (!UtilString.isVazio(string, pattern)) {
            SimpleDateFormat sdf = null;
            try {
                sdf = UtilData.getDataFactory().novoSimpleDateFormat(pattern);
                sdf.setLenient(lenient);
                res = sdf.parse(string);
            }
            catch (IllegalArgumentException e) {
                UtilData.getLog().warn("Pattern inv\u00e1lido", e);
            }
            catch (ParseException e) {
                UtilData.getLog().warn("Parser n\u00e3o efetuado", e);
            }
        }
        return res;
    }

    public static int getAno(Date data) {
        int resultado = UtilData.getPrimeiroAnoDefault();
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            resultado = calendar.get(1);
        }
        return resultado;
    }

    public static int getMes(Date data) {
        int resultado = UtilData.getPrimeiroMesDefault();
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            resultado = calendar.get(2);
            ++resultado;
        }
        return resultado;
    }

    public static int getDia(Date data) {
        int resultado = UtilData.getPrimeiroDiaDoMesDefault();
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            resultado = calendar.get(5);
        }
        return resultado;
    }

    public static int getUltimoDiaDoMes(Date data) {
        int resultado = 0;
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            resultado = calendar.getActualMaximum(5);
        }
        return resultado;
    }

    public static int getUltimoDiaDoMes(int mes) {
        int result = 0;
        if (UtilValidadorDeNumeroNoPeriodo.validar(mes, UtilData.getJaneiro(), UtilData.getDezembro())) {
            Date data = UtilData.getDataFactory().novoDate();
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(5, UtilData.getPrimeiroDiaDoMesDefault());
            calendar.set(2, UtilSubtratoresDeNumero.subtrair(mes, 1));
            result = calendar.getActualMaximum(5);
        }
        return result;
    }

    public static int getUltimoDiaDoMes() {
        Date data = UtilData.getDataFactory().novoDate();
        return UtilData.getUltimoDiaDoMes(data);
    }

    public static Date ajustarData(Date data, int horas, int minutos, int segundos) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(10, horas);
            calendar.set(12, minutos);
            calendar.set(13, segundos);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarData(Date data, Time hora) {
        if (UtilObjeto.isReferencia(data, hora)) {
            Calendar horaCalendar = UtilData.getDataFactory().novoCalendar(hora);
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(10, horaCalendar.get(10));
            calendar.set(12, horaCalendar.get(12));
            calendar.set(13, horaCalendar.get(13));
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaHora(Date data, int hora) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(11, hora);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaMinuto(Date data, int minuto) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(12, minuto);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaSegundos(Date data, int segundos) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(13, segundos);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaDia(Date data, int dia) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(5, dia);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaMes(Date data, int mes) {
        if (UtilObjeto.isReferencia(data)) {
            mes = UtilSubtratoresDeNumero.subtrair(mes, 1);
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(2, mes);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaAno(Date data, int ano) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(1, ano);
            data = calendar.getTime();
        }
        return data;
    }

    public static Date ajustarDataParaMilisegundo(Date data, int milisegundos) {
        if (UtilObjeto.isReferencia(data)) {
            Calendar calendar = UtilData.getDataFactory().novoCalendar(data);
            calendar.set(14, milisegundos);
            data = calendar.getTime();
        }
        return data;
    }

    public static void ajustarTimeZone(String identificador) {
        TimeZone timeZone = UtilData.getDataFactory().novoTimeZone(identificador);
        TimeZone.setDefault(timeZone);
    }

    public static Date getDataNula() {
        int dia = UtilData.getPrimeiroDiaDoMesDefault();
        int mes = UtilData.getPrimeiroMesDefault();
        int ano = UtilData.getPrimeiroAnoDefault();
        return UtilData.getDataFactory().novoDate(dia, mes, ano);
    }

    public static int getPrimeiroDiaDoMesDefault() {
        return 1;
    }

    public static int getPrimeiroMesDefault() {
        return 0;
    }

    public static int getPrimeiroAnoDefault() {
        return 1800;
    }

    public static int getJaneiro() {
        return 1;
    }

    public static int getFevereiro() {
        return 2;
    }

    public static int getMarco() {
        return 3;
    }

    public static int getAbril() {
        return 4;
    }

    public static int getMaio() {
        return 5;
    }

    public static int getJunho() {
        return 6;
    }

    public static int getJulho() {
        return 7;
    }

    public static int getAgosto() {
        return 8;
    }

    public static int getSetembro() {
        return 9;
    }

    public static int getOutubro() {
        return 10;
    }

    public static int getNovembro() {
        return 11;
    }

    public static int getDezembro() {
        return 12;
    }

    private static DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

