/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.estrategia;

import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.arquivo.UtilCarregarMapaDeObjetos;
import br.com.politec.generico.constante.Arquivo;
import br.com.politec.generico.conversor.instancia.ConversorDeStringParaString;
import br.com.politec.generico.conversor.instancia.IConversor;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.util.Map;
import java.util.Properties;

public final class UtilEstrategiaDeConversores {
    private static Map conversores;

    private UtilEstrategiaDeConversores() {
    }

    public static void adicionarConversor(String tipo, IConversor conversor) {
        if (!UtilString.isVazio(tipo) && UtilObjeto.isReferencia(conversor)) {
            UtilEstrategiaDeConversores.getConversores().put(tipo, conversor);
        }
    }

    public static void alterarConversor(String tipo, IConversor conversor) {
        UtilEstrategiaDeConversores.adicionarConversor(tipo, conversor);
    }

    public static IConversor getConversor(Class tipo) {
        String chave = UtilObjeto.getNome(tipo);
        if (!UtilObjeto.isReferencia(chave)) {
            chave = UtilEstrategiaDeConversores.getTipoConversorPadrao();
        }
        return UtilEstrategiaDeConversores.getConversor(chave);
    }

    public static IConversor getConversor(String tipo) {
        IConversor conversor = (IConversor)UtilEstrategiaDeConversores.getConversores().get(tipo);
        if (!UtilObjeto.isReferencia(conversor)) {
            conversor = UtilEstrategiaDeConversores.getConversorPadrao();
        }
        return conversor;
    }

    public static Map getConversores() {
        if (!UtilObjeto.isReferencia(conversores)) {
            String arquivo = Arquivo.getPathConversoresPadraoProperties();
            Properties properties = UtilArquivo.getProperties(arquivo);
            UtilCarregarMapaDeObjetos util = new UtilCarregarMapaDeObjetos();
            conversores = util.getMapa(properties);
        }
        return conversores;
    }

    public static IConversor getConversorPadrao() {
        return new ConversorDeStringParaString();
    }

    public static String getTipoConversorPadrao() {
        return "java.lang.String";
    }

    public static IConversor removerConversor(String tipo) {
        IConversor conversor = null;
        if (!UtilString.isVazio(tipo)) {
            conversor = (IConversor)UtilEstrategiaDeConversores.getConversores().remove(tipo);
        }
        return conversor;
    }

    public static void setConversores(Map conversores) {
        UtilEstrategiaDeConversores.conversores = conversores;
    }
}

