/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.fabrica;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public final class NumeroFactory {
    private static NumeroFactory instance = new NumeroFactory();

    private NumeroFactory() {
    }

    public static NumeroFactory getInstance() {
        return instance;
    }

    public NumberFormat novoNumberFormat() {
        return NumberFormat.getInstance(this.novoLocaleBrasil());
    }

    public DecimalFormat novoDecimalFormat() {
        int qtd = Constante.getQuantidadeMinimaDeCasasDecimais();
        DecimalFormat df = null;
        df = (DecimalFormat)NumberFormat.getInstance(this.novoLocaleBrasil());
        df.setMinimumFractionDigits(qtd);
        return df;
    }

    public DecimalFormat novoDecimalFormat(int qtdCasasDecimais) {
        DecimalFormat df = this.novoDecimalFormat();
        df.setMinimumFractionDigits(qtdCasasDecimais);
        df.setMaximumFractionDigits(qtdCasasDecimais);
        return df;
    }

    public Integer novoInteger(int valor) {
        return new Integer(valor);
    }

    public Integer novoInteger(String valor) {
        return new Integer(valor);
    }

    public Long novoLong(long valor) {
        return new Long(valor);
    }

    public Long novoLong(String valor) {
        return new Long(valor);
    }

    public Short novoShort(short valor) {
        return new Short(valor);
    }

    public Short novoShort(String valor) {
        return new Short(valor);
    }

    public Float novoFloat(float valor) {
        return new Float(valor);
    }

    public Float novoFloat(String valor) {
        return new Float(valor);
    }

    public Double novoDouble(double valor) {
        return new Double(valor);
    }

    public BigInteger novoBigInteger(String valor) {
        return new BigInteger(valor);
    }

    public BigDecimal novoBigDecimal(String valor, int precisao) {
        return new BigDecimal(this.novoBigInteger(valor), precisao);
    }

    public BigDecimal novoBigDecimal(String string) {
        return new BigDecimal(string);
    }

    private Locale novoLocaleBrasil() {
        return Constante.getLocaleBrasil();
    }

    public BigDecimal novoBigDecimal(Double _double) {
        double d = UtilConversorDeDouble.converterParaPrimitivo(_double);
        return this.novoBigDecimal(d);
    }

    public BigDecimal novoBigDecimal(double _double) {
        return new BigDecimal(_double);
    }

    public Byte novoByte(byte _byte) {
        return new Byte(_byte);
    }

    public Byte novoByte(String _byte) {
        return new Byte(_byte);
    }
}

