/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.formatador;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.fabrica.NumeroFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public abstract class UtilFormatadorAbstrato {
    protected static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    protected static boolean isVazio(String string1, String string2) {
        return UtilString.isVazio(string1, string2);
    }

    protected static boolean isVazio(String string1, String string2, String string3) {
        return UtilString.isVazio(string1, string2, string3);
    }

    protected static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected static String formatarString(String string, String pattern) {
        JFormattedTextField format = UtilFormatadorAbstrato.novoJFormattedTextField(pattern);
        format.setText(string);
        return format.getText();
    }

    protected static String formatarData(Date data, String pattern) {
        String res = null;
        if (UtilFormatadorAbstrato.isReferencia(data) && !UtilFormatadorAbstrato.isVazio(pattern)) {
            res = UtilFormatadorAbstrato.novoSimpleDateFormat(pattern).format(data);
        }
        return res;
    }

    protected static String formatarNumero(Number number) {
        String res = null;
        if (UtilFormatadorAbstrato.isReferencia(number)) {
            res = UtilFormatadorAbstrato.novoNumberFormat().format(number);
        }
        return res;
    }

    protected static String formatarReal(Number number) {
        String result = null;
        if (UtilFormatadorAbstrato.isReferencia(number)) {
            result = UtilFormatadorAbstrato.novoDecimalFormat().format(number);
        }
        return result;
    }

    protected static String formatarReal(Number number, int casasDecimais) {
        String result = null;
        if (UtilFormatadorAbstrato.isReferencia(number)) {
            result = UtilFormatadorAbstrato.novoDecimalFormat(casasDecimais).format(number);
        }
        return result;
    }

    protected static String getSeparadorDecimal() {
        char separador = UtilFormatadorAbstrato.novoDecimalFormatSymbols().getDecimalSeparator();
        return String.valueOf(separador);
    }

    protected static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    private static DecimalFormatSymbols novoDecimalFormatSymbols() {
        return UtilFormatadorAbstrato.novoDecimalFormat().getDecimalFormatSymbols();
    }

    private static SimpleDateFormat novoSimpleDateFormat(String pattern) {
        return UtilFormatadorAbstrato.getDataFactory().novoSimpleDateFormat(pattern);
    }

    private static JFormattedTextField novoJFormattedTextField(String pattern) {
        return new JFormattedTextField(UtilFormatadorAbstrato.novoMaskFormatter(pattern));
    }

    private static MaskFormatter novoMaskFormatter(String pattern) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(pattern);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return formatter;
    }

    private static DecimalFormat novoDecimalFormat() {
        return UtilFormatadorAbstrato.getNumeroFactory().novoDecimalFormat();
    }

    private static DecimalFormat novoDecimalFormat(int casasDecimais) {
        return UtilFormatadorAbstrato.getNumeroFactory().novoDecimalFormat(casasDecimais);
    }

    private static NumberFormat novoNumberFormat() {
        return UtilFormatadorAbstrato.getNumeroFactory().novoNumberFormat();
    }

    protected static NumeroFactory getNumeroFactory() {
        return NumeroFactory.getInstance();
    }

    private static DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }
}

