/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.jdbc;

import br.com.politec.generico.excecao.GenericoException;
import br.com.politec.generico.excecao.GenericoRuntimeException;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.util.UtilGenericoException;
import br.com.politec.generico.util.UtilGenericoRuntimeException;
import br.com.politec.generico.validador.UtilValidadorDeNumerosIguais;
import br.com.politec.generico.validador.UtilValidadorDeStringsIguais;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public final class UtilJdbc {
    private UtilJdbc() {
    }

    public static PreparedStatement novoPreparedStatement(Connection conexao, String sql) throws GenericoException {
        PreparedStatement statement = null;
        if (UtilJdbc.isReferencia(conexao) && !UtilJdbc.isVazio(sql)) {
            try {
                statement = conexao.prepareStatement(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoCriarOStatement(e);
            }
        }
        return statement;
    }

    public static CallableStatement novoCallableStatement(Connection conexao, String sql) throws GenericoException {
        CallableStatement statement = null;
        if (UtilJdbc.isReferencia(conexao) && !UtilJdbc.isVazio(sql)) {
            try {
                statement = conexao.prepareCall(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoCriarOStatement(e);
            }
        }
        return statement;
    }

    public static boolean executar(PreparedStatement statement) throws GenericoException {
        boolean resultado = false;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.execute();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static ResultSet executarQuery(PreparedStatement statement) throws GenericoException {
        ResultSet resultado = null;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.executeQuery();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static ResultSet executarQuery(PreparedStatement statement, String sql) throws GenericoException {
        ResultSet resultado = null;
        if (UtilJdbc.isReferencia(statement) && !UtilJdbc.isVazio(sql)) {
            try {
                resultado = statement.executeQuery(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, sql);
            }
        }
        return resultado;
    }

    public static int executarUpdate(PreparedStatement statement) throws GenericoException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.executeUpdate();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static int executarUpdate(PreparedStatement statement, String sql) throws GenericoException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(statement) && !UtilJdbc.isVazio(sql)) {
            try {
                resultado = statement.executeUpdate(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, sql);
            }
        }
        return resultado;
    }

    public static boolean executar(CallableStatement statement) throws GenericoException {
        boolean resultado = false;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.execute();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static ResultSet executarQuery(CallableStatement statement) throws GenericoException {
        ResultSet resultado = null;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.executeQuery();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static ResultSet executarQuery(CallableStatement statement, String sql) throws GenericoException {
        ResultSet resultado = null;
        if (UtilJdbc.isReferencia(statement) && !UtilJdbc.isVazio(sql)) {
            try {
                resultado = statement.executeQuery(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, sql);
            }
        }
        return resultado;
    }

    public static int executarUpdate(CallableStatement statement) throws GenericoException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                resultado = statement.executeUpdate();
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, "");
            }
        }
        return resultado;
    }

    public static int executarUpdate(CallableStatement statement, String sql) throws GenericoException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(statement) && !UtilJdbc.isVazio(sql)) {
            try {
                resultado = statement.executeUpdate(sql);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoInvocarSQL(e, sql);
            }
        }
        return resultado;
    }

    public static Object getObjeto(CallableStatement statement, int indice) throws GenericoException {
        Object res = null;
        if (UtilJdbc.isReferencia(statement)) {
            try {
                res = statement.getObject(indice);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoRecuperarAColunaDoCallable(indice, e);
            }
        }
        return res;
    }

    public static Object getObjeto(ResultSet resultSet, String coluna) throws GenericoException {
        Object res = null;
        if (UtilJdbc.isReferencia(resultSet)) {
            try {
                res = resultSet.getObject(coluna);
            }
            catch (SQLException e) {
                throw UtilGenericoException.erroAoRecuperarAColunaDoResultSet(coluna, e);
            }
        }
        return res;
    }

    public static boolean isProximoRegistro(ResultSet resultSet) throws GenericoRuntimeException {
        boolean resultado = false;
        if (UtilJdbc.isReferencia(resultSet)) {
            try {
                resultado = resultSet.next();
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoIrAoProximoRegistroDoResultset(e);
            }
        }
        return resultado;
    }

    public static ResultSetMetaData getMetaData(ResultSet resultSet) throws GenericoRuntimeException {
        ResultSetMetaData resultado = null;
        if (UtilJdbc.isReferencia(resultSet)) {
            try {
                resultado = resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoRecuperarOMetadata(e);
            }
        }
        return resultado;
    }

    public static int getColunas(ResultSetMetaData metaData) throws GenericoRuntimeException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(metaData)) {
            try {
                resultado = metaData.getColumnCount();
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoRecuperarAQuantidadeDeColunasDoRegistro(e);
            }
        }
        return resultado;
    }

    public static String getNomeDaColuna(ResultSetMetaData metaData, int indice) throws GenericoRuntimeException {
        String resultado = null;
        if (UtilJdbc.isReferencia(metaData)) {
            try {
                resultado = metaData.getColumnName(indice);
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoRecuperarONomeDaColunaDoRegistro(e);
            }
        }
        return resultado;
    }

    public static String getTipoDaColuna(ResultSetMetaData metaData, int indice) throws GenericoRuntimeException {
        String resultado = null;
        if (UtilJdbc.isReferencia(metaData)) {
            try {
                resultado = metaData.getColumnTypeName(indice);
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoRecuperarOTipoDaColunaDoRegistro(e);
            }
        }
        return resultado;
    }

    public static int getCodigoDoTipoDaColuna(ResultSetMetaData metaData, int indice) throws GenericoRuntimeException {
        int resultado = 0;
        if (UtilJdbc.isReferencia(metaData)) {
            try {
                resultado = metaData.getColumnType(indice);
            }
            catch (SQLException e) {
                throw UtilGenericoRuntimeException.erroAoRecuperarOTipoDaColunaDoRegistro(e);
            }
        }
        return resultado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statement fechar(Statement statement) {
        if (UtilJdbc.isReferencia(statement)) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                UtilJdbc.getLog().warn("N\u00e3o foi poss\u00edvel fechar o statement", e);
            }
            finally {
                statement = null;
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet fechar(ResultSet resultSet) {
        if (UtilJdbc.isReferencia(resultSet)) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                UtilJdbc.getLog().warn("N\u00e3o foi poss\u00edvel fechar o resultset", e);
            }
            finally {
                resultSet = null;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection fechar(Connection conexao) {
        if (UtilJdbc.isReferencia(conexao)) {
            try {
                conexao.close();
            }
            catch (SQLException e) {
                UtilJdbc.getLog().warn("N\u00e3o foi poss\u00edvel fechar a conex\u00e3o", e);
            }
            finally {
                conexao = null;
            }
        }
        return conexao;
    }

    public static void fechar(Connection conexao, Statement statement, ResultSet resultSet) {
        UtilJdbc.fechar(resultSet);
        UtilJdbc.fechar(statement);
        UtilJdbc.fechar(conexao);
    }

    public static boolean isNulo(byte _byte) {
        byte valorDefault = UtilPrimitivo.getValorDefaultByte();
        return UtilValidadorDeNumerosIguais.validar(_byte, valorDefault);
    }

    public static boolean isNulo(short _short) {
        short valorDefault = UtilPrimitivo.getValorDefaultShort();
        return UtilValidadorDeNumerosIguais.validar(_short, valorDefault);
    }

    public static boolean isNulo(int _int) {
        int valorDefault = UtilPrimitivo.getValorDefaultInt();
        return UtilValidadorDeNumerosIguais.validar(_int, valorDefault);
    }

    public static boolean isNulo(long _long) {
        long valorDefault = UtilPrimitivo.getValorDefaultLong();
        return UtilValidadorDeNumerosIguais.validar(_long, valorDefault);
    }

    public static boolean isNulo(char _char) {
        char valorDefault = UtilPrimitivo.getValorDefaultChar();
        return UtilValidadorDeStringsIguais.validar(_char, valorDefault);
    }

    public static boolean isNulo(float _float) {
        float valorDefault = UtilPrimitivo.getValorDefaultFloat();
        return UtilValidadorDeNumerosIguais.validar(_float, valorDefault);
    }

    public static boolean isNulo(double _double) {
        double valorDefault = UtilPrimitivo.getValorDefaultDouble();
        return UtilValidadorDeNumerosIguais.validar(_double, valorDefault);
    }

    public static boolean isNulo(Byte objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo((byte)objeto);
    }

    public static boolean isNulo(Short objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo((short)objeto);
    }

    public static boolean isNulo(Integer objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo((int)objeto);
    }

    public static boolean isNulo(Character objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo(objeto.charValue());
    }

    public static boolean isNulo(Boolean objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(Float objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo(objeto.floatValue());
    }

    public static boolean isNulo(Double objeto) {
        return !UtilObjeto.isReferencia(objeto) || UtilJdbc.isNulo((double)objeto);
    }

    public static boolean isNulo(String objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(Date objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(Time objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(Timestamp objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(InputStream objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    public static boolean isNulo(Reader objeto) {
        return !UtilObjeto.isReferencia(objeto);
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    private static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

