/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.numerico;

import br.com.politec.generico.pattern.UtilPatternsDeNumero;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumeroInicialMaiorQueNumeroFinal;
import java.util.Random;
import java.util.regex.Pattern;

public final class UtilNumero {
    private UtilNumero() {
    }

    public static boolean isInteiro(String string) {
        boolean res = false;
        if (!UtilString.isVazio(string)) {
            res = Pattern.matches(UtilPatternsDeNumero.getInteger(), string);
        }
        return res;
    }

    public static boolean isReal(String string) {
        boolean result = false;
        if (!UtilString.isVazio(string)) {
            string = UtilString.substituirString(string, "[.]", "");
            result = Pattern.matches(UtilPatternsDeNumero.getReal(), string);
        }
        return result;
    }

    public static int getAleatorio(int faixaFinal) {
        int resultado = 0;
        if (UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(faixaFinal, 0)) {
            Random random = new Random();
            resultado = random.nextInt(faixaFinal);
        }
        return resultado;
    }

    public static int getAleatorio(int faixaInicial, int faixaFinal) {
        int resultado = 0;
        if (UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(faixaFinal, faixaInicial)) {
            resultado = UtilNumero.getAleatorio(faixaInicial) + 1;
            resultado += faixaFinal - faixaInicial;
        }
        return resultado;
    }
}

