/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.temporizador;

import br.com.politec.generico.calculadores.UtilDivisoresDeNumero;
import br.com.politec.generico.calculadores.UtilSubtratoresDeNumero;
import br.com.politec.generico.excecao.TemporizadorException;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import br.com.politec.generico.mensagem.UtilMensagem;
import br.com.politec.generico.util.UtilTemporizadorException;
import br.com.politec.generico.validador.UtilValidadorDeNumeroInicialMaiorQueNumeroFinal;

public class UtilTemporizador {
    private int tempoSugerido;
    private long inicio;
    private long fim;

    protected UtilTemporizador(int tempoSugerido) {
        this.setTempoSugerido(tempoSugerido);
    }

    public static UtilTemporizador novaInstancia(int tempoSugerido) {
        return new UtilTemporizador(tempoSugerido);
    }

    public void iniciar() {
        this.inicio = this.getMilisegundosAtual();
    }

    public void finalizar() {
        this.fim = this.getMilisegundosAtual();
    }

    public int getTempoDecorrido() {
        int milis = (int)UtilSubtratoresDeNumero.subtrair(this.fim, this.inicio);
        return (int)UtilDivisoresDeNumero.dividir(milis, 1000);
    }

    public void log() {
        int sugerido;
        int decorrido = this.getTempoDecorrido();
        if (UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(decorrido, sugerido = this.getTempoSugerido())) {
            this.getLog().warn(this.getMensagemDeLog(), this.getTempoDeRespostaExpirado());
        } else {
            this.getLog().info(this.getMensagemDeLog());
        }
    }

    public void validar() throws TemporizadorException {
        int sugerido;
        int decorrido = this.getTempoDecorrido();
        if (UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(decorrido, sugerido = this.getTempoSugerido())) {
            throw this.getTempoDeRespostaExpirado();
        }
    }

    protected TemporizadorException getTempoDeRespostaExpirado() {
        int decorrido = this.getTempoDecorrido();
        int sugerido = this.getTempoSugerido();
        return UtilTemporizadorException.tempoDeRespostaExpirado(decorrido, sugerido);
    }

    protected long getMilisegundosAtual() {
        return System.currentTimeMillis();
    }

    protected LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    protected int getTempoSugerido() {
        return this.tempoSugerido;
    }

    protected void setTempoSugerido(int tempo) {
        this.tempoSugerido = tempo;
    }

    protected String getMensagemDeLog() {
        int decorrido = this.getTempoDecorrido();
        int sugerido = this.getTempoSugerido();
        return this.getUtilMensagem().getTempoDeResposta(decorrido, sugerido);
    }

    protected UtilMensagem getUtilMensagem() {
        return UtilMensagem.getInstancia();
    }
}

