/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.util;

import br.com.politec.generico.constante.Mensagem;
import br.com.politec.generico.excecao.ExceptionAbstrato;
import br.com.politec.generico.excecao.GenericoException;
import br.com.politec.generico.excecao.UtilExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import java.sql.SQLException;

public final class UtilGenericoException
extends UtilExcecaoAbstrato {
    public static GenericoException erro(Throwable e) {
        String chave = Mensagem.getErro();
        return UtilGenericoException.converter(UtilGenericoException.novaExcecao(e, chave));
    }

    private static GenericoException converter(ExceptionAbstrato e) {
        GenericoException excecao = new GenericoException(e);
        UtilGenericoException.getLog().error("Ocorreu um erro.", excecao);
        return excecao;
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    public static GenericoException erroAoCriarOStatement(SQLException e) {
        String chave = Mensagem.getErroAoCriarOStatement();
        String erro = UtilGenericoException.getMensagem(e);
        return UtilGenericoException.converter(UtilGenericoException.novaExcecao(e, chave, erro));
    }

    public static GenericoException erroAoInvocarSQL(SQLException e, String sql) {
        String chave = Mensagem.getErroAoInvocarSQL();
        String erro = UtilGenericoException.getMensagem(e);
        return UtilGenericoException.converter(UtilGenericoException.novaExcecao(e, chave, erro, sql));
    }

    public static GenericoException erroAoRecuperarAColunaDoCallable(int indice, SQLException e) {
        String chave = Mensagem.getErroAoRecuperarAColunaDoCallable();
        String coluna = String.valueOf(indice);
        String erro = UtilGenericoException.getMensagem(e);
        return UtilGenericoException.converter(UtilGenericoException.novaExcecao(e, chave, coluna, erro));
    }

    public static GenericoException erroAoRecuperarAColunaDoResultSet(String coluna, SQLException e) {
        String chave = Mensagem.getErroAoRecuperarAColunaDoResultSet();
        String erro = UtilGenericoException.getMensagem(e);
        return UtilGenericoException.converter(UtilGenericoException.novaExcecao(e, chave, coluna, erro));
    }
}

