/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.util;

import br.com.politec.generico.constante.Mensagem;
import br.com.politec.generico.excecao.GenericoRuntimeException;
import br.com.politec.generico.excecao.RuntimeExceptionAbstrato;
import br.com.politec.generico.excecao.UtilRuntimeExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import java.sql.SQLException;

public final class UtilGenericoRuntimeException
extends UtilRuntimeExcecaoAbstrato {
    private UtilGenericoRuntimeException() {
    }

    public static GenericoRuntimeException erro(Throwable e) {
        String chave = Mensagem.getErro();
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave));
    }

    public static GenericoRuntimeException erroAoCriarInstancia(String classe) {
        String chave = Mensagem.getErroAoCriarInstancia();
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(chave, classe));
    }

    private static GenericoRuntimeException converter(RuntimeExceptionAbstrato e) {
        GenericoRuntimeException excecao = new GenericoRuntimeException(e);
        UtilGenericoRuntimeException.getLog().error("Ocorreu um erro.", excecao);
        return excecao;
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    public static GenericoRuntimeException erroAoIrAoProximoRegistroDoResultset(SQLException e) {
        String chave = Mensagem.getErroAoIrAoProximoRegistroDoResultset();
        String erro = UtilGenericoRuntimeException.getMensagem(e);
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave, erro));
    }

    public static GenericoRuntimeException erroAoRecuperarOMetadata(SQLException e) {
        String chave = Mensagem.getErroAoRecuperarOMetadata();
        String erro = UtilGenericoRuntimeException.getMensagem(e);
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave, erro));
    }

    public static GenericoRuntimeException erroAoRecuperarAQuantidadeDeColunasDoRegistro(SQLException e) {
        String chave = Mensagem.getErroAoRecuperarAQuantidadeDeColunasDoRegistro();
        String erro = UtilGenericoRuntimeException.getMensagem(e);
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave, erro));
    }

    public static GenericoRuntimeException erroAoRecuperarONomeDaColunaDoRegistro(SQLException e) {
        String chave = Mensagem.getErroAoRecuperarONomeDaColunaDoRegistro();
        String erro = UtilGenericoRuntimeException.getMensagem(e);
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave, erro));
    }

    public static GenericoRuntimeException erroAoRecuperarOTipoDaColunaDoRegistro(SQLException e) {
        String chave = Mensagem.getErroAoRecuperarOTipoDaColunaDoRegistro();
        String erro = UtilGenericoRuntimeException.getMensagem(e);
        return UtilGenericoRuntimeException.converter(UtilGenericoRuntimeException.novaExcecao(e, chave, erro));
    }
}

