/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.validador;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorAbstrato;

public final class UtilValidadorDeCNPJ
extends UtilValidadorAbstrato {
    private UtilValidadorDeCNPJ() {
    }

    public static boolean validar(Number cnpj) {
        boolean res = false;
        if (UtilValidadorDeCNPJ.isReferencia(cnpj)) {
            res = UtilValidadorDeCNPJ.validar(cnpj.toString());
        }
        return res;
    }

    public static boolean validar(long cnpj) {
        return UtilValidadorDeCNPJ.validar(new Long(cnpj));
    }

    public static boolean validar(String cnpj) {
        int i;
        if (cnpj == null || cnpj.length() < UtilValidadorDeCNPJ.getQuantidadeDeCaracteresDoCNPJ()) {
            return false;
        }
        boolean result = false;
        int tamanho = (cnpj = cnpj.trim()).length();
        if (tamanho > UtilValidadorDeCNPJ.getQuantidadeDeCaracteresDoCNPJ() && tamanho < 19) {
            cnpj = UtilString.removerCaracteres(cnpj);
        }
        if (cnpj.length() > UtilValidadorDeCNPJ.getQuantidadeDeCaracteresDoCNPJ()) {
            return false;
        }
        int position = 0;
        int j = 5;
        for (i = 0; i < 12; ++i) {
            position += j-- * (cnpj.charAt(i) - 48);
            if (j >= 2) continue;
            j = 9;
        }
        if ((position = 11 - position % 11) > 9) {
            position = 0;
        }
        if (position == cnpj.charAt(12) - 48) {
            position = 0;
            j = 6;
            for (i = 0; i < 13; ++i) {
                position += j-- * (cnpj.charAt(i) - 48);
                if (j >= 2) continue;
                j = 9;
            }
            if ((position = 11 - position % 11) > 9) {
                position = 0;
            }
            if (position == cnpj.charAt(13) - 48) {
                result = true;
            }
        }
        return result;
    }

    private static int getQuantidadeDeCaracteresDoCNPJ() {
        return Constante.getQuantidadeDeCaracteresDoCNPJ();
    }
}

