/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.validador;

import br.com.politec.generico.data.UtilData;
import br.com.politec.generico.validador.UtilValidadorAbstrato;
import br.com.politec.generico.validador.UtilValidadorDeNumeroInicialMaiorQueNumeroFinal;
import java.util.Date;

public final class UtilValidadorDeDataNoPeriodo
extends UtilValidadorAbstrato {
    private UtilValidadorDeDataNoPeriodo() {
    }

    public static boolean validar(Date data, Date dataInicial, Date dataFinal) {
        boolean result = false;
        if (UtilValidadorDeDataNoPeriodo.isReferencia(data, dataInicial, dataFinal)) {
            data = UtilData.ajustarDataParaMilisegundo(data, 0);
            dataInicial = UtilData.ajustarDataParaMilisegundo(dataInicial, 0);
            dataFinal = UtilData.ajustarDataParaMilisegundo(dataFinal, 0);
            int comparacaoInicial = data.compareTo(dataInicial);
            int comparacaoFinal = data.compareTo(dataFinal);
            result = comparacaoInicial >= 0 && comparacaoFinal <= 0;
        }
        return result;
    }

    public static boolean validarNoAno(Date data, int anoInicial, int anoFinal) {
        boolean result = false;
        if (UtilValidadorDeDataNoPeriodo.isReferencia(data) && UtilValidadorDeDataNoPeriodo.isAnoFinalMaiorQueAnoInicial(anoFinal, anoInicial)) {
            Date dataInicial = UtilValidadorDeDataNoPeriodo.novoDate(UtilValidadorDeDataNoPeriodo.getPrimeiroDiaDoMesDefault(), UtilValidadorDeDataNoPeriodo.getJaneiro(), anoInicial, 0, 0, 0);
            Date dataFinal = UtilValidadorDeDataNoPeriodo.novoDate(UtilValidadorDeDataNoPeriodo.getUltimoDiaDoMes(UtilValidadorDeDataNoPeriodo.getDezembro()), UtilValidadorDeDataNoPeriodo.getDezembro(), anoFinal, 23, 59, 59);
            result = UtilValidadorDeDataNoPeriodo.validar(data, dataInicial, dataFinal);
        }
        return result;
    }

    protected static Date novoDate(int dia, int mes, int ano, int hora, int minuto, int segundo) {
        return UtilValidadorDeDataNoPeriodo.getDataFactory().novoDate(dia, mes, ano, hora, minuto, segundo);
    }

    protected static int getUltimoDiaDoMes(int mes) {
        return UtilData.getUltimoDiaDoMes(mes);
    }

    protected static int getJaneiro() {
        return UtilData.getJaneiro();
    }

    protected static int getDezembro() {
        return UtilData.getDezembro();
    }

    protected static int getPrimeiroDiaDoMesDefault() {
        return UtilData.getPrimeiroDiaDoMesDefault();
    }

    protected static boolean isAnoFinalMaiorQueAnoInicial(int anoFinal, int anoInicial) {
        return UtilValidadorDeNumeroInicialMaiorQueNumeroFinal.validar(anoFinal, anoInicial);
    }
}

