/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.beans;

import br.com.bb.plugins.beans.ToolTipText;
import br.com.bb.plugins.interfaces.infraestrutura.FrameBB;
import br.com.bb.plugins.negocio.infraestrutura.OpcaoLista;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class BBPastas
extends Canvas
implements ItemSelectable,
MouseListener,
ToolTipText {
    private Vector opcoes;
    private int opcaoSelecionada = 0;
    private Font font = new Font("Arial", 0, 12);
    private int tamanhoOpcao;
    private Font fontBold = new Font("Arial", 1, 12);
    private Vector listaListeners;
    private int[] areaItens;
    private int tamanhoMinimo = 20;
    private int chanfra = 5;
    private String toolTipText = null;

    public BBPastas() {
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
    }

    public void add(String opcao) {
        this.add(opcao, opcao);
    }

    public void add(String codigoOpcao, String opcao) {
        OpcaoLista o = new OpcaoLista();
        o.setCodigo(codigoOpcao);
        o.setDescricao(opcao);
        if (this.opcoes == null) {
            this.opcoes = new Vector();
        }
        this.opcoes.addElement(o);
        this.repaint();
    }

    public void addItemListener(ItemListener l) {
        if (this.listaListeners == null) {
            this.listaListeners = new Vector();
        }
        this.listaListeners.addElement(l);
    }

    private void fireItemEvent() {
        if (this.listaListeners != null) {
            ItemEvent ie = new ItemEvent(this, this.opcaoSelecionada, this.opcoes.elementAt(this.opcaoSelecionada), 0);
            int i = 0;
            while (i < this.listaListeners.size()) {
                ((ItemListener)this.listaListeners.elementAt(i)).itemStateChanged(ie);
                ++i;
            }
        }
    }

    public int getChanfra() {
        return this.chanfra;
    }

    public final String getCodigoOpcaoSelecionada() {
        return ((OpcaoLista)this.opcoes.elementAt(this.opcaoSelecionada)).getCodigo();
    }

    public String getDescricaoOpcaoSelecionada() {
        return ((OpcaoLista)this.opcoes.elementAt(this.opcaoSelecionada)).getDescricao();
    }

    public Font getFont() {
        return this.font;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public int getTamanhoMinimo() {
        return this.tamanhoMinimo;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public static void main(String[] args) {
        final FrameBB f = new FrameBB();
        ((Component)f).setSize(800, 550);
        ((Component)f).setVisible(true);
        final BBPastas p = new BBPastas();
        int i = 65;
        while (i <= 75) {
            p.add("" + i, "" + (char)i);
            ++i;
        }
        p.add("0", "A-Z");
        p.add("1", "Filtro");
        p.add("2", "Filtro por Qualquer Coisa");
        p.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                System.out.println(((OpcaoLista)e.getItem()).getCodigo());
                System.out.println(((OpcaoLista)e.getItem()).getDescricao());
                Util.mensagem(f, String.valueOf(p.getCodigoOpcaoSelecionada()) + " - " + p.getDescricaoOpcaoSelecionada());
            }
        });
        p.setSize(100, 20);
        f.add((Component)p, "North");
        ((Component)f).setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int i = 0;
        while (i < this.areaItens.length) {
            if (e.getX() <= this.areaItens[i] && e.getY() > 0 && e.getY() < this.getSize().height) {
                this.opcaoSelecionada = i;
                this.repaint();
                this.fireItemEvent();
                break;
            }
            ++i;
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        if (this.areaItens == null) {
            this.areaItens = new int[this.opcoes.size()];
        }
        int tamanhoTotal = 0;
        int i = 0;
        while (i < this.opcoes.size()) {
            int tamanhoItem = g.getFontMetrics().stringWidth(((OpcaoLista)this.opcoes.elementAt(i)).getDescricao()) + 16;
            if (tamanhoItem < this.tamanhoMinimo) {
                tamanhoItem = 30;
            }
            this.areaItens[i] = tamanhoTotal += tamanhoItem;
            ++i;
        }
        int posicaoAtual = 4;
        int i2 = 0;
        while (i2 < this.opcoes.size()) {
            this.tamanhoOpcao = i2 == 0 ? this.areaItens[0] : this.areaItens[i2] - this.areaItens[i2 - 1];
            g.setColor(Color.black);
            g.drawLine(posicaoAtual + 1, 1 + this.chanfra, posicaoAtual + 1, this.getSize().height);
            if (i2 != this.opcaoSelecionada) {
                g.setColor(Color.white);
            }
            g.drawLine(posicaoAtual + 2, 1 + this.chanfra, posicaoAtual + 2, this.getSize().height);
            g.setColor(Color.black);
            g.drawLine(posicaoAtual + 1 + this.chanfra, 1, posicaoAtual + this.tamanhoOpcao + (i2 == this.opcoes.size() - 1 ? 0 : this.chanfra), 1);
            if (i2 != this.opcaoSelecionada) {
                g.setColor(Color.white);
            }
            g.drawLine(posicaoAtual + 1 + this.chanfra, 2, posicaoAtual + this.tamanhoOpcao + (i2 == this.opcoes.size() - 1 ? 0 : this.chanfra), 2);
            g.setColor(Color.black);
            g.drawArc(posicaoAtual + 1, 1, this.chanfra * 2, this.chanfra * 2, 90, 90);
            if (i2 != this.opcaoSelecionada) {
                g.setColor(Color.white);
            }
            g.drawArc(posicaoAtual + 2, 2, this.chanfra * 2 - 1, this.chanfra * 2 - 1, 90, 90);
            if (i2 != this.opcaoSelecionada) {
                g.setFont(this.font);
            } else {
                g.setFont(this.fontBold);
            }
            int larguraOpcao = g.getFontMetrics().stringWidth(((OpcaoLista)this.opcoes.elementAt(i2)).getDescricao());
            int alturaOpcao = this.getFont().getSize();
            g.setColor(Color.black);
            g.drawString(((OpcaoLista)this.opcoes.elementAt(i2)).getDescricao(), posicaoAtual + (this.tamanhoOpcao - larguraOpcao) / 2 + 3, this.getSize().height / 2 + alturaOpcao / 2);
            posicaoAtual += this.tamanhoOpcao;
            ++i2;
        }
        g.setColor(Color.black);
        g.drawLine(posicaoAtual + this.chanfra + 1, 1 + this.chanfra, posicaoAtual + this.chanfra + 1, this.getSize().height);
        if (this.opcoes.size() - 1 != this.opcaoSelecionada) {
            g.setColor(Color.white);
        }
        g.drawLine(posicaoAtual + this.chanfra, 1 + this.chanfra, posicaoAtual + this.chanfra, this.getSize().height);
        g.setColor(Color.black);
        g.drawArc(posicaoAtual - this.chanfra + 1, 1, this.chanfra * 2, this.chanfra * 2, 0, 90);
        if (this.opcoes.size() - 1 != this.opcaoSelecionada) {
            g.setColor(Color.white);
        }
        g.drawArc(posicaoAtual - this.chanfra + 1, 2, this.chanfra * 2 - 1, this.chanfra * 2 - 1, 0, 90);
    }

    public void removeItemListener(ItemListener l) {
        if (this.listaListeners == null) {
            return;
        }
        this.listaListeners.removeElement(l);
    }

    public void selecionarOpcao(String codigoOpcao) {
        int i = 0;
        while (i < this.opcoes.size()) {
            if (((OpcaoLista)this.opcoes.elementAt(i)).getCodigo().equalsIgnoreCase(codigoOpcao)) {
                this.opcaoSelecionada = i;
                this.repaint();
                break;
            }
            ++i;
        }
    }

    public void setChanfra(int newChanfra) {
        this.chanfra = newChanfra;
    }

    public void setFont(Font newFont) {
        this.font = newFont;
        this.fontBold = new Font(this.font.getName(), 1, this.font.getSize());
    }

    public void setTamanhoMinimo(int newTamanhoMinimo) {
        this.tamanhoMinimo = newTamanhoMinimo;
    }

    public void setToolTipText(String newToolTipText) {
        this.toolTipText = newToolTipText;
    }
}

