/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.beans;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;

public class PanelTextoSombra
extends Canvas {
    private String texto;
    private int sombra = 3;
    private Color corSombra = Color.white;
    private int alinhamento = 0;
    private boolean transparente = false;
    private boolean indPaint = false;

    public PanelTextoSombra() {
        this.initialize();
    }

    public int getAlinhamento() {
        return this.alinhamento;
    }

    public Color getCorSombra() {
        return this.corSombra;
    }

    public int getSombra() {
        return this.sombra;
    }

    public String getTexto() {
        return this.texto;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("PainelTextoSombra");
            this.setSize(426, 37);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isTransparente() {
        return this.transparente;
    }

    public void paint(Graphics g) {
        if (this.indPaint) {
            return;
        }
        this.indPaint = true;
        if (this.isTransparente()) {
            Image tImage = this.getParent().createImage(this.getParent().getSize().width, this.getParent().getSize().height);
            Graphics tGraphic = tImage.getGraphics();
            tGraphic.setClip(new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height));
            this.getParent().paint(tGraphic);
            CropImageFilter cif = new CropImageFilter(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
            FilteredImageSource ip = new FilteredImageSource(tImage.getSource(), cif);
            Image img = this.createImage(ip);
            g.drawImage(img, 0, 0, null);
        }
        int altura = g.getFontMetrics().getMaxAscent();
        int largura = g.getFontMetrics().stringWidth(this.texto);
        while (altura > this.getSize().height - this.sombra || largura > this.getSize().width - this.sombra) {
            g.setFont(new Font(g.getFont().getName(), g.getFont().getStyle(), g.getFont().getSize() - 2));
            altura = g.getFontMetrics().getAscent() + g.getFontMetrics().getDescent();
            largura = g.getFontMetrics().stringWidth(this.texto);
        }
        int posX = 0;
        if (this.getAlinhamento() == 1) {
            posX = (this.getSize().width - largura) / 2;
        } else if (this.getAlinhamento() == 2) {
            posX = this.getSize().width - largura - this.sombra;
        }
        int posY = this.getSize().height - (this.getSize().height - altura) / 2 - this.sombra - g.getFontMetrics().getDescent() + 5;
        g.setColor(this.getCorSombra());
        g.drawString(this.texto, posX + this.sombra, posY + this.sombra);
        g.setColor(this.getForeground());
        g.drawString(this.texto, posX, posY);
        this.indPaint = false;
    }

    public void setAlinhamento(int newAlinhamento) {
        this.alinhamento = newAlinhamento;
    }

    public void setCorSombra(Color newCorSombra) {
        this.corSombra = newCorSombra;
    }

    public void setSombra(int newSombra) {
        this.sombra = newSombra;
    }

    public void setTexto(String newTexto) {
        this.texto = newTexto;
    }

    public void setTransparente(boolean newTransparente) {
        this.transparente = newTransparente;
    }
}

