/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Impressao
extends Panel {
    public static int DIREITO = 0;
    public static int ESQUERDO = 2;
    public static int CENTRO = 1;
    public static int LATERAL = 3;
    private boolean dialog_;
    private PrintJob job_;
    private Dimension area_;
    private Frame frame_;

    public Impressao(Frame f) {
        this.frame_ = f;
    }

    public int alinhar(String nome, int largura, int alinhamento, FontMetrics f) {
        int tam = f.stringWidth(nome);
        if (alinhamento == DIREITO) {
            if (largura > tam) {
                return largura - tam;
            }
        } else if (alinhamento == CENTRO) {
            if (largura > tam) {
                return (largura - tam) / 2;
            }
        } else if (alinhamento == LATERAL && largura > tam + 3) {
            return tam + 3;
        }
        return 0;
    }

    public int cmToPonto(double cm) {
        return (int)(cm / 0.035555555555555556);
    }

    public void finaliza() {
        this.job_.end();
    }

    public Dimension getArea() {
        if (this.area_ == null) {
            this.area_ = new Dimension(620, 835);
        }
        return this.area_;
    }

    public void imprimir() {
        Toolkit t;
        if (this.job_ == null && (t = Toolkit.getDefaultToolkit()) != null) {
            this.job_ = t.getPrintJob(this.frame_, "Impressao", null);
        }
        if (this.job_ != null) {
            this.paint(this.job_.getGraphics());
        }
    }

    public void linhaH(int x0, int y0, int largura, Graphics g) {
        g.drawLine(x0, y0, x0 + largura, y0);
    }

    public void linhaHPontilhada(int x, int y, int largura, Graphics g) {
        String s = "";
        g.setFont(new Font("Arial", 0, 6));
        FontMetrics f = g.getFontMetrics();
        int tam = f.charWidth('.');
        int i = 0;
        while (i <= largura) {
            s = String.valueOf(s) + '.';
            i += tam;
        }
        g.drawString(s, x, y);
    }

    public void linhaV(int x0, int y0, int altura, Graphics g) {
        g.drawLine(x0, y0, x0, y0 + altura);
    }

    public void linhaVPontilhada(int x, int y, int altura, Graphics g) {
        g.setFont(new Font("Arial", 0, 6));
        FontMetrics f = g.getFontMetrics();
        int tam = f.getHeight();
        int i = 0;
        while (i <= altura) {
            g.drawString("i", x, y + i);
            i += tam;
        }
    }

    public void paintImagem(Image img, int x, int y, int largura, int altura, Graphics g) {
        MediaTracker tracker_ = new MediaTracker(this);
        tracker_.addImage(img, 0);
        try {
            tracker_.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if ((tracker_.statusAll(false) & 4) != 0) {
            g.setColor(Color.red);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            return;
        }
        if (tracker_.statusID(0, false) == 8) {
            if (largura == -1 || altura == -1) {
                g.drawImage(img, x, y, this);
            } else {
                g.drawImage(img, x, y, largura, altura, this);
            }
        }
    }

    public void paintImagem(Image img, int x, int y, Graphics g) {
        this.paintImagem(img, x, y, -1, -1, g);
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        int i;
        byte[] buffer = new byte[5120];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((i = in.read(buffer)) != -1) {
            out.write(buffer, 0, i);
        }
        in.close();
        return out.toByteArray();
    }

    public static byte[] readAllBytes(String nomeArquivo) throws IOException {
        return Impressao.readAllBytes(new FileInputStream(nomeArquivo));
    }
}

