/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.impressao;

import br.com.bb.plugins.controle.impressao.JobImpressao;
import br.com.bb.plugins.controle.impressao.Linha;
import br.com.bb.plugins.controle.impressao.Printer;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Font;
import java.awt.Frame;

public class Imprimindo
extends Frame {
    private Printer printer;
    private JobImpressao jobImpressao = null;
    private int cntLinhas = 0;
    private int cntPaginas = 1;
    private boolean isFim = false;
    private int linhasTratadas = 0;
    private int limiteLinhas = 65;
    private int largura = 80;

    public Imprimindo(JobImpressao ji, int linhasPagina) throws Throwable {
        if (linhasPagina > 0) {
            this.limiteLinhas = linhasPagina;
        }
        this.jobImpressao = ji;
        this.printer = new Printer(this);
        this.linhasTratadas = 0;
        this.loadStrings();
        if (!this.printer.newPage()) {
            this.dispose();
            this.printer.endJob();
            throw new Throwable("Impress\u00e3o cancelada pelo usu\u00e1rio!");
        }
    }

    public Imprimindo(JobImpressao ji, int linhasPagina, int largura) throws Throwable {
        this.setLargura(largura);
        if (linhasPagina > 0) {
            this.limiteLinhas = linhasPagina;
        }
        this.jobImpressao = ji;
        this.printer = new Printer(this);
        this.linhasTratadas = 0;
        this.loadStrings();
        if (!this.printer.newPage()) {
            this.dispose();
            this.printer.endJob();
            throw new Throwable("Impress\u00e3o cancelada pelo usu\u00e1rio!");
        }
    }

    public int getLargura() {
        return this.largura;
    }

    public void imprimir() throws Throwable {
        if (!this.isFim) {
            while (!this.isFim) {
                this.loadStrings();
                if (this.printer.newPage()) continue;
                this.printer.endJob();
                this.dispose();
                ControleAplicacao.getRoteadorPlugins().exibirMensagemErro(new Throwable("Ocorreu um erro durante a impress\u00e3o!"));
                return;
            }
        }
        this.printer.endJob();
        if (this.jobImpressao.isMensagemImpressaoConcluida()) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagem("Impress\u00e3o conclu\u00edda.");
        }
        this.dispose();
    }

    private void imprimirRodape() {
        while (this.cntLinhas < this.limiteLinhas - 2) {
            this.printer.println("");
            ++this.cntLinhas;
        }
        try {
            this.printer.setFont(new Font("monospaced", 1, 11));
            this.printer.println("     " + Util.padR("", this.getLargura(), "_"));
            this.printer.println("     " + Util.padR(String.valueOf(this.cntPaginas), this.getLargura()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadCabec() {
        this.cntLinhas = 0;
        this.printer.println("");
        this.printer.println("");
        int i = 0;
        while (i < this.jobImpressao.getVLinhasCabecalho().size()) {
            this.printer.setFont(((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getFonte());
            if (((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTab() > 0) {
                this.printer.tab(((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTab());
            }
            if (((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).isSalto()) {
                this.printer.println(((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTexto());
                ++this.cntLinhas;
            } else {
                this.printer.print(((Linha)this.jobImpressao.getVLinhasCabecalho().elementAt(i)).getTexto());
            }
            ++i;
        }
    }

    public void loadStrings() throws Throwable {
        this.cntLinhas = 0;
        int inicioPagina = this.linhasTratadas;
        if (this.jobImpressao.isCabecalhoPadrao() && this.jobImpressao.getVLinhasCabecalho() != null && this.jobImpressao.getVLinhasCabecalho().size() > 0) {
            this.loadCabec();
        }
        int i = this.linhasTratadas;
        while (i < this.jobImpressao.getVLinhas().size()) {
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).isNovaPagina() && i != inicioPagina) {
                if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getNumeroPaginaAtual() != 0) {
                    this.cntPaginas = ((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getNumeroPaginaAtual();
                }
                this.imprimirRodape();
                ++this.cntPaginas;
                return;
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getFonte() != null) {
                this.printer.setFont(((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getFonte());
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTab() > 0) {
                this.printer.tab(((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTab());
            }
            if (((Linha)this.jobImpressao.getVLinhas().elementAt(i)).isSalto()) {
                this.printer.println(((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTexto());
                ++this.cntLinhas;
            } else {
                this.printer.print(((Linha)this.jobImpressao.getVLinhas().elementAt(i)).getTexto());
            }
            ++this.linhasTratadas;
            if (this.cntLinhas > this.limiteLinhas - 2) {
                this.imprimirRodape();
                ++this.cntPaginas;
                return;
            }
            ++i;
        }
        this.imprimirRodape();
        this.isFim = true;
    }

    public void setLargura(int newLargura) {
        this.largura = newLargura;
    }
}

