/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.infraestrutura.ControleInstalacao;
import br.com.bb.plugins.controle.infraestrutura.RoteadorPlugins;
import br.com.bb.plugins.interfaces.infraestrutura.FramePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Convenente;
import br.com.bb.plugins.negocio.comum.Plugin;
import br.com.bb.plugins.negocio.infraestrutura.Usuario;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.ConvenenteBD;
import br.com.bb.plugins.persistencia.infraestrutura.InstalacaoBD;
import br.com.bb.plugins.utilitarios.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class ControleAplicacao {
    private static Plugin plugin;
    private static FramePlugin framePlugin;
    private static RoteadorPlugins roteadorPlugins;
    private static Convenente convenente;
    private static Usuario usuario;
    private static Date dataAtual;
    private static Hashtable configuracao;

    static {
        configuracao = null;
    }

    private ControleAplicacao() {
    }

    public static void abrirOffice() {
        try {
            Process pc = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler https://aapj.bb.com.br/aapj/liemp.bb?codigoTransacao=IED1");
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            System.out.println();
        }
    }

    public static void configurarOffice() {
        if (ControleAplicacao.getConfiguracao().size() == 0) {
            File f1 = new File(String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "officeIE" + System.getProperty("file.separator") + "index.html");
            if (f1.exists()) {
                ControleAplicacao.setarParametroConfiguracao("office", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "officeIE" + System.getProperty("file.separator"));
                ControleAplicacao.setarParametroConfiguracao("remessa", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "bbtransf" + System.getProperty("file.separator") + "remessa" + System.getProperty("file.separator"));
                ControleAplicacao.setarParametroConfiguracao("retorno", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "bbtransf" + System.getProperty("file.separator") + "retorno" + System.getProperty("file.separator"));
                return;
            }
            File f2 = new File(String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "officeNE" + System.getProperty("file.separator") + "index.html");
            if (f2.exists()) {
                ControleAplicacao.setarParametroConfiguracao("office", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "officeNE" + System.getProperty("file.separator"));
                ControleAplicacao.setarParametroConfiguracao("remessa", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "bbtransf" + System.getProperty("file.separator") + "remessa" + System.getProperty("file.separator"));
                ControleAplicacao.setarParametroConfiguracao("retorno", String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "bbtransf" + System.getProperty("file.separator") + "retorno" + System.getProperty("file.separator"));
                return;
            }
        }
        try {
            IInterfacePluginCadastro cfgOffice = (IInterfacePluginCadastro)ControleAplicacao.getRoteadorPlugins().abrirInterface("ConfiguracaoOffice", null);
            cfgOffice.alterar(ControleAplicacao.obterConfiguracao());
            cfgOffice.exibir();
            while (ControleAplicacao.obterParametroConfiguracao("office") == null || ControleAplicacao.obterParametroConfiguracao("remessa") == null || ControleAplicacao.obterParametroConfiguracao("retorno") == null) {
                cfgOffice.alterar(ControleAplicacao.obterConfiguracao());
                cfgOffice.exibir();
            }
        }
        catch (Throwable e) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagemErro(e);
        }
    }

    public static void encerrar() {
        try {
            ConexaoBancoDados.desconectar();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static Hashtable getConfiguracao() {
        if (configuracao == null) {
            configuracao = ControleAplicacao.obterConfiguracao();
        }
        return configuracao;
    }

    public static String[] getConfiguracaoLeitora() {
        String linha = null;
        int i = 0;
        String[] linhas = new String[10];
        File nomeArquivoCfg = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "leitora." + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase());
        if (nomeArquivoCfg.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(nomeArquivoCfg));
                linha = in.readLine();
                while (linha != null && i < 10) {
                    if (linha.trim().length() > 0) {
                        linhas[i] = linha.trim();
                    }
                    linha = in.readLine();
                    ++i;
                }
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
        return linhas;
    }

    public static Convenente getConvenente() {
        return convenente;
    }

    public static Date getDataAtual() {
        ControleAplicacao.setDataAtual(new GregorianCalendar().getTime());
        return dataAtual;
    }

    public static String getDiretorioArquivos() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("classes");
        String dirDados = "";
        if (x > 0) {
            dirDados = String.valueOf(dirClasses.substring(0, x)) + System.getProperty("file.separator") + "arquivos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase();
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirDados = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "arquivos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase();
        }
        File f = new File(dirDados);
        f.mkdir();
        return String.valueOf(dirDados) + System.getProperty("file.separator");
    }

    public static String getDiretorioBBTransf() {
        if (ControleAplicacao.obterParametroConfiguracao("office") == null) {
            ControleAplicacao.configurarOffice();
        }
        return String.valueOf(ControleAplicacao.obterParametroConfiguracao("office")) + ".." + System.getProperty("file.separator") + "bbtransf" + System.getProperty("file.separator");
    }

    public static String getDiretorioClasses() {
        String diretorioClasses = null;
        File xmlInfra = new File(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "xmlinfra.bbz");
        if (xmlInfra.exists()) {
            diretorioClasses = System.getProperty("user.dir");
        } else {
            diretorioClasses = String.valueOf(System.getProperty("file.separator")) + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "classes";
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                diretorioClasses = String.valueOf(System.getProperty("user.dir").substring(0, 2)) + diretorioClasses;
            }
        }
        return String.valueOf(diretorioClasses) + System.getProperty("file.separator");
    }

    public static String getDiretorioCompactador() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("classes");
        String dirImportados = "";
        if (x > 0) {
            dirImportados = String.valueOf(dirClasses.substring(0, x)) + System.getProperty("file.separator") + "BBCompactadorBD";
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirImportados = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "BBCompactadorBD";
        }
        File f = new File(dirImportados);
        f.mkdir();
        return String.valueOf(dirImportados) + System.getProperty("file.separator");
    }

    public static String getDiretorioContrato() {
        String dir = String.valueOf(ControleAplicacao.getDiretorioBBTransf()) + "contrato";
        File f = new File(dir);
        f.mkdir();
        return String.valueOf(dir) + System.getProperty("file.separator");
    }

    public static String getDiretorioDados() {
        String dirDados = InstalacaoBD.getInstalacaoBD().obterCaminhoBD();
        int x = dirDados.lastIndexOf(System.getProperty("file.separator"));
        return dirDados.substring(0, ++x);
    }

    public static String getDiretorioDocumentos() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("classes");
        String dirDados = "";
        if (x > 0) {
            dirDados = String.valueOf(dirClasses.substring(0, x)) + System.getProperty("file.separator") + "documentos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase();
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirDados = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "documentos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase();
        }
        File f = new File(dirDados);
        f.mkdir();
        return String.valueOf(dirDados) + System.getProperty("file.separator");
    }

    public static String getDiretorioImportados() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("classes");
        String dirImportados = "";
        if (x > 0) {
            dirImportados = String.valueOf(dirClasses.substring(0, x)) + System.getProperty("file.separator") + "arquivos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase() + System.getProperty("file.separator") + "importados";
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirImportados = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "arquivos" + System.getProperty("file.separator") + ControleAplicacao.getPlugin().getCodigoPlugin().toLowerCase() + System.getProperty("file.separator") + "importados";
        }
        File f = new File(dirImportados);
        f.mkdir();
        return String.valueOf(dirImportados) + System.getProperty("file.separator");
    }

    public static String getDiretorioOffice() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("aplicativos");
        String dirBBTransf = "";
        if (x > 0) {
            dirBBTransf = String.valueOf(dirClasses.substring(0, x)) + System.getProperty("file.separator") + "bbtransf";
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirBBTransf = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "bbtransf";
        }
        return String.valueOf(dirBBTransf) + System.getProperty("file.separator");
    }

    public static String getDiretorioRemessa() {
        String dirRemessa;
        File f;
        if (ControleAplicacao.obterParametroConfiguracao("remessa") == null) {
            ControleAplicacao.configurarOffice();
        }
        if ((f = new File(dirRemessa = ControleAplicacao.obterParametroConfiguracao("remessa"))).isDirectory()) {
            return dirRemessa;
        }
        ControleAplicacao.configurarOffice();
        return ControleAplicacao.obterParametroConfiguracao("remessa");
    }

    public static String getDiretorioRetorno() {
        String dirRetorno;
        File f;
        if (ControleAplicacao.obterParametroConfiguracao("retorno") == null) {
            ControleAplicacao.configurarOffice();
        }
        if ((f = new File(dirRetorno = ControleAplicacao.obterParametroConfiguracao("retorno"))).isDirectory()) {
            return dirRetorno;
        }
        ControleAplicacao.configurarOffice();
        return ControleAplicacao.obterParametroConfiguracao("retorno");
    }

    public static String getDiretorioTemp() {
        String dirClasses = System.getProperty("user.dir").toLowerCase();
        String dir = "";
        int x = dirClasses.indexOf("classes");
        String dirDados = "";
        if (x > 0) {
            dirDados = String.valueOf(dirClasses.substring(0, x)) + "temp";
        } else {
            String so = System.getProperty("os.name");
            if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win")) {
                dir = System.getProperty("user.dir").substring(0, 2);
            }
            dirDados = String.valueOf(dir) + System.getProperty("file.separator") + "bancobrasil" + System.getProperty("file.separator") + "aplicativos" + System.getProperty("file.separator") + "temp";
        }
        File f = new File(dirDados);
        f.mkdir();
        return String.valueOf(dirDados) + System.getProperty("file.separator");
    }

    public static String getDiretorioWindows() {
        File nomeArquivoDir;
        String so = System.getProperty("os.name");
        String dir = null;
        if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win") && (nomeArquivoDir = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "dirinst.bbi")).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(nomeArquivoDir));
                dir = in.readLine();
                dir = in.readLine();
                if (dir != null && dir.trim().length() > 0) {
                    if (dir.substring(0, 3).equalsIgnoreCase("SET")) {
                        dir = dir.substring(4);
                    }
                    dir = dir.trim();
                }
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
        return String.valueOf(dir) + System.getProperty("file.separator");
    }

    public static String getDiretorioWindowsSystem() {
        File nomeArquivoDir;
        String so = System.getProperty("os.name");
        String dir = null;
        if (so.length() > 2 && so.substring(0, 3).equalsIgnoreCase("win") && (nomeArquivoDir = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "dirinst.bbi")).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(nomeArquivoDir));
                dir = in.readLine();
                dir = in.readLine();
                dir = in.readLine();
                if (dir != null && dir.trim().length() > 0) {
                    if (dir.substring(0, 3).equalsIgnoreCase("SET")) {
                        dir = dir.substring(4);
                    }
                    dir = dir.trim();
                }
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
        return String.valueOf(dir) + System.getProperty("file.separator");
    }

    public static FramePlugin getFramePlugin() {
        return framePlugin;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static RoteadorPlugins getRoteadorPlugins() {
        return roteadorPlugins;
    }

    public static Usuario getUsuario() {
        return usuario;
    }

    public static boolean isDemonstracao() {
        try {
            return ControleInstalacao.getInstance().obterStatus().equalsIgnoreCase("D");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Hashtable obterConfiguracao() {
        File f = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "cfginfra.bbi");
        Vector arqConfiguracao = new Vector();
        Hashtable<String, String> tabelaConfiguracao = new Hashtable<String, String>();
        try {
            arqConfiguracao = Util.lerArquivo(f);
        }
        catch (Throwable t) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagemErro(t);
        }
        if (arqConfiguracao != null) {
            int i = 0;
            while (i < arqConfiguracao.size()) {
                String linha = (String)arqConfiguracao.elementAt(i);
                tabelaConfiguracao.put(linha.substring(0, linha.indexOf("=")), linha.substring(linha.indexOf("=") + 1));
                ++i;
            }
        }
        return tabelaConfiguracao;
    }

    public static Vector obterListaConvenentes() throws Exception {
        return ConvenenteBD.getConvenenteBD().obterLista();
    }

    public static String obterParametroConfiguracao(String parm) {
        if (ControleAplicacao.getConfiguracao() == null) {
            return null;
        }
        if (parm.substring(0, parm.length() - 3).equalsIgnoreCase("Leitora_")) {
            return (String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase());
        }
        return (String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase()) == null || ((String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase())).substring(((String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase())).length() - 1, ((String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase())).length()).equalsIgnoreCase(System.getProperty("file.separator")) ? (String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase()) : String.valueOf((String)ControleAplicacao.getConfiguracao().get(parm.toLowerCase())) + System.getProperty("file.separator");
    }

    private static void salvarConfiguracao(Hashtable configuracao) {
        Vector<String> arq = new Vector<String>();
        Enumeration chaves = configuracao.keys();
        Enumeration codigos = configuracao.elements();
        while (chaves.hasMoreElements()) {
            arq.addElement(String.valueOf(((String)chaves.nextElement()).toLowerCase()) + "=" + (String)codigos.nextElement());
        }
        File f = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "cfginfra.bbi");
        if (f.exists() && f.delete()) {
            f = new File(String.valueOf(ControleAplicacao.getDiretorioClasses()) + "cfginfra.bbi");
        }
        try {
            Util.gravarArquivo(f, arq);
        }
        catch (Throwable t) {
            ControleAplicacao.getRoteadorPlugins().exibirMensagemErro(t);
        }
    }

    public static void setarParametroConfiguracao(String parm, String conteudo) {
        ControleAplicacao.getConfiguracao().put(parm.toLowerCase(), conteudo);
        ControleAplicacao.salvarConfiguracao(ControleAplicacao.getConfiguracao());
    }

    public static void setConfiguracao(Hashtable newConfiguracao) {
        configuracao = newConfiguracao;
    }

    public static void setConvenente(Convenente newConvenente) {
        convenente = newConvenente;
        ControleAplicacao.getFramePlugin().setConvenenteAtual(newConvenente);
    }

    public static void setDataAtual(Date newDataAtual) {
        dataAtual = newDataAtual;
    }

    public static void setFramePlugin(FramePlugin newFramePlugin) {
        framePlugin = newFramePlugin;
    }

    public static void setPlugin(Plugin newPlugin) {
        plugin = newPlugin;
    }

    public static void setRoteadorPlugins(RoteadorPlugins newRoteadorPlugins) {
        roteadorPlugins = newRoteadorPlugins;
    }

    public static void setUsuario(Usuario newUsuario) {
        usuario = newUsuario;
    }

    public static void substituirConvenente() {
        ControleAplicacao.getFramePlugin().fecharTodasInterfaces();
        IInterfacePlugin ipc = ControleAplicacao.getRoteadorPlugins().abrirInterface("AlteraConvenente", null);
        ipc.exibir();
    }
}

