/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Agencia;
import br.com.bb.plugins.negocio.comum.Banco;
import br.com.bb.plugins.negocio.comum.ContaCorrente;
import br.com.bb.plugins.negocio.comum.Pessoa;
import br.com.bb.plugins.persistencia.comum.AgenciaBD;
import br.com.bb.plugins.persistencia.comum.BancoBD;
import br.com.bb.plugins.persistencia.comum.ContaCorrenteBD;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.sql.SQLException;
import java.util.Vector;

public class ControleContaCorrente
extends Roteador
implements GerenciadorListasListener {
    private static ControleContaCorrente controleContaCorrente;
    private IInterfaceGerenciadorListas interfaceGerenciadorListaAgencia;
    private IInterfaceGerenciadorListas interfaceGerenciadorListaBanco;
    private String indicadorAcao;
    private Banco banco;
    private Agencia agencia;

    private ControleContaCorrente() {
    }

    public void abrirManutencaoAgencia(Agencia parmAgencia) throws Throwable {
        this.agencia = parmAgencia;
        this.getInterfaceGerenciadorListaAgencia().listar(AgenciaBD.getAgenciaBD(), AgenciaBD.getAgenciaBD().abrirLista());
        this.getInterfaceGerenciadorListaAgencia().setTitulo("Lista de ag\u00eancias");
        this.getInterfaceGerenciadorListaAgencia().exibir();
    }

    public void abrirManutencaoBanco(Banco parmBanco) throws Throwable {
        this.banco = parmBanco;
        this.getInterfaceGerenciadorListaBanco().listar(BancoBD.getBancoBD().obterLista());
        this.getInterfaceGerenciadorListaBanco().setTitulo("Lista de bancos");
        this.getInterfaceGerenciadorListaBanco().exibir();
    }

    public void botaoAlterar(GerenciadorListasEvent event) {
        try {
            Banco banco = new Banco();
            banco.setCodigo((String)event.getLinhas()[0][0]);
            this.setIndicadorAcao("A");
            if (event.getSource() == this.interfaceGerenciadorListaAgencia) {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("AgenciaCadastro", null);
                Agencia agencia = new Agencia();
                agencia.setBanco(banco);
                agencia.setCodigoPrefixoAgencia((String)event.getLinhas()[0][1]);
                agencia.setTextoDescricao((String)event.getLinhas()[0][2]);
                AgenciaBD.getAgenciaBD().obter(agencia);
                interfacePluginCadastro.alterar(agencia);
                interfacePluginCadastro.exibir();
            } else {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("BancoCadastro", null);
                BancoBD.getBancoBD().obter(banco);
                interfacePluginCadastro.alterar(banco);
                interfacePluginCadastro.exibir();
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoCancelar(GerenciadorListasEvent event) {
    }

    public void botaoDesmarcar(GerenciadorListasEvent event) {
    }

    public void botaoDetalhar(GerenciadorListasEvent event) {
        try {
            Banco banco = new Banco();
            banco.setCodigo((String)event.getLinhas()[0][0]);
            this.setIndicadorAcao("D");
            if (event.getSource() == this.interfaceGerenciadorListaAgencia) {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("AgenciaCadastro", null);
                Agencia agencia = new Agencia();
                agencia.setBanco(banco);
                agencia.setCodigoPrefixoAgencia((String)event.getLinhas()[0][1]);
                agencia.setTextoDescricao((String)event.getLinhas()[0][2]);
                AgenciaBD.getAgenciaBD().obter(agencia);
                interfacePluginCadastro.detalhar(agencia);
                interfacePluginCadastro.exibir();
            } else {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("BancoCadastro", null);
                BancoBD.getBancoBD().obter(banco);
                interfacePluginCadastro.detalhar(banco);
                interfacePluginCadastro.exibir();
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoExcluir(GerenciadorListasEvent event) {
        try {
            Banco banco = new Banco();
            banco.setCodigo((String)event.getLinhas()[0][0]);
            this.setIndicadorAcao("E");
            if (event.getSource() == this.interfaceGerenciadorListaAgencia) {
                if (event.getLinhas().length > 1) {
                    this.exibirMensagem("Selecione apenas uma ag\u00eancia para exclus\u00e3o!");
                    return;
                }
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("AgenciaCadastro", null);
                Agencia agencia = new Agencia();
                agencia.setBanco(banco);
                agencia.setCodigoPrefixoAgencia((String)event.getLinhas()[0][1]);
                agencia.setTextoDescricao((String)event.getLinhas()[0][2]);
                AgenciaBD.getAgenciaBD().obter(agencia);
                interfacePluginCadastro.excluir(agencia);
                interfacePluginCadastro.exibir();
            } else {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("BancoCadastro", null);
                BancoBD.getBancoBD().obter(banco);
                interfacePluginCadastro.excluir(banco);
                interfacePluginCadastro.exibir();
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoFiltro(GerenciadorListasEvent event) {
        this.exibirMensagem("Op\u00e7\u00e3o n\u00e3o dispon\u00edvel para a manuten\u00e7\u00e3o de Banco / Ag\u00eancia");
    }

    public void botaoImprimir(GerenciadorListasEvent event, MultiColumnListbox multicolumn) {
        ControleImpressao.getControle().setLinhasPorPagina(68);
        String titulo = event.getSource() == this.interfaceGerenciadorListaAgencia ? "Rela\u00e7\u00e3o de ag\u00eancias" : "Rela\u00e7\u00e3o de bancos";
        ControleImpressao.getControle().setTituloVisualizacao(titulo);
        ControleImpressao.getControle().imprimir(multicolumn, titulo);
    }

    public void botaoIncluir(GerenciadorListasEvent event) {
        try {
            this.setIndicadorAcao("I");
            if (event.getSource() == this.interfaceGerenciadorListaAgencia) {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("AgenciaCadastro", null);
                if (this.agencia == null) {
                    this.agencia = new Agencia();
                }
                interfacePluginCadastro.incluir(this.agencia);
                interfacePluginCadastro.exibir();
            } else {
                IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("BancoCadastro", null);
                if (this.banco == null) {
                    this.banco = new Banco();
                }
                interfacePluginCadastro.incluir(this.banco);
                interfacePluginCadastro.exibir();
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoMarcar(GerenciadorListasEvent event) {
    }

    public void botaoOK(GerenciadorListasEvent event) {
    }

    public void botaoSair(GerenciadorListasEvent event) {
    }

    public void excluirAgencia(Agencia agencia) throws Throwable {
        if (agencia.getCodigoPessoaBanco() == null || agencia.getCodigoPessoaBanco().trim().length() == 0) {
            if (agencia.getBanco().getCodigo() == null || agencia.getBanco().getCodigo().trim().length() == 0) {
                throw new Throwable("N\u00e3o foi poss\u00edvel excluir ag\u00eancia. C\u00f3digo do banco vazio.");
            }
            BancoBD.getBancoBD().obter(agencia.getBanco());
        }
        ContaCorrente cc = new ContaCorrente();
        cc.setCodigoBancoRel(agencia.getBanco().getCodigo());
        cc.setcodigoPrefixoAgenciaRel(agencia.getCodigoPrefixoAgencia());
        Vector vCC = ContaCorrenteBD.getContaCorrenteBD().obterLista(cc);
        if (vCC != null && vCC.size() != 0) {
            throw new Throwable("N\u00e3o foi poss\u00edvel excluir ag\u00eancia. Existem contas correntes vinculadas \u00e0 mesma.");
        }
        AgenciaBD.getAgenciaBD().remover(agencia);
        this.getInterfaceGerenciadorListaAgencia().excluido(agencia);
    }

    public void excluirBanco(Banco banco) throws Throwable {
        if (banco.getCodigo() == null || banco.getCodigo().trim().length() == 0) {
            throw new Throwable("N\u00e3o foi poss\u00edvel excluir banco. C\u00f3digo vazio.");
        }
        BancoBD.getBancoBD().obter(banco);
        Vector vAgencia = AgenciaBD.getAgenciaBD().obterLista(banco);
        if (vAgencia != null && vAgencia.size() != 0) {
            throw new Throwable("N\u00e3o foi poss\u00edvel excluir banco. Existem ag\u00eancias vinculadas ao mesmo.");
        }
        BancoBD.getBancoBD().remover(banco);
        this.getInterfaceGerenciadorListaBanco().excluido(banco);
    }

    public void excluirContaCorrente(ContaCorrente contaCorrente) throws SQLException {
        ContaCorrenteBD.getContaCorrenteBD().remover(contaCorrente);
    }

    public static ControleContaCorrente getControleContaCorrente() {
        if (controleContaCorrente == null) {
            controleContaCorrente = new ControleContaCorrente();
        }
        return controleContaCorrente;
    }

    public String getIndicadorAcao() {
        if (this.indicadorAcao == null) {
            this.indicadorAcao = new String();
        }
        return this.indicadorAcao;
    }

    public IInterfaceGerenciadorListas getInterfaceGerenciadorListaAgencia() {
        if (this.interfaceGerenciadorListaAgencia == null) {
            this.interfaceGerenciadorListaAgencia = (IInterfaceGerenciadorListas)this.abrirInterfaceComoDialog("AgenciaManutencao", null);
            this.interfaceGerenciadorListaAgencia.addGerenciadorListasListener(this);
            this.interfaceGerenciadorListaAgencia.addColuna("C\u00f3digo do Banco", 20, 1, true, true);
            this.interfaceGerenciadorListaAgencia.addColuna("C\u00f3digo da Ag\u00eancia", 30, 1, true, true);
            this.interfaceGerenciadorListaAgencia.addColuna("Descri\u00e7\u00e3o da Ag\u00eancia", 60, true, true);
            this.interfaceGerenciadorListaAgencia.setTituloRelatorio("Lista de Ag\u00eancias");
            this.interfaceGerenciadorListaAgencia.habilitarMultiplaSelecao(false);
            this.interfaceGerenciadorListaAgencia.setLayout(4);
        }
        return this.interfaceGerenciadorListaAgencia;
    }

    public IInterfaceGerenciadorListas getInterfaceGerenciadorListaBanco() {
        if (this.interfaceGerenciadorListaBanco == null) {
            this.interfaceGerenciadorListaBanco = (IInterfaceGerenciadorListas)this.abrirInterfaceComoDialog("BancoManutencao", null);
            this.interfaceGerenciadorListaBanco.addGerenciadorListasListener(this);
            this.interfaceGerenciadorListaBanco.addColuna("C\u00f3digo do Banco", 30, true, true);
            this.interfaceGerenciadorListaBanco.addColuna("Descri\u00e7\u00e3o do Banco", 70, 0, true, true);
            this.interfaceGerenciadorListaBanco.setTituloRelatorio("Lista de bancos");
            this.interfaceGerenciadorListaBanco.habilitarMultiplaSelecao(false);
            this.interfaceGerenciadorListaBanco.setLayout(4);
        }
        return this.interfaceGerenciadorListaBanco;
    }

    public boolean isAgenciaExiste(Agencia agencia) throws Throwable {
        if (agencia.getCodigoPessoaBanco() == null || agencia.getCodigoPessoaBanco().trim().length() == 0) {
            BancoBD.getBancoBD().obter(agencia.getBanco());
        }
        return AgenciaBD.getAgenciaBD().localizado(agencia);
    }

    public boolean isBancoExiste(Banco banco) throws Throwable {
        return BancoBD.getBancoBD().localizado(banco);
    }

    public boolean isContaExiste(ContaCorrente contaCorrente) throws Throwable {
        return ContaCorrenteBD.getContaCorrenteBD().localizado(contaCorrente);
    }

    public boolean localizarContaCorrente(ContaCorrente contaCorrente) throws SQLException {
        return ContaCorrenteBD.getContaCorrenteBD().localizado(contaCorrente);
    }

    public void obterAgencia(Agencia agencia) throws Throwable {
        if (agencia.getCodigoPessoaBanco() == null || agencia.getCodigoPessoaBanco().trim().length() == 0) {
            BancoBD.getBancoBD().obter(agencia.getBanco());
        }
        AgenciaBD.getAgenciaBD().obter(agencia);
    }

    public Vector obterAgenciasPessoaBanco(ContaCorrente conta) throws Throwable {
        return AgenciaBD.getAgenciaBD().obterLista(conta);
    }

    public Vector obterAgenciasPessoaBancoContasAtivas(ContaCorrente conta) throws Throwable {
        return AgenciaBD.getAgenciaBD().obterListaAtivas(conta);
    }

    public void obterBanco(Banco banco) throws SQLException {
        BancoBD.getBancoBD().obter(banco);
    }

    public Vector obterBancosPessoa(Pessoa pessoa) throws Throwable {
        return BancoBD.getBancoBD().obterLista(pessoa);
    }

    public void obterContaCorrente(ContaCorrente contaCorrente) throws SQLException {
        ContaCorrenteBD.getContaCorrenteBD().obter(contaCorrente);
    }

    public Vector obterListaAgencia(Banco banco) throws SQLException {
        if (banco.getCodigoPessoa() == null || banco.getCodigoPessoa().trim().length() == 0) {
            BancoBD.getBancoBD().obter(banco);
        }
        return AgenciaBD.getAgenciaBD().obterLista(banco);
    }

    public Vector obterListaAgenciaBB() throws SQLException {
        return AgenciaBD.getAgenciaBD().obterListaBB();
    }

    public Vector obterListaBanco() throws SQLException {
        return BancoBD.getBancoBD().obterLista();
    }

    public Vector obterListaContaCorrente(ContaCorrente contaCorrente) throws SQLException {
        return ContaCorrenteBD.getContaCorrenteBD().obterLista(contaCorrente);
    }

    public void salvarAgencia(Agencia agencia) throws Throwable {
        if (agencia.getCodigoPessoaBanco() == null || agencia.getCodigoPessoaBanco().trim().length() == 0) {
            if (agencia.getBanco().getCodigo() == null || agencia.getBanco().getCodigo().trim().length() == 0) {
                throw new Throwable("N\u00e3o foi poss\u00edvel salvar ag\u00eancia. C\u00f3digo do banco vazio.");
            }
            BancoBD.getBancoBD().obter(agencia.getBanco());
        }
        AgenciaBD.getAgenciaBD().salvar(agencia);
    }

    public void salvarBanco(Banco banco) throws Throwable {
        if (banco.getCodigo() == null || banco.getCodigo().trim().length() == 0) {
            throw new Throwable("N\u00e3o foi poss\u00edvel salvar banco. C\u00f3digo do banco vazio.");
        }
        BancoBD.getBancoBD().salvar(banco);
    }

    public void salvarContaCorrente(ContaCorrente contaCorrente) throws Throwable {
        ContaCorrenteBD.getContaCorrenteBD().salvar(contaCorrente);
    }

    public void setIndicadorAcao(String newIndicadorAcao) {
        this.indicadorAcao = newIndicadorAcao;
    }

    public void setInterfaceGerenciadorListaAgencia(IInterfaceGerenciadorListas newInterfaceGerenciadorListaAgencia) {
        this.interfaceGerenciadorListaAgencia = newInterfaceGerenciadorListaAgencia;
    }

    public void setInterfaceGerenciadorListaBanco(IInterfaceGerenciadorListas newInterfaceGerenciadorListaBanco) {
        this.interfaceGerenciadorListaBanco = newInterfaceGerenciadorListaBanco;
    }
}

