/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.impressao.Linha;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.IInterfaceImportacao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.CampoLeiaute;
import br.com.bb.plugins.negocio.infraestrutura.Leiaute;
import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.persistencia.infraestrutura.ArquivoRemessaBD;
import br.com.bb.plugins.persistencia.infraestrutura.LeiauteBD;
import br.com.bb.plugins.persistencia.infraestrutura.TipoLeiauteBD;
import br.com.bb.plugins.utilitarios.Util;
import java.awt.Font;
import java.io.File;
import java.sql.SQLException;
import java.util.Vector;

public class ControleImportacao
extends Roteador {
    private static ControleImportacao controleImportacao = null;
    private IInterfaceImportacao interfaceImportacao;

    private ControleImportacao() {
    }

    public void abrirAlteracaoLeiaute(Leiaute leiaute) {
        try {
            LeiauteBD.getLeiauteBD().obter(leiaute);
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DadosCadastramentoLeiaute", null);
            interfacePluginCadastro.alterar(leiaute);
            interfacePluginCadastro.exibir();
        }
        catch (SQLException e) {
            this.exibirMensagemErro(e);
        }
    }

    public void abrirCadastramentoLeiaute(Leiaute leiaute) {
        try {
            LeiauteBD.getLeiauteBD().obterModelo(leiaute);
            leiaute.setNumeroLeiaute(0L);
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DadosCadastramentoLeiaute", null);
            interfacePluginCadastro.alterar(leiaute);
            interfacePluginCadastro.exibir();
        }
        catch (SQLException e) {
            this.exibirMensagemErro(e);
        }
    }

    public void abrirImportacaoDadosExternos(IInterfaceImportacao meuObjeto) {
        this.interfaceImportacao = meuObjeto;
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DadosImportacaoExterno", null);
        interfacePluginCadastro.exibir();
    }

    public void alterarCampo(CampoLeiaute campoLeiaute) {
        IInterfacePluginCadastro dialog = (IInterfacePluginCadastro)this.abrirInterface("DadosAlteracaoCampoLeiaute", null);
        dialog.alterar(campoLeiaute);
        dialog.exibir();
    }

    public void excluir(Leiaute leiaute) throws SQLException {
        LeiauteBD.getLeiauteBD().remover(leiaute);
    }

    public static ControleImportacao getControleImportacao() {
        if (controleImportacao == null) {
            controleImportacao = new ControleImportacao();
        }
        return controleImportacao;
    }

    private Linha getNovaLinha() {
        Linha linha = new Linha();
        linha.setTab(10);
        linha.setTexto(" ");
        linha.setFonte(new Font("monospaced", 0, 10));
        linha.setSalto(true);
        return linha;
    }

    private Linha getTraco() {
        Linha linha = this.getNovaLinha();
        linha.setFonte(new Font("monospaced", 0, 12));
        linha.setTexto("_________________________________________________________________________");
        linha.setTab(8);
        return linha;
    }

    public void importar(Leiaute leiaute) {
        ArquivoRemessa ar = new ArquivoRemessa();
        IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
        try {
            ar = ArquivoRemessaBD.obterArquivoImportacao(leiaute);
            this.interfaceImportacao.iniciarImportacao();
            File arq = new File(leiaute.getArquivoOrigem());
            if (!arq.isFile()) {
                throw new Throwable("Arquivo de origem n\u00e3o existe. Verifique!");
            }
            int tamanhoBarra = Integer.parseInt(Long.toString(arq.length() / (long)leiaute.getTamanhoRegistro()));
            barra.setValorMaximo(tamanhoBarra);
            barra.inicializar("Importando dados. Aguarde...", tamanhoBarra, false);
            leiaute.setArquivoOrigem(arq.getParent());
            LeiauteBD.getLeiauteBD().salvar(leiaute);
            ar.abrirArquivoEntrada(arq);
            RegistroRemessa reg = ar.lerRegistro(true);
            int i = 0;
            while (reg != null) {
                this.interfaceImportacao.importar(reg);
                reg = ar.lerRegistro();
                barra.setValor(i++);
            }
            ar.fecharArquivoEntrada();
            barra.finalizar();
            this.interfaceImportacao.finalizarImportacao();
            if (this.exibirMensagemConfirmacao("Mensagem da aplica\u00e7\u00e3o", "Deseja mover o arquivo para a pasta 'importados'?")) {
                arq.renameTo(new File(String.valueOf(ControleAplicacao.getDiretorioImportados()) + Util.gerarNomeArquivoNovo(ControleAplicacao.getDiretorioImportados())));
            }
        }
        catch (Throwable t) {
            try {
                barra.finalizar();
                this.interfaceImportacao.abortarImportacao(t);
                try {
                    ar.fecharArquivoEntrada();
                }
                catch (Throwable tamanhoBarra) {}
            }
            catch (Throwable t1) {
                this.exibirMensagemErro(t1);
            }
        }
    }

    public void imprimir(Leiaute leiaute) {
        try {
            ControleImpressao.getControle().setLinhasPorPagina(63);
            ControleImpressao.getControle().setCodigoRelatorio("  ");
            Linha linha = this.getNovaLinha();
            Vector<Linha> linhas = new Vector<Linha>();
            int tab1 = 10;
            int tab2 = 55;
            int tab3 = 34;
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTexto("Dados do Leiaute");
            linha.setFonte(new Font("monospaced", 1, 12));
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("Descri\u00e7\u00e3o do leiaute   : " + leiaute.getDescricaoLeiaute());
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("Localiza\u00e7\u00e3o do arquivo : " + leiaute.getArquivoOrigem());
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("Tamanho do registro    : " + leiaute.getTamanhoRegistro());
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("Formato do arquivo   ");
            linha.setFonte(new Font("monospaced", 1, 10));
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTexto("Descri\u00e7\u00e3o                               In\u00edcio   Fim     Tamanho");
            linhas.addElement(linha);
            linhas.addElement(this.getTraco());
            Vector camposLeiaute = leiaute.getCampos();
            int j = 0;
            while (j < camposLeiaute.size()) {
                linha = this.getNovaLinha();
                CampoLeiaute campoLeiaute = (CampoLeiaute)camposLeiaute.elementAt(j);
                linha.setTexto(String.valueOf(Util.padL(campoLeiaute.getDescricaoCampo(), 40, " ")) + Util.padR(String.valueOf(campoLeiaute.getPosicaoInicio()), 6, " ") + Util.padR(String.valueOf(campoLeiaute.getPosicaoInicio() + campoLeiaute.getTamanhoCampo() - 1), 6, " ") + Util.padR(String.valueOf(campoLeiaute.getTamanhoCampo()), 12, " "));
                linhas.addElement(linha);
                ++j;
            }
            linhas.addElement(this.getTraco());
            ControleImpressao.getControle().setCodigoRelatorio(null);
            ControleImpressao.getControle().setTituloVisualizacao("Leiaute de arquivo de importa\u00e7\u00e3o");
            ControleImpressao.getControle().imprimirLinhas(linhas, "Descri\u00e7\u00e3o do Leiaute de Importa\u00e7\u00e3o de Dados");
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
    }

    public void incluirLeiaute(Leiaute leiaute) {
        try {
            LeiauteBD.getLeiauteBD().salvar(leiaute);
        }
        catch (SQLException e) {
            this.exibirMensagemErro(e);
        }
    }

    public Leiaute obterLeiaute(Leiaute leiaute) throws SQLException {
        LeiauteBD.getLeiauteBD().obter(leiaute);
        return leiaute;
    }

    public Vector obterListaLeiaute(String codigoLeiaute) throws SQLException {
        return LeiauteBD.getLeiauteBD().obterLista(codigoLeiaute);
    }

    public Vector obterListaTipoLeiaute() throws SQLException {
        return TipoLeiauteBD.getTipoLeiauteBD().obterLista();
    }

    public void salvar(Leiaute leiaute) throws SQLException {
        LeiauteBD.getLeiauteBD().salvar(leiaute);
    }
}

