/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    protected boolean monitorOn = false;
    protected boolean sourceMonitorOn = true;

    protected String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return String.valueOf(className.replace('.', '/')) + ".class";
        }
        return String.valueOf(className.replace('.', this.classNameReplacementChar)) + ".class";
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        this.monitor(">> MultiClassLoader.loadClass(" + className + ", " + resolveIt + ")");
        Class<?> result = (Class<?>)this.classes.get(className);
        if (result != null) {
            this.monitor(">> returning cached result.");
            return result;
        }
        try {
            result = super.findSystemClass(className);
            this.monitor(">> returning system class (in CLASSPATH).");
            return result;
        }
        catch (ClassNotFoundException e) {
            this.monitor(">> Not a system class.");
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException();
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            this.monitor(">> Returning newly loaded class.");
            return result;
        }
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected void monitor(String text) {
        if (this.monitorOn) {
            MultiClassLoader.print(text);
        }
    }

    protected static void print(String text) {
        System.out.println(text);
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }
}

