/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.infraestrutura;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Plugin;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.PluginBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class RoteadorUtilitarios
extends Roteador
implements GerenciadorListasListener {
    private static RoteadorUtilitarios roteadorUtilitarios = null;
    private IInterfaceGerenciadorListas interfaceListaArquivos;

    private RoteadorUtilitarios() {
    }

    public void abrirInterfaceBecape() {
        IInterfacePluginCadastro i = (IInterfacePluginCadastro)this.abrirInterface("Becape", null);
        i.incluir(null);
        i.exibir();
    }

    public void abrirInterfaceConfigurarBecape() throws SQLException {
        Vector plugin = PluginBD.getPluginBD().obterLista();
        this.getPlugin().setNumeroDiasBackup(((Plugin)plugin.elementAt(0)).getNumeroDiasBackup());
        if (this.getPlugin().getNumeroDiasBackup() == 0) {
            RoteadorUtilitarios.getRoteadorUtilitarios().exibirMensagem("ATEN\u00c7\u00c3O", "Op\u00e7\u00e3o indispon\u00edvel.", 1);
            return;
        }
        IInterfacePluginCadastro i = (IInterfacePluginCadastro)this.abrirInterface("ConfigurarBecape", null);
        i.incluir(null);
        i.exibir();
    }

    public void abrirInterfaceRestauracaoBecape() {
        IInterfacePluginCadastro i = (IInterfacePluginCadastro)this.abrirInterface("Becape", null);
        i.alterar(null);
        i.exibir();
    }

    public void abrirListaArquivos(String origem) throws Throwable {
        this.getInterfaceListaArquivos().listar(this.obterListaBackup(origem));
        this.getInterfaceListaArquivos().setModal(true);
        this.getInterfaceListaArquivos().exibir();
    }

    public void botaoAlterar(GerenciadorListasEvent event) {
    }

    public void botaoCancelar(GerenciadorListasEvent event) {
    }

    public void botaoDesmarcar(GerenciadorListasEvent event) {
    }

    public void botaoDetalhar(GerenciadorListasEvent event) {
    }

    public void botaoExcluir(GerenciadorListasEvent event) {
    }

    public void botaoFiltro(GerenciadorListasEvent event) {
    }

    public void botaoImprimir(GerenciadorListasEvent event, MultiColumnListbox multicolumn) {
        ControleImpressao.getControle().imprimir(multicolumn, "Rela\u00e7\u00e3o de c\u00f3pias de seguran\u00e7a");
    }

    public void botaoIncluir(GerenciadorListasEvent event) {
    }

    public void botaoMarcar(GerenciadorListasEvent event) {
    }

    public void botaoOK(GerenciadorListasEvent event) {
        if (event.getLinhas().length != 1) {
            this.exibirMensagem("Selecione um arquivo de origem para recuperar c\u00f3pia de seguran\u00e7a");
            event.setConsumido(true);
            return;
        }
        if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o", "Todo o movimento registrado ap\u00f3s a c\u00f3pia ter sido efetuada ser\u00e1 perdido. Confirma?")) {
            try {
                this.restaurarBackup((String)event.getLinhas()[0][0]);
            }
            catch (Throwable t) {
                this.exibirMensagem(t.getMessage());
            }
        } else {
            event.setConsumido(true);
        }
    }

    public void botaoSair(GerenciadorListasEvent event) {
    }

    public void efetuarBackup(String destino) throws Throwable {
        if (!destino.substring(destino.length() - 1).equals("\\")) {
            destino = String.valueOf(destino) + "\\";
        }
        String nomeBancoDados = String.valueOf(ControleAplicacao.getDiretorioDados()) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb";
        String arquivoTemporario = String.valueOf(ControleAplicacao.getDiretorioArquivos()) + ControleAplicacao.getPlugin().getCodigoPlugin() + Util.formatarData(new Date(), "AAAAMMDD") + ".CSB";
        String arquivoDestino = String.valueOf(destino) + ControleAplicacao.getPlugin().getCodigoPlugin() + Util.formatarData(new Date(), "AAAAMMDD") + ".CSB";
        boolean indDisquete = destino.substring(0, 1).equalsIgnoreCase("A") || destino.substring(0, 1).equalsIgnoreCase("B");
        File fileBD = new File(nomeBancoDados);
        File fileTMP = new File(arquivoTemporario);
        File fileDEST = new File(arquivoDestino);
        IBarraProgresso progresso = null;
        try {
            int lidos;
            progresso = this.obterBarraProgresso();
            int j = 0;
            while (fileDEST.exists()) {
                arquivoDestino = String.valueOf(destino) + ControleAplicacao.getPlugin().getCodigoPlugin() + Util.formatarData(new Date(), "AAAAMMDD") + String.valueOf(++j) + ".CSB";
                fileDEST = new File(arquivoDestino);
            }
            if (fileTMP.exists()) {
                fileTMP.delete();
            }
            ZipOutputStream novoArquivo = null;
            FileOutputStream out = null;
            out = new FileOutputStream(fileTMP);
            novoArquivo = new ZipOutputStream(out);
            ZipEntry ze = new ZipEntry(fileBD.getName());
            novoArquivo.putNextEntry(ze);
            FileInputStream fi = new FileInputStream(fileBD);
            int tamanhoArquivo = fi.available();
            progresso.inicializar("C\u00f3pia de seguran\u00e7a", tamanhoArquivo, false);
            progresso.setMensagem("Compactando arquivo em arquivo tempor\u00e1rio!");
            byte[] b = new byte[5096];
            while (fi.available() > 0) {
                lidos = fi.read(b);
                novoArquivo.write(b, 0, lidos);
                progresso.setValor(tamanhoArquivo - fi.available());
            }
            novoArquivo.closeEntry();
            novoArquivo.close();
            out.close();
            FileInputStream origem = new FileInputStream(fileTMP);
            FileOutputStream outDestino = new FileOutputStream(fileDEST);
            int disk = 1;
            String descricao = String.valueOf(ControleAplicacao.getPlugin().getCodigoPlugin()) + ";" + Util.formatarData(new Date(), "DD/MM/AAAA") + ";" + origem.available();
            descricao = String.valueOf(Util.strZero(String.valueOf(descricao.length() + 4), 3)) + (byte)disk + descricao;
            byte[] byteDescricao = new byte[descricao.length()];
            int i = 0;
            while (i < descricao.length()) {
                byteDescricao[i] = (byte)descricao.charAt(i);
                ++i;
            }
            byteDescricao[3] = (byte)disk;
            outDestino.write(byteDescricao);
            tamanhoArquivo = origem.available();
            progresso.setValor(0);
            progresso.setValorMaximo(tamanhoArquivo);
            progresso.setMensagem("Copiando arquivo para o destino!");
            lidos = 0;
            while (origem.available() > 0) {
                try {
                    lidos = origem.read(b);
                    outDestino.write(b, 0, lidos);
                }
                catch (IOException ioe) {
                    outDestino.close();
                    if (!indDisquete) {
                        throw new Throwable("Disco cheio!");
                    }
                    this.exibirMensagem("Insira um diquete vazio no drive! Etiquete-o como DISCO " + ++disk);
                    arquivoDestino = String.valueOf(arquivoDestino.substring(0, arquivoDestino.length() - 3)) + Util.strZero(String.valueOf(disk), 3);
                    fileDEST = new File(arquivoDestino);
                    if (fileDEST.exists()) {
                        fileDEST.delete();
                    }
                    outDestino = new FileOutputStream(fileDEST);
                    byteDescricao[3] = (byte)disk;
                    outDestino.write(byteDescricao);
                    outDestino.write(b, 0, lidos);
                }
                progresso.setValor(tamanhoArquivo - origem.available());
            }
            outDestino.close();
            progresso.finalizar();
            origem.close();
            this.exibirMensagem("C\u00f3pia de seguran\u00e7a efetuada com sucesso!");
            if (((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getDataEfetivacaoBackup() != null) {
                this.getPlugin().setDataEfetivacaoBackup(new Date());
                this.getPlugin().setIndicadorEfetivacaoBackup("S");
                this.getPlugin().setNumeroDiasBackup(((Plugin)PluginBD.getPluginBD().obterLista().elementAt(0)).getNumeroDiasBackup());
                PluginBD.getPluginBD().salvar(this.getPlugin());
            }
        }
        catch (Throwable t) {
            progresso.finalizar();
            throw t;
        }
    }

    private IInterfaceGerenciadorListas getInterfaceListaArquivos() {
        if (this.interfaceListaArquivos == null) {
            this.interfaceListaArquivos = (IInterfaceGerenciadorListas)this.abrirInterface("ListaRestauracao", null);
            this.interfaceListaArquivos.addGerenciadorListasListener(this);
            this.interfaceListaArquivos.addColuna("Nome do Arquivo", 75, true, true);
            this.interfaceListaArquivos.addColuna("Data do arquivo", 25, 1, true, true);
            this.interfaceListaArquivos.setTitulo("Selecione o arquivo de c\u00f3pia de seguran\u00e7a a ser restaurado e clique em OK");
            this.interfaceListaArquivos.setTituloRelatorio("C\u00f3pias de seguran\u00e7a localizadas no diret\u00f3rio informado.");
            this.interfaceListaArquivos.habilitarMultiplaSelecao(false);
            this.interfaceListaArquivos.setLayout(2);
        }
        return this.interfaceListaArquivos;
    }

    public static RoteadorUtilitarios getRoteadorUtilitarios() {
        if (roteadorUtilitarios == null) {
            roteadorUtilitarios = new RoteadorUtilitarios();
        }
        return roteadorUtilitarios;
    }

    public static void main(String[] args) {
    }

    public Vector obterListaBackup(String origem) throws Throwable {
        File dir = new File(origem);
        String[] arquivos = dir.list();
        File f = null;
        FileInputStream fis = null;
        Vector<String[]> lista = new Vector<String[]>();
        int i = 0;
        while (i < arquivos.length) {
            f = new File(String.valueOf(origem) + arquivos[i]);
            try {
                String cabecalho;
                String sigla;
                byte[] b1;
                byte[] b;
                int nroBytes;
                if (f.isFile() && (nroBytes = (fis = new FileInputStream(f)).read(b = new byte[3])) == 3 && (nroBytes = fis.read(b1 = new byte[Integer.parseInt(new String(b)) - 3])) == Integer.parseInt(new String(b)) - 3 && (sigla = new String(b1, 1, (cabecalho = new String(b1)).indexOf(59) - 1)).equalsIgnoreCase(ControleAplicacao.getPlugin().getCodigoPlugin()) && b1[0] == 1) {
                    try {
                        String[] linha = new String[]{String.valueOf(origem) + arquivos[i], cabecalho.substring(cabecalho.indexOf(59) + 1, 11 + cabecalho.indexOf(59))};
                        lista.addElement(linha);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return lista;
    }

    /*
     * Unable to fully structure code
     */
    public void restaurarBackup(String arquivoOrigem) throws Throwable {
        block12: {
            f = new File(arquivoOrigem);
            fis = null;
            fileTMP = new File(String.valueOf(ControleAplicacao.getDiretorioArquivos()) + "RESTTMP.CSB");
            fos = null;
            atual = new File(String.valueOf(ControleAplicacao.getDiretorioDados()) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
            old = new File(String.valueOf(ControleAplicacao.getDiretorioDados()) + "BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".old");
            tamanhoArquivo = 0;
            lidos = 0;
            progresso = this.obterBarraProgresso();
            try {
                progresso.inicializar("Restaurando c\u00f3pia de seguran\u00e7a", 0, false);
                if (fileTMP.exists()) {
                    fileTMP.delete();
                }
                if ((nroBytes = (fis = new FileInputStream(f)).read(b = new byte[3])) != 3) break block12;
                try {
                    block13: {
                        nroBytes = Integer.valueOf(new String(b, 0, 3));
                        b = new byte[nroBytes - 3];
                        fis.read(b);
                        cabecalho = new String(b);
                        primeiroSeparador = cabecalho.indexOf(59);
                        segundoSeparador = cabecalho.indexOf(59, primeiroSeparador + 1);
                        tamanhoArquivo = Integer.valueOf(cabecalho.substring(segundoSeparador + 1, cabecalho.length()));
                        progresso.setValorMaximo(tamanhoArquivo);
                        tamanhoLido = 0;
                        fos = new FileOutputStream(fileTMP);
                        b = new byte[5096];
                        disk = 1;
                        block6: while (true) {
                            if ((lidos = fis.read(b)) > 0) {
                                progresso.setValor(tamanhoLido += lidos);
                                fos.write(b, 0, lidos);
                                continue;
                            }
                            fis.close();
                            if (tamanhoLido >= tamanhoArquivo) break;
                            ++disk;
                            while (true) {
                                this.exibirMensagem("Insira o DISCO " + disk + " no drive");
                                f = new File(String.valueOf(arquivoOrigem.substring(0, arquivoOrigem.length() - 3)) + Util.strZero(String.valueOf(disk), 3));
                                if (!f.exists()) continue;
                                fis = new FileInputStream(f);
                                b1 = new byte[nroBytes];
                                fis.read(b1);
                                if (b1[3] != (byte)disk) ** break;
                                continue block6;
                                this.exibirMensagem("Disco fora de sequ\u00eancia!");
                            }
                            break;
                        }
                        fos.close();
                        ConexaoBancoDados.desconectar();
                        try {
                            if (old.exists()) {
                                old.delete();
                            }
                            atual.renameTo(old);
                            zf = new ZipFile(fileTMP);
                            ze = zf.getEntry("BB" + ControleAplicacao.getPlugin().getCodigoPlugin() + ".mdb");
                            is = zf.getInputStream(ze);
                            fos = new FileOutputStream(atual);
                            progresso.setValor(0);
                            progresso.setMensagem("Descompactando arquivo!");
                            progresso.setValorMaximo((int)ze.getSize());
                            lidos = 0;
                            totalLido = 0;
                            while ((lidos = is.read(b)) > 0) {
                                fos.write(b, 0, lidos);
                                progresso.setValor(totalLido += lidos);
                            }
                            is.close();
                            zf.close();
                            fos.close();
                            this.exibirMensagem("Restaura\u00e7\u00e3o efetuada com sucesso! Ser\u00e1 necess\u00e1rio reiniciar o aplicativo.");
                            System.exit(0);
                        }
                        catch (Throwable t) {
                            System.out.println(t.getMessage());
                            if (atual.exists() || !old.exists()) break block13;
                            old.renameTo(atual);
                        }
                    }
                    ConexaoBancoDados.conectar();
                }
                catch (NumberFormatException nfe) {
                    System.out.println(nfe);
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
    }

    private void setInterfaceListaArquivos(IInterfaceGerenciadorListas newInterfaceListaArquivos) {
        this.interfaceListaArquivos = newInterfaceListaArquivos;
    }
}

